/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.email;

import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.firebase.ui.auth.FirebaseUiException;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.User;
import com.firebase.ui.auth.ui.FragmentBase;
import com.firebase.ui.auth.ui.email.CheckEmailHandler;
import com.firebase.ui.auth.util.data.PrivacyDisclosureUtils;
import com.firebase.ui.auth.util.ui.ImeHelper;
import com.firebase.ui.auth.util.ui.fieldvalidators.EmailFieldValidator;
import com.firebase.ui.auth.viewmodel.ResourceObserver;
import com.google.android.material.snackbar.Snackbar;
import com.google.android.material.textfield.TextInputLayout;
import com.google.firebase.FirebaseNetworkException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class CheckEmailFragment
extends FragmentBase
implements View.OnClickListener,
ImeHelper.DonePressedListener {
    public static final String TAG = "CheckEmailFragment";
    private CheckEmailHandler mHandler;
    private Button mNextButton;
    private ProgressBar mProgressBar;
    private EditText mEmailEditText;
    private TextInputLayout mEmailLayout;
    private EmailFieldValidator mEmailFieldValidator;
    private CheckEmailListener mListener;

    public static CheckEmailFragment newInstance(@Nullable String email) {
        CheckEmailFragment fragment = new CheckEmailFragment();
        Bundle args = new Bundle();
        args.putString("extra_email", email);
        fragment.setArguments(args);
        return fragment;
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fui_check_email_layout, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        this.mNextButton = (Button)view.findViewById(R.id.button_next);
        this.mProgressBar = (ProgressBar)view.findViewById(R.id.top_progress_bar);
        this.mEmailLayout = (TextInputLayout)view.findViewById(R.id.email_layout);
        this.mEmailEditText = (EditText)view.findViewById(R.id.email);
        this.mEmailFieldValidator = new EmailFieldValidator(this.mEmailLayout);
        this.mEmailLayout.setOnClickListener((View.OnClickListener)this);
        this.mEmailEditText.setOnClickListener((View.OnClickListener)this);
        TextView headerText = (TextView)view.findViewById(R.id.header_text);
        if (headerText != null) {
            headerText.setVisibility(8);
        }
        ImeHelper.setImeOnDoneListener(this.mEmailEditText, this);
        if (Build.VERSION.SDK_INT >= 26 && this.getFlowParams().enableHints) {
            this.mEmailEditText.setImportantForAutofill(2);
        }
        this.mNextButton.setOnClickListener((View.OnClickListener)this);
        TextView termsText = (TextView)view.findViewById(R.id.email_tos_and_pp_text);
        TextView footerText = (TextView)view.findViewById(R.id.email_footer_tos_and_pp_text);
        FlowParameters flowParameters = this.getFlowParams();
        if (!flowParameters.shouldShowProviderChoice()) {
            PrivacyDisclosureUtils.setupTermsOfServiceAndPrivacyPolicyText(this.requireContext(), flowParameters, termsText);
        } else {
            termsText.setVisibility(8);
            PrivacyDisclosureUtils.setupTermsOfServiceFooter(this.requireContext(), flowParameters, footerText);
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mHandler = (CheckEmailHandler)new ViewModelProvider((ViewModelStoreOwner)this).get(CheckEmailHandler.class);
        this.mHandler.init(this.getFlowParams());
        FragmentActivity activity = this.getActivity();
        if (!(activity instanceof CheckEmailListener)) {
            throw new IllegalStateException("Activity must implement CheckEmailListener");
        }
        this.mListener = (CheckEmailListener)activity;
        this.mHandler.getOperation().observe(this.getViewLifecycleOwner(), (Observer)new ResourceObserver<User>((FragmentBase)this, R.string.fui_progress_dialog_checking_accounts){

            @Override
            protected void onSuccess(@NonNull User user) {
                String email = user.getEmail();
                String provider = user.getProviderId();
                CheckEmailFragment.this.mEmailEditText.setText((CharSequence)email);
                if (provider == null) {
                    CheckEmailFragment.this.mListener.onNewUser(new User.Builder("password", email).setName(user.getName()).setPhotoUri(user.getPhotoUri()).build());
                } else if (provider.equals("password") || provider.equals("emailLink")) {
                    CheckEmailFragment.this.mListener.onExistingEmailUser(user);
                } else {
                    CheckEmailFragment.this.mListener.onExistingIdpUser(user);
                }
            }

            @Override
            protected void onFailure(@NonNull Exception e) {
                if (e instanceof FirebaseUiException && ((FirebaseUiException)e).getErrorCode() == 3) {
                    CheckEmailFragment.this.mListener.onDeveloperFailure(e);
                }
                if (e instanceof FirebaseNetworkException) {
                    Snackbar.make((View)CheckEmailFragment.this.getView(), (CharSequence)CheckEmailFragment.this.getString(R.string.fui_no_internet), (int)-1).show();
                }
            }
        });
        if (savedInstanceState != null) {
            return;
        }
        String email = this.getArguments().getString("extra_email");
        if (!TextUtils.isEmpty((CharSequence)email)) {
            this.mEmailEditText.setText((CharSequence)email);
            this.validateAndProceed();
        } else if (this.getFlowParams().enableHints) {
            this.mHandler.fetchCredential();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mHandler.onActivityResult(requestCode, resultCode, data);
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.button_next) {
            this.validateAndProceed();
        } else if (id2 == R.id.email_layout || id2 == R.id.email) {
            this.mEmailLayout.setError(null);
        }
    }

    @Override
    public void onDonePressed() {
        this.validateAndProceed();
    }

    private void validateAndProceed() {
        String email = this.mEmailEditText.getText().toString();
        if (this.mEmailFieldValidator.validate(email)) {
            this.mHandler.fetchProvider(email);
        }
    }

    @Override
    public void showProgress(int message) {
        this.mNextButton.setEnabled(false);
        this.mProgressBar.setVisibility(0);
    }

    @Override
    public void hideProgress() {
        this.mNextButton.setEnabled(true);
        this.mProgressBar.setVisibility(4);
    }

    static interface CheckEmailListener {
        public void onExistingEmailUser(User var1);

        public void onExistingIdpUser(User var1);

        public void onNewUser(User var1);

        public void onDeveloperFailure(Exception var1);
    }
}

