/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui;

import android.annotation.SuppressLint;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.ui.HelperActivityBase;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class AppCompatBase
extends HelperActivityBase {
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(R.style.FirebaseUI);
        this.setTheme(this.getFlowParams().themeId);
        if (this.getFlowParams().lockOrientation) {
            this.lockOrientation();
        }
    }

    protected void switchFragment(@NonNull Fragment fragment, int fragmentId, @NonNull String tag, boolean withTransition, boolean addToBackStack) {
        FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
        if (withTransition) {
            ft.setCustomAnimations(R.anim.fui_slide_in_right, R.anim.fui_slide_out_left);
        }
        ft.replace(fragmentId, fragment, tag);
        if (addToBackStack) {
            ft.addToBackStack(null).commit();
        } else {
            ft.disallowAddToBackStack().commit();
        }
    }

    protected void switchFragment(@NonNull Fragment fragment, int fragmentId, @NonNull String tag) {
        this.switchFragment(fragment, fragmentId, tag, false, false);
    }

    @SuppressLint(value={"SourceLockedOrientationActivity"})
    private void lockOrientation() {
        this.setRequestedOrientation(1);
    }
}

