/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.data.remote;

import android.app.Application;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.data.remote.GenericIdpSignInHandler;
import com.firebase.ui.auth.ui.HelperActivityBase;
import com.firebase.ui.auth.util.data.AuthOperationManager;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.OAuthCredential;
import com.google.firebase.auth.OAuthProvider;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class GenericIdpAnonymousUpgradeLinkingHandler
extends GenericIdpSignInHandler {
    public GenericIdpAnonymousUpgradeLinkingHandler(Application application) {
        super(application);
    }

    @Override
    public void startSignIn(@NonNull FirebaseAuth auth, @NonNull HelperActivityBase activity, @NonNull String providerId) {
        this.setResult(Resource.forLoading());
        FlowParameters flowParameters = activity.getFlowParams();
        OAuthProvider provider = this.buildOAuthProvider(providerId, auth);
        if (flowParameters != null && AuthOperationManager.getInstance().canUpgradeAnonymous(auth, flowParameters)) {
            this.handleAnonymousUpgradeLinkingFlow(activity, provider, flowParameters);
            return;
        }
        this.handleNormalSignInFlow(auth, activity, provider);
    }

    private void handleAnonymousUpgradeLinkingFlow(HelperActivityBase activity, OAuthProvider provider, FlowParameters flowParameters) {
        boolean useEmulator = activity.getAuthUI().isUseEmulator();
        AuthOperationManager.getInstance().safeGenericIdpSignIn(activity, provider, flowParameters).addOnSuccessListener(authResult -> this.handleSuccess(useEmulator, provider.getProviderId(), authResult.getUser(), (OAuthCredential)authResult.getCredential(), true)).addOnFailureListener(e -> this.setResult(Resource.forFailure(e)));
    }
}

