/*
 * Decompiled with CFR 0.152.
 */
package com.fintonic.versioning.domain;

public class Version
implements Comparable<Version> {
    public static final String MAX_VERSION = "99.99";
    private final int major;
    private final int minor;

    public Version(String version) {
        String[] tokens = version.split("\\.");
        if (tokens.length != 2) {
            throw new IllegalArgumentException("Invalid version " + version + ". The version must have major and minor number.");
        }
        this.major = Integer.parseInt(tokens[0].replace("v", ""));
        this.minor = Integer.parseInt(tokens[1]);
    }

    @Override
    public int compareTo(Version other) {
        if (this.major > other.major) {
            return 1;
        }
        if (this.major < other.major) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        return 0;
    }

    public String getVersionString() {
        return this.major + "." + this.minor;
    }

    public String toString() {
        return "v" + this.major + "." + this.minor;
    }
}

