/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2a.java.services;

import com.fintecsystems.xs2a.java.helper.JsonSerializer;
import com.fintecsystems.xs2a.java.models.AccountSnapshotFormat;
import com.fintecsystems.xs2a.java.models.AccountStatement;
import com.fintecsystems.xs2a.java.models.CountryId;
import com.fintecsystems.xs2a.java.models.EventsList;
import com.fintecsystems.xs2a.java.models.ReportFormat;
import com.fintecsystems.xs2a.java.models.ReportLocale;
import com.fintecsystems.xs2a.java.models.RiskObject;
import com.fintecsystems.xs2a.java.models.RisksTransactionList;
import com.fintecsystems.xs2a.java.models.WizardSessionResponse;
import com.fintecsystems.xs2a.java.models.Xs2aRisk;
import com.fintecsystems.xs2a.java.models.Xs2aRiskUploadJsonSuccess;
import com.fintecsystems.xs2a.java.models.Xs2aRiskUploadJsonWrapper;
import com.fintecsystems.xs2a.java.services.ApiService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\fJ\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0003J#\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001bJ\u000e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003J,\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u001f\u001a\u00020\u00032\b\b\u0002\u0010\u0015\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\"Jn\u0010#\u001a\u00020$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010+\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001b2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010-R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/fintecsystems/xs2a/java/services/RiskService;", "", "apiKey", "", "(Ljava/lang/String;)V", "completeManually", "Lcom/fintecsystems/xs2a/java/models/Xs2aRiskUploadJsonSuccess;", "wizardSessionId", "body", "Lcom/fintecsystems/xs2a/java/models/Xs2aRiskUploadJsonWrapper;", "create", "Lcom/fintecsystems/xs2a/java/models/WizardSessionResponse;", "Lcom/fintecsystems/xs2a/java/models/Xs2aRisk;", "delete", "", "transactionId", "get", "Lcom/fintecsystems/xs2a/java/models/RiskObject;", "getAccountSnapshot", "", "Lcom/fintecsystems/xs2a/java/models/AccountStatement;", "format", "Lcom/fintecsystems/xs2a/java/models/AccountSnapshotFormat;", "(Ljava/lang/String;Lcom/fintecsystems/xs2a/java/models/AccountSnapshotFormat;)[Lcom/fintecsystems/xs2a/java/models/AccountStatement;", "getEvents", "Lcom/fintecsystems/xs2a/java/models/EventsList;", "perPage", "", "page", "getFullPDF", "getReport", "reportId", "Lcom/fintecsystems/xs2a/java/models/ReportFormat;", "locale", "Lcom/fintecsystems/xs2a/java/models/ReportLocale;", "list", "Lcom/fintecsystems/xs2a/java/models/RisksTransactionList;", "account_holder", "iban", "bic", "country_id", "Lcom/fintecsystems/xs2a/java/models/CountryId;", "merchant_id", "per_page", "from", "Ljava/time/LocalDateTime;", "to", "xs2a-java"})
public final class RiskService {
    @NotNull
    private final String apiKey;

    public RiskService(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this.apiKey = apiKey;
    }

    @NotNull
    public final WizardSessionResponse create(@NotNull Xs2aRisk body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        ApiService apiService = new ApiService(this.apiKey, null, 2, null);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$toJson = false;
        String string = this_$iv.getMoshi().adapter(Xs2aRisk.class).toJson((Object)body);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moshi\n        .adapter(T::class.java)\n        .toJson(body)");
        String response = apiService.post("risks", string);
        this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(WizardSessionResponse.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (WizardSessionResponse)object;
    }

    @NotNull
    public final RiskObject get(@NotNull String transactionId) {
        Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
        String response = ApiService.get$default(new ApiService(this.apiKey, null, 2, null), Intrinsics.stringPlus((String)"risks/", (Object)transactionId), null, 2, null);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(RiskObject.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (RiskObject)object;
    }

    @NotNull
    public final AccountStatement[] getAccountSnapshot(@NotNull String transactionId, @NotNull AccountSnapshotFormat format) {
        Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"format", (Object)format.getValue())};
        String response = new ApiService(this.apiKey, null, 2, null).get("risks/" + transactionId + "/accountSnapshot", MapsKt.mutableMapOf((Pair[])pairArray));
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(AccountStatement[].class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (AccountStatement[])object;
    }

    public static /* synthetic */ AccountStatement[] getAccountSnapshot$default(RiskService riskService, String string, AccountSnapshotFormat accountSnapshotFormat, int n, Object object) {
        if ((n & 2) != 0) {
            accountSnapshotFormat = AccountSnapshotFormat.JSON2;
        }
        return riskService.getAccountSnapshot(string, accountSnapshotFormat);
    }

    @NotNull
    public final String getFullPDF(@NotNull String transactionId) {
        Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
        return ApiService.get$default(new ApiService(this.apiKey, null, 2, null), "risks/" + transactionId + "/fullpdf", null, 2, null);
    }

    @NotNull
    public final Object getReport(@NotNull String transactionId, @NotNull String reportId, @NotNull ReportFormat format, @NotNull ReportLocale locale) {
        Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
        Intrinsics.checkNotNullParameter((Object)reportId, (String)"reportId");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Intrinsics.checkNotNullParameter((Object)((Object)locale), (String)"locale");
        String uri = "risks/" + transactionId + "/report";
        CharSequence charSequence = reportId;
        boolean bl = false;
        if (charSequence.length() > 0) {
            uri = uri + '/' + reportId;
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"format", (Object)format.getValue()), TuplesKt.to((Object)"locale", (Object)locale.getValue())};
        Map queryParameters = MapsKt.mutableMapOf((Pair[])pairArray);
        return new ApiService(this.apiKey, null, 2, null).get(uri, queryParameters);
    }

    public static /* synthetic */ Object getReport$default(RiskService riskService, String string, String string2, ReportFormat reportFormat, ReportLocale reportLocale, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            reportFormat = ReportFormat.JSON;
        }
        if ((n & 8) != 0) {
            reportLocale = ReportLocale.EN;
        }
        return riskService.getReport(string, string2, reportFormat, reportLocale);
    }

    @NotNull
    public final EventsList getEvents(@NotNull String transactionId, int perPage, int page) {
        Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"per_page", (Object)String.valueOf(perPage)), TuplesKt.to((Object)"page", (Object)String.valueOf(page))};
        Map queryParameters = MapsKt.mutableMapOf((Pair[])pairArray);
        String response = new ApiService(this.apiKey, null, 2, null).get("risks/" + transactionId + "/events", queryParameters);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(EventsList.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (EventsList)object;
    }

    public static /* synthetic */ EventsList getEvents$default(RiskService riskService, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 15;
        }
        if ((n3 & 4) != 0) {
            n2 = 1;
        }
        return riskService.getEvents(string, n, n2);
    }

    @NotNull
    public final Xs2aRiskUploadJsonSuccess completeManually(@NotNull String wizardSessionId, @NotNull Xs2aRiskUploadJsonWrapper body) {
        Intrinsics.checkNotNullParameter((Object)wizardSessionId, (String)"wizardSessionId");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        ApiService apiService = new ApiService(this.apiKey, null, 2, null);
        String string = Intrinsics.stringPlus((String)"risks/upload/", (Object)wizardSessionId);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$toJson = false;
        String string2 = this_$iv.getMoshi().adapter(Xs2aRiskUploadJsonWrapper.class).toJson((Object)body);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"moshi\n        .adapter(T::class.java)\n        .toJson(body)");
        String response = apiService.post(string, string2);
        this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(Xs2aRiskUploadJsonSuccess.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (Xs2aRiskUploadJsonSuccess)object;
    }

    @NotNull
    public final Map<String, Object> delete(@NotNull String transactionId) {
        Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
        String response = new ApiService(this.apiKey, null, 2, null).delete(Intrinsics.stringPlus((String)"risks/", (Object)transactionId));
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(Map.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (Map)object;
    }

    @NotNull
    public final RisksTransactionList list(@Nullable String account_holder, @Nullable String iban, @Nullable String bic, @Nullable CountryId country_id, @Nullable String merchant_id, int per_page, int page, @Nullable LocalDateTime from, @Nullable LocalDateTime to) {
        String string;
        CountryId countryId;
        String fromToUse = null;
        String toToUse = null;
        if (from != null) {
            fromToUse = from.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        if (to != null) {
            toToUse = to.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"account_holder", (Object)account_holder), TuplesKt.to((Object)"iban", (Object)iban), TuplesKt.to((Object)"bic", (Object)bic), TuplesKt.to((Object)"country_id", (Object)((countryId = country_id) == null ? "" : ((string = countryId.getValue()) == null ? "" : string))), TuplesKt.to((Object)"merchant_id", (Object)merchant_id), TuplesKt.to((Object)"per_page", (Object)String.valueOf(per_page)), TuplesKt.to((Object)"page", (Object)String.valueOf(page)), TuplesKt.to((Object)"from", (Object)fromToUse), TuplesKt.to((Object)"to", (Object)toToUse)};
        String response = new ApiService(this.apiKey, null, 2, null).get("risks", MapsKt.mutableMapOf((Pair[])pairArray));
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(RisksTransactionList.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (RisksTransactionList)object;
    }

    public static /* synthetic */ RisksTransactionList list$default(RiskService riskService, String string, String string2, String string3, CountryId countryId, String string4, int n, int n2, LocalDateTime localDateTime, LocalDateTime localDateTime2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = null;
        }
        if ((n3 & 2) != 0) {
            string2 = null;
        }
        if ((n3 & 4) != 0) {
            string3 = null;
        }
        if ((n3 & 8) != 0) {
            countryId = null;
        }
        if ((n3 & 0x10) != 0) {
            string4 = null;
        }
        if ((n3 & 0x20) != 0) {
            n = 15;
        }
        if ((n3 & 0x40) != 0) {
            n2 = 1;
        }
        if ((n3 & 0x80) != 0) {
            localDateTime = null;
        }
        if ((n3 & 0x100) != 0) {
            localDateTime2 = null;
        }
        return riskService.list(string, string2, string3, countryId, string4, n, n2, localDateTime, localDateTime2);
    }
}

