/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2a.java.services;

import com.fintecsystems.xs2a.java.helper.JsonSerializer;
import com.fintecsystems.xs2a.java.models.BankObject;
import com.fintecsystems.xs2a.java.models.BankObjectList;
import com.fintecsystems.xs2a.java.models.CountryId;
import com.fintecsystems.xs2a.java.services.ApiService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003J&\u0010\u000e\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/fintecsystems/xs2a/java/services/BankCodesService;", "", "apiKey", "", "(Ljava/lang/String;)V", "autocompleteSearch", "Lcom/fintecsystems/xs2a/java/models/BankObjectList;", "query", "countryId", "Lcom/fintecsystems/xs2a/java/models/CountryId;", "per_page", "", "page", "product", "filterAllBanks", "getBankByCode", "Lcom/fintecsystems/xs2a/java/models/BankObject;", "bankCode", "xs2a-java"})
public final class BankCodesService {
    @NotNull
    private final String apiKey;

    public BankCodesService(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this.apiKey = apiKey;
    }

    @NotNull
    public final BankObject getBankByCode(@NotNull String bankCode) {
        Intrinsics.checkNotNullParameter((Object)bankCode, (String)"bankCode");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"bank_code", (Object)bankCode)};
        String response = new ApiService(this.apiKey, null, 2, null).get("bankcodes", MapsKt.mutableMapOf((Pair[])pairArray));
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(BankObject.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (BankObject)object;
    }

    @NotNull
    public final BankObjectList filterAllBanks(@Nullable CountryId countryId, int per_page, int page) {
        String string;
        CountryId countryId2 = countryId;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"country_id", (Object)(countryId2 == null ? "" : ((string = countryId2.getValue()) == null ? "" : string))), TuplesKt.to((Object)"per_page", (Object)String.valueOf(per_page)), TuplesKt.to((Object)"page", (Object)String.valueOf(page))};
        String response = new ApiService(this.apiKey, null, 2, null).get("bankcodes/all", MapsKt.mutableMapOf((Pair[])pairArray));
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(BankObjectList.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (BankObjectList)object;
    }

    public static /* synthetic */ BankObjectList filterAllBanks$default(BankCodesService bankCodesService, CountryId countryId, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            countryId = null;
        }
        if ((n3 & 2) != 0) {
            n = 15;
        }
        if ((n3 & 4) != 0) {
            n2 = 1;
        }
        return bankCodesService.filterAllBanks(countryId, n, n2);
    }

    @NotNull
    public final BankObjectList autocompleteSearch(@NotNull String query, @Nullable CountryId countryId, int per_page, int page, @Nullable String product) {
        String string;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to((Object)"q", (Object)query);
        CountryId countryId2 = countryId;
        pairArray[1] = TuplesKt.to((Object)"country_id", (Object)(countryId2 == null ? "" : ((string = countryId2.getValue()) == null ? "" : string)));
        pairArray[2] = TuplesKt.to((Object)"per_page", (Object)String.valueOf(per_page));
        pairArray[3] = TuplesKt.to((Object)"page", (Object)String.valueOf(page));
        pairArray[4] = TuplesKt.to((Object)"product", (Object)product);
        String response = new ApiService(this.apiKey, null, 2, null).get("bankcodes/autocomplete", MapsKt.mutableMapOf((Pair[])pairArray));
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(BankObjectList.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (BankObjectList)object;
    }

    public static /* synthetic */ BankObjectList autocompleteSearch$default(BankCodesService bankCodesService, String string, CountryId countryId, int n, int n2, String string2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            countryId = null;
        }
        if ((n3 & 4) != 0) {
            n = 15;
        }
        if ((n3 & 8) != 0) {
            n2 = 1;
        }
        if ((n3 & 0x10) != 0) {
            string2 = null;
        }
        return bankCodesService.autocompleteSearch(string, countryId, n, n2, string2);
    }
}

