/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2a.java.services;

import com.fintecsystems.xs2a.java.exceptions.XS2AException;
import com.fintecsystems.xs2a.java.services.ApiService;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00112\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u000e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002J&\u0010\u0016\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0016\b\u0002\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0018J\u0018\u0010\u0019\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u0003J\u0018\u0010\u001b\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u0003J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J\u0018\u0010\u001e\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/fintecsystems/xs2a/java/services/ApiService;", "", "apiKey", "", "endpointVersion", "(Ljava/lang/String;Ljava/lang/String;)V", "basePath", "client", "Lokhttp3/OkHttpClient;", "mediaType", "Lokhttp3/MediaType;", "constructRequest", "Lokhttp3/Request;", "url", "middleware", "Lkotlin/Function1;", "Lokhttp3/Request$Builder;", "Lokhttp3/HttpUrl;", "delete", "executeRequest", "Lokhttp3/Response;", "request", "get", "queryParameters", "", "patch", "json", "post", "processResponse", "response", "put", "xs2a-java"})
public final class ApiService {
    @NotNull
    private final String apiKey;
    @NotNull
    private final String endpointVersion;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final String basePath;
    @NotNull
    private final MediaType mediaType;

    public ApiService(@NotNull String apiKey, @NotNull String endpointVersion) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)endpointVersion, (String)"endpointVersion");
        this.apiKey = apiKey;
        this.endpointVersion = endpointVersion;
        this.client = new OkHttpClient();
        this.basePath = Intrinsics.stringPlus((String)"https://api.xs2a.com/", (Object)this.endpointVersion);
        this.mediaType = MediaType.Companion.get("application/json; charset=utf-8");
    }

    public /* synthetic */ ApiService(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "v1";
        }
        this(string, string2);
    }

    @NotNull
    public final String post(@NotNull String url, @NotNull String json) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        RequestBody body = RequestBody.Companion.create(json, this.mediaType);
        Request request2 = this.constructRequest(url, (Function1<? super Request.Builder, ? extends Request.Builder>)((Function1)new Function1<Request.Builder, Request.Builder>(body){
            final /* synthetic */ RequestBody $body;
            {
                this.$body = $body;
                super(1);
            }

            @NotNull
            public final Request.Builder invoke(@NotNull Request.Builder it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.post(this.$body);
            }
        }));
        return this.processResponse(request2);
    }

    public static /* synthetic */ String post$default(ApiService apiService, String string, String string2, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return apiService.post(string, string2);
    }

    @NotNull
    public final String put(@NotNull String url, @NotNull String json) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        RequestBody body = RequestBody.Companion.create(json, this.mediaType);
        Request request2 = this.constructRequest(url, (Function1<? super Request.Builder, ? extends Request.Builder>)((Function1)new Function1<Request.Builder, Request.Builder>(body){
            final /* synthetic */ RequestBody $body;
            {
                this.$body = $body;
                super(1);
            }

            @NotNull
            public final Request.Builder invoke(@NotNull Request.Builder it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.put(this.$body);
            }
        }));
        return this.processResponse(request2);
    }

    public static /* synthetic */ String put$default(ApiService apiService, String string, String string2, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return apiService.put(string, string2);
    }

    @NotNull
    public final String patch(@NotNull String url, @NotNull String json) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        RequestBody body = RequestBody.Companion.create(json, this.mediaType);
        Request request2 = this.constructRequest(url, (Function1<? super Request.Builder, ? extends Request.Builder>)((Function1)new Function1<Request.Builder, Request.Builder>(body){
            final /* synthetic */ RequestBody $body;
            {
                this.$body = $body;
                super(1);
            }

            @NotNull
            public final Request.Builder invoke(@NotNull Request.Builder it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.patch(this.$body);
            }
        }));
        return this.processResponse(request2);
    }

    public static /* synthetic */ String patch$default(ApiService apiService, String string, String string2, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return apiService.patch(string, string2);
    }

    @NotNull
    public final String get(@NotNull String url, @NotNull Map<String, Object> queryParameters) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(queryParameters, (String)"queryParameters");
        Object[] objectArray = new Void[]{null};
        CollectionsKt.removeAll(queryParameters.values(), (Sequence)SequencesKt.sequenceOf((Object[])objectArray));
        HttpUrl.Builder builder = new HttpUrl.Builder().scheme("https").host("api.xs2a.com").addPathSegment(this.endpointVersion).addEncodedPathSegments(url);
        boolean bl = false;
        boolean bl2 = false;
        HttpUrl.Builder $this$get_u24lambda_u2d1 = builder;
        boolean bl3 = false;
        Map<String, Object> $this$forEach$iv = queryParameters;
        boolean $i$f$forEach = false;
        Map<String, Object> map = $this$forEach$iv;
        boolean bl4 = false;
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> element$iv;
            Map.Entry<String, Object> $dstr$k$v = element$iv = iterator.next();
            boolean bl5 = false;
            Map.Entry<String, Object> entry = $dstr$k$v;
            boolean bl6 = false;
            String k = entry.getKey();
            Map.Entry<String, Object> entry2 = $dstr$k$v;
            boolean bl7 = false;
            Object v = entry2.getValue();
            $this$get_u24lambda_u2d1.addQueryParameter(k, String.valueOf(v));
        }
        HttpUrl urlToRequest = builder.build();
        Request request2 = this.constructRequest(urlToRequest, (Function1<? super Request.Builder, ? extends Request.Builder>)((Function1)get.request.1.INSTANCE));
        return this.processResponse(request2);
    }

    public static /* synthetic */ String get$default(ApiService apiService, String string, Map map, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            boolean bl = false;
            map = new LinkedHashMap();
        }
        return apiService.get(string, map);
    }

    @NotNull
    public final String delete(@NotNull String url) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Request request2 = this.constructRequest(url, (Function1<? super Request.Builder, ? extends Request.Builder>)((Function1)delete.request.1.INSTANCE));
        return this.processResponse(request2);
    }

    private final Response executeRequest(Request request2) {
        return this.client.newCall(request2).execute();
    }

    private final Request constructRequest(String url, Function1<? super Request.Builder, ? extends Request.Builder> middleware) {
        return this.constructRequest(HttpUrl.Companion.get(this.basePath + '/' + url), middleware);
    }

    static /* synthetic */ Request constructRequest$default(ApiService apiService, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = constructRequest.1.INSTANCE;
        }
        return apiService.constructRequest(string, (Function1<? super Request.Builder, ? extends Request.Builder>)function1);
    }

    private final Request constructRequest(HttpUrl url, Function1<? super Request.Builder, ? extends Request.Builder> middleware) {
        Request.Builder builder = new Request.Builder().url(url).addHeader("Authorization", Credentials.basic$default((String)"api", (String)this.apiKey, null, (int)4, null));
        boolean bl = false;
        boolean bl2 = false;
        Request.Builder it = builder;
        boolean bl3 = false;
        return ((Request.Builder)middleware.invoke((Object)it)).build();
    }

    static /* synthetic */ Request constructRequest$default(ApiService apiService, HttpUrl httpUrl, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = constructRequest.2.INSTANCE;
        }
        return apiService.constructRequest(httpUrl, (Function1<? super Request.Builder, ? extends Request.Builder>)function1);
    }

    private final String processResponse(Request request2) {
        return this.processResponse(this.executeRequest(request2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String processResponse(Response response) throws IOException {
        String string;
        Closeable closeable = (Closeable)response;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Response it = (Response)closeable;
            boolean bl3 = false;
            if (!it.isSuccessful()) {
                ResponseBody responseBody = it.body();
                throw new XS2AException(responseBody == null ? null : responseBody.string(), it.code());
            }
            ResponseBody responseBody = it.body();
            Intrinsics.checkNotNull((Object)responseBody);
            string = responseBody.string();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }
}

