/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2a.java.services;

import com.fintecsystems.xs2a.java.helper.JsonSerializer;
import com.fintecsystems.xs2a.java.models.AccessToken;
import com.fintecsystems.xs2a.java.models.AccessTokenList;
import com.fintecsystems.xs2a.java.models.BankUser;
import com.fintecsystems.xs2a.java.models.BankUserCreationRequest;
import com.fintecsystems.xs2a.java.models.BankUserList;
import com.fintecsystems.xs2a.java.services.ApiService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003J\u0016\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0003J\u0016\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003J\u001a\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0016J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u0003J\u001e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/fintecsystems/xs2a/java/services/ApiBankUserService;", "", "apiKey", "", "(Ljava/lang/String;)V", "create", "Lcom/fintecsystems/xs2a/java/models/BankUser;", "body", "Lcom/fintecsystems/xs2a/java/models/BankUserCreationRequest;", "createAccessToken", "Lcom/fintecsystems/xs2a/java/models/AccessToken;", "userId", "validUntil", "Ljava/time/LocalDateTime;", "delete", "deleteAccessToken", "tokenId", "get", "getAccessToken", "list", "Lcom/fintecsystems/xs2a/java/models/BankUserList;", "per_page", "", "page", "listAccessTokens", "Lcom/fintecsystems/xs2a/java/models/AccessTokenList;", "refreshAccessToken", "xs2a-java"})
public final class ApiBankUserService {
    @NotNull
    private final String apiKey;

    public ApiBankUserService(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this.apiKey = apiKey;
    }

    @NotNull
    public final BankUser create(@NotNull BankUserCreationRequest body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        ApiService apiService = new ApiService(this.apiKey, null, 2, null);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$toJson = false;
        String string = this_$iv.getMoshi().adapter(BankUserCreationRequest.class).toJson((Object)body);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moshi\n        .adapter(T::class.java)\n        .toJson(body)");
        String response = apiService.put("api/users", string);
        this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(BankUser.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (BankUser)object;
    }

    @NotNull
    public final BankUser get(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        String response = ApiService.get$default(new ApiService(this.apiKey, null, 2, null), Intrinsics.stringPlus((String)"api/users/", (Object)userId), null, 2, null);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(BankUser.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (BankUser)object;
    }

    @NotNull
    public final String delete(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return new ApiService(this.apiKey, null, 2, null).delete(Intrinsics.stringPlus((String)"api/users/", (Object)userId));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AccessToken createAccessToken(@NotNull String userId, @NotNull LocalDateTime validUntil) {
        void body$iv;
        JsonSerializer this_$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)validUntil, (String)"validUntil");
        String dateString = validUntil.format(DateTimeFormatter.ISO_LOCAL_DATE) + ' ' + validUntil.format(DateTimeFormatter.ISO_LOCAL_TIME);
        ApiService apiService = new ApiService(this.apiKey, null, 2, null);
        String string = "api/users/" + userId + "/accesstokens";
        JsonSerializer jsonSerializer = JsonSerializer.INSTANCE;
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"valid_until", (Object)dateString));
        boolean $i$f$toJson = false;
        String string2 = this_$iv.getMoshi().adapter(Map.class).toJson((Object)body$iv);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"moshi\n        .adapter(T::class.java)\n        .toJson(body)");
        String response = apiService.put(string, string2);
        this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(AccessToken.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (AccessToken)object;
    }

    @NotNull
    public final AccessTokenList listAccessTokens(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        String response = ApiService.get$default(new ApiService(this.apiKey, null, 2, null), "api/users/" + userId + "/accesstokens", null, 2, null);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(AccessTokenList.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (AccessTokenList)object;
    }

    @NotNull
    public final AccessToken getAccessToken(@NotNull String userId, @NotNull String tokenId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
        String response = ApiService.get$default(new ApiService(this.apiKey, null, 2, null), "api/users/" + userId + "/accesstokens/" + tokenId, null, 2, null);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(AccessToken.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (AccessToken)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AccessToken refreshAccessToken(@NotNull String userId, @NotNull String tokenId, @NotNull LocalDateTime validUntil) {
        void body$iv;
        JsonSerializer this_$iv;
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
        Intrinsics.checkNotNullParameter((Object)validUntil, (String)"validUntil");
        ApiService apiService = new ApiService(this.apiKey, null, 2, null);
        String string = "api/users/" + userId + "/accesstokens/" + tokenId;
        JsonSerializer jsonSerializer = JsonSerializer.INSTANCE;
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"valid_until", (Object)validUntil));
        boolean $i$f$toJson = false;
        String string2 = this_$iv.getMoshi().adapter(Map.class).toJson((Object)body$iv);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"moshi\n        .adapter(T::class.java)\n        .toJson(body)");
        String response = apiService.patch(string, string2);
        this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(AccessToken.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (AccessToken)object;
    }

    @NotNull
    public final String deleteAccessToken(@NotNull String userId, @NotNull String tokenId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
        return new ApiService(this.apiKey, null, 2, null).delete("api/users/" + userId + "/accesstokens/" + tokenId);
    }

    @NotNull
    public final BankUserList list(int per_page, int page) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"per_page", (Object)String.valueOf(per_page)), TuplesKt.to((Object)"page", (Object)String.valueOf(page))};
        String response = new ApiService(this.apiKey, null, 2, null).get("api/users", MapsKt.mutableMapOf((Pair[])pairArray));
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(BankUserList.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (BankUserList)object;
    }

    public static /* synthetic */ BankUserList list$default(ApiBankUserService apiBankUserService, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 15;
        }
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        return apiBankUserService.list(n, n2);
    }
}

