/*
 * Decompiled with CFR 0.152.
 */
package com.fintecsystems.xs2a.java.services;

import com.fintecsystems.xs2a.java.helper.JsonSerializer;
import com.fintecsystems.xs2a.java.models.BankConnection;
import com.fintecsystems.xs2a.java.models.BankConnectionList;
import com.fintecsystems.xs2a.java.models.BankConnectionRequest;
import com.fintecsystems.xs2a.java.models.BankConnectionSyncRequest;
import com.fintecsystems.xs2a.java.models.WizardSessionResponse;
import com.fintecsystems.xs2a.java.services.ApiService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0003J\u001a\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0003J\u001a\u0010\u0013\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/fintecsystems/xs2a/java/services/ApiBankConnectionService;", "", "apiKey", "", "(Ljava/lang/String;)V", "create", "Lcom/fintecsystems/xs2a/java/models/WizardSessionResponse;", "body", "Lcom/fintecsystems/xs2a/java/models/BankConnectionRequest;", "delete", "connectionId", "get", "Lcom/fintecsystems/xs2a/java/models/BankConnection;", "list", "Lcom/fintecsystems/xs2a/java/models/BankConnectionList;", "per_page", "", "page", "reset", "sync", "request", "Lcom/fintecsystems/xs2a/java/models/BankConnectionSyncRequest;", "xs2a-java"})
public final class ApiBankConnectionService {
    @NotNull
    private final String apiKey;

    public ApiBankConnectionService(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this.apiKey = apiKey;
    }

    @NotNull
    public final WizardSessionResponse create(@NotNull BankConnectionRequest body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        ApiService apiService = new ApiService(this.apiKey, null, 2, null);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$toJson = false;
        String string = this_$iv.getMoshi().adapter(BankConnectionRequest.class).toJson((Object)body);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moshi\n        .adapter(T::class.java)\n        .toJson(body)");
        String response = apiService.put("api/connections", string);
        this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(WizardSessionResponse.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (WizardSessionResponse)object;
    }

    @NotNull
    public final BankConnectionList list(int per_page, int page) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"per_page", (Object)String.valueOf(per_page)), TuplesKt.to((Object)"page", (Object)String.valueOf(page))};
        String response = new ApiService(this.apiKey, null, 2, null).get("api/connections", MapsKt.mutableMapOf((Pair[])pairArray));
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(BankConnectionList.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (BankConnectionList)object;
    }

    public static /* synthetic */ BankConnectionList list$default(ApiBankConnectionService apiBankConnectionService, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 15;
        }
        if ((n3 & 2) != 0) {
            n2 = 1;
        }
        return apiBankConnectionService.list(n, n2);
    }

    @NotNull
    public final BankConnection get(@NotNull String connectionId) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        String response = ApiService.get$default(new ApiService(this.apiKey, null, 2, null), Intrinsics.stringPlus((String)"api/connections/", (Object)connectionId), null, 2, null);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(BankConnection.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (BankConnection)object;
    }

    @NotNull
    public final String delete(@NotNull String connectionId) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        return new ApiService(this.apiKey, null, 2, null).delete(Intrinsics.stringPlus((String)"api/connections/", (Object)connectionId));
    }

    @NotNull
    public final String sync(@NotNull String connectionId, @Nullable BankConnectionSyncRequest request2) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        ApiService apiService = new ApiService(this.apiKey, null, 2, null);
        String string = "api/connections/" + connectionId + "/sync";
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$toJson = false;
        String string2 = this_$iv.getMoshi().adapter(BankConnectionSyncRequest.class).toJson((Object)request2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"moshi\n        .adapter(T::class.java)\n        .toJson(body)");
        return apiService.post(string, string2);
    }

    public static /* synthetic */ String sync$default(ApiBankConnectionService apiBankConnectionService, String string, BankConnectionSyncRequest bankConnectionSyncRequest, int n, Object object) {
        if ((n & 2) != 0) {
            bankConnectionSyncRequest = null;
        }
        return apiBankConnectionService.sync(string, bankConnectionSyncRequest);
    }

    @NotNull
    public final WizardSessionResponse reset(@NotNull String connectionId) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        String response = ApiService.post$default(new ApiService(this.apiKey, null, 2, null), "api/connections/" + connectionId + "/reset", null, 2, null);
        JsonSerializer this_$iv = JsonSerializer.INSTANCE;
        boolean $i$f$parseJson = false;
        Object object = this_$iv.getMoshi().adapter(WizardSessionResponse.class).fromJson(response);
        Intrinsics.checkNotNull((Object)object);
        return (WizardSessionResponse)object;
    }
}

