/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionInsertionInfo;
import org.fife.ui.autocomplete.VariableCompletion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionCompletion
extends VariableCompletion
implements ParameterizedCompletion {
    private List<ParameterizedCompletion.Parameter> params;
    private String returnValDesc;

    public FunctionCompletion(CompletionProvider provider, String name, String returnType) {
        super(provider, name, returnType);
    }

    @Override
    protected void addDefinitionString(StringBuilder sb) {
        sb.append("<html><b>");
        sb.append(this.getDefinitionString());
        sb.append("</b>");
    }

    protected void addParameters(StringBuilder sb) {
        int paramCount = this.getParamCount();
        if (paramCount > 0) {
            sb.append("<b>Parameters:</b><br>");
            sb.append("<center><table width='90%'><tr><td>");
            for (int i = 0; i < paramCount; ++i) {
                ParameterizedCompletion.Parameter param = this.getParam(i);
                sb.append("<b>");
                sb.append(param.getName() != null ? param.getName() : param.getType());
                sb.append("</b>&nbsp;");
                String desc = param.getDescription();
                if (desc != null) {
                    sb.append(desc);
                }
                sb.append("<br>");
            }
            sb.append("</td></tr></table></center><br><br>");
        }
        if (this.returnValDesc != null) {
            sb.append("<b>Returns:</b><br><center><table width='90%'><tr><td>");
            sb.append(this.returnValDesc);
            sb.append("</td></tr></table></center><br><br>");
        }
    }

    @Override
    public String getDefinitionString() {
        StringBuilder sb = new StringBuilder();
        String type = this.getType();
        if (type != null) {
            sb.append(type).append(' ');
        }
        sb.append(this.getName());
        CompletionProvider provider = this.getProvider();
        char start = provider.getParameterListStart();
        if (start != '\u0000') {
            sb.append(start);
        }
        for (int i = 0; i < this.getParamCount(); ++i) {
            ParameterizedCompletion.Parameter param = this.getParam(i);
            type = param.getType();
            String name = param.getName();
            if (type != null) {
                sb.append(type);
                if (name != null) {
                    sb.append(' ');
                }
            }
            if (name != null) {
                sb.append(name);
            }
            if (i >= this.params.size() - 1) continue;
            sb.append(provider.getParameterListSeparator());
        }
        char end = provider.getParameterListEnd();
        if (end != '\u0000') {
            sb.append(end);
        }
        return sb.toString();
    }

    @Override
    public ParameterizedCompletionInsertionInfo getInsertionInfo(JTextComponent tc, boolean replaceTabsWithSpaces) {
        ParameterizedCompletionInsertionInfo info = new ParameterizedCompletionInsertionInfo();
        StringBuilder sb = new StringBuilder();
        char paramListStart = this.getProvider().getParameterListStart();
        if (paramListStart != '\u0000') {
            sb.append(paramListStart);
        }
        int dot = tc.getCaretPosition() + sb.length();
        int paramCount = this.getParamCount();
        int minPos = dot;
        Position maxPos = null;
        try {
            maxPos = tc.getDocument().createPosition(dot - sb.length() + 1);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        info.setCaretRange(minPos, maxPos);
        int firstParamLen = 0;
        int start = dot;
        for (int i = 0; i < paramCount; ++i) {
            ParameterizedCompletion.Parameter param = this.getParam(i);
            String paramText = this.getParamText(param);
            if (i == 0) {
                firstParamLen = paramText.length();
            }
            sb.append(paramText);
            int end = start + paramText.length();
            info.addReplacementLocation(start, end);
            String sep = this.getProvider().getParameterListSeparator();
            if (i >= paramCount - 1 || sep == null) continue;
            sb.append(sep);
            start = end + sep.length();
        }
        sb.append(this.getProvider().getParameterListEnd());
        int endOffs = dot + sb.length();
        info.addReplacementLocation(--endOffs, endOffs);
        info.setDefaultEndOffs(endOffs);
        int selectionEnd = paramCount > 0 ? dot + firstParamLen : dot;
        info.setInitialSelection(dot, selectionEnd);
        info.setTextToInsert(sb.toString());
        return info;
    }

    @Override
    public ParameterizedCompletion.Parameter getParam(int index) {
        return this.params.get(index);
    }

    @Override
    public int getParamCount() {
        return this.params == null ? 0 : this.params.size();
    }

    @Override
    public boolean getShowParameterToolTip() {
        return true;
    }

    private String getParamText(ParameterizedCompletion.Parameter param) {
        String text = param.getName();
        if (text == null && (text = param.getType()) == null) {
            text = "arg";
        }
        return text;
    }

    public String getReturnValueDescription() {
        return this.returnValDesc;
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        this.addDefinitionString(sb);
        if (!this.possiblyAddDescription(sb)) {
            sb.append("<br><br><br>");
        }
        this.addParameters(sb);
        this.possiblyAddDefinedIn(sb);
        return sb.toString();
    }

    @Override
    public String getToolTipText() {
        String text = this.getSummary();
        if (text == null) {
            text = this.getDefinitionString();
        }
        return text;
    }

    public void setParams(List<ParameterizedCompletion.Parameter> params) {
        if (params != null) {
            this.params = new ArrayList<ParameterizedCompletion.Parameter>(params);
        }
    }

    public void setReturnValueDescription(String desc) {
        this.returnValDesc = desc;
    }
}

