/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.impl;

import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DbEntity;
import com.feedzai.commons.sql.abstraction.ddl.DbFk;
import com.feedzai.commons.sql.abstraction.ddl.DbIndex;
import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.dml.View;
import com.feedzai.commons.sql.abstraction.dml.dialect.Dialect;
import com.feedzai.commons.sql.abstraction.dml.result.ResultIterator;
import com.feedzai.commons.sql.abstraction.dml.result.SqlServerResultIterator;
import com.feedzai.commons.sql.abstraction.engine.AbstractDatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.AbstractTranslator;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineDriver;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.engine.MappedEntity;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.engine.handler.OperationFault;
import com.feedzai.commons.sql.abstraction.engine.impl.SqlServerTranslator;
import com.feedzai.commons.sql.abstraction.entry.EntityEntry;
import com.feedzai.commons.sql.abstraction.util.StringUtils;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class SqlServerEngine
extends AbstractDatabaseEngine {
    protected static final String SQLSERVER_DRIVER = DatabaseEngineDriver.SQLSERVER.driver();
    public static final int NAME_ALREADY_EXISTS = 2714;
    public static final int TABLE_CAN_ONLY_HAVE_ONE_PRIMARY_KEY = 1779;
    public static final int INDEX_ALREADY_EXISTS = 1913;
    public static final int TABLE_OR_VIEW_DOES_NOT_EXIST = 3701;
    public static final int MAXIMUM_VARBINARY_SIZE = 8000;

    public SqlServerEngine(PdbProperties properties) throws DatabaseEngineException {
        super(SQLSERVER_DRIVER, properties, Dialect.SQLSERVER);
    }

    @Override
    protected Properties getDBProperties() {
        Properties props = super.getDBProperties();
        props.setProperty("socketTimeout", Long.toString(TimeUnit.SECONDS.toMillis(this.properties.getLoginTimeout())));
        return props;
    }

    @Override
    protected int entityToPreparedStatement(DbEntity entity, PreparedStatement ps, EntityEntry entry, boolean useAutoInc) throws DatabaseEngineException {
        int i = 1;
        for (DbColumn column : entity.getColumns()) {
            if (column.isAutoInc() && useAutoInc) continue;
            try {
                Object val = column.isDefaultValueSet() && !entry.containsKey(column.getName()) ? column.getDefaultValue().getConstant() : entry.get(column.getName());
                switch (column.getDbColumnType()) {
                    case BLOB: {
                        ps.setBytes(i, this.objectToArray(val));
                        break;
                    }
                    case JSON: 
                    case CLOB: {
                        if (val == null) {
                            ps.setNull(i, 2005);
                            break;
                        }
                        if (val instanceof String) {
                            StringReader sr = new StringReader((String)val);
                            ps.setClob(i, sr);
                            break;
                        }
                        throw new DatabaseEngineException("Cannot convert " + val.getClass().getSimpleName() + " to String. CLOB columns only accept Strings.");
                    }
                    case BOOLEAN: {
                        Boolean b = (Boolean)val;
                        if (b == null) {
                            ps.setObject(i, null);
                            break;
                        }
                        if (b.booleanValue()) {
                            ps.setObject(i, 1);
                            break;
                        }
                        ps.setObject(i, 0);
                        break;
                    }
                    default: {
                        ps.setObject(i, val);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                throw new DatabaseEngineException("Error while mapping variables to database", ex);
            }
            ++i;
        }
        return i - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createTable(DbEntity entity) throws DatabaseEngineException {
        block18: {
            ArrayList<String> createTable = new ArrayList<String>();
            createTable.add("CREATE TABLE");
            createTable.add(StringUtils.quotize(entity.getName()));
            ArrayList<String> columns = new ArrayList<String>();
            int numberOfAutoIncs = 0;
            for (DbColumn c : entity.getColumns()) {
                ArrayList<String> column = new ArrayList<String>();
                column.add(StringUtils.quotize(c.getName()));
                column.add(this.translateType(c));
                if (c.isAutoInc()) {
                    column.add("IDENTITY");
                    ++numberOfAutoIncs;
                }
                for (DbColumnConstraint cc : c.getColumnConstraints()) {
                    column.add(cc.translate());
                }
                if (c.isDefaultValueSet()) {
                    column.add("DEFAULT");
                    column.add(this.translate(c.getDefaultValue()));
                }
                columns.add(org.apache.commons.lang3.StringUtils.join(column, (String)" "));
            }
            if (numberOfAutoIncs > 1) {
                throw new DatabaseEngineException("In SQLServer you can only define one auto increment column");
            }
            createTable.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
            String createTableStatement = org.apache.commons.lang3.StringUtils.join(createTable, (String)" ");
            this.logger.trace(createTableStatement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(createTableStatement);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 2714) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.TABLE_ALREADY_EXISTS), ex);
                    break block18;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addPrimaryKey(DbEntity entity) throws DatabaseEngineException {
        block31: {
            if (entity.getPkFields().size() == 0) {
                return;
            }
            ArrayList<String> pks = new ArrayList<String>();
            for (String pk : entity.getPkFields()) {
                DbColumn toAlter = null;
                for (DbColumn col : entity.getColumns()) {
                    if (!col.getName().equals(pk)) continue;
                    toAlter = col;
                    break;
                }
                if (toAlter == null) {
                    throw new DatabaseEngineException("The column you specified for Primary Key does not exist.");
                }
                boolean isNotNull = false;
                ArrayList<String> cons = new ArrayList<String>();
                cons.add(StringUtils.quotize(toAlter.getName()));
                cons.add(this.translateType(toAlter));
                for (DbColumnConstraint cc : toAlter.getColumnConstraints()) {
                    if (cc == DbColumnConstraint.NOT_NULL) {
                        isNotNull = true;
                    }
                    cons.add(cc.translate());
                }
                if (!isNotNull) {
                    cons.add(DbColumnConstraint.NOT_NULL.translate());
                    String alterTable = String.format("ALTER TABLE %s ALTER COLUMN %s", StringUtils.quotize(entity.getName()), org.apache.commons.lang3.StringUtils.join(cons, (String)" "));
                    this.logger.trace(alterTable);
                    Statement s = null;
                    try {
                        s = this.conn.createStatement();
                        s.executeUpdate(alterTable);
                    }
                    catch (SQLException ex) {
                        throw new DatabaseEngineException("Something went wrong altering the table. This shouldn't have happened", ex);
                    }
                    finally {
                        try {
                            if (s != null) {
                                s.close();
                            }
                        }
                        catch (Exception e) {
                            this.logger.trace("Error closing statement.", (Throwable)e);
                        }
                    }
                }
                pks.add(StringUtils.quotize(pk));
            }
            String pkName = StringUtils.md5(String.format("PK_%s", entity.getName()), this.properties.getMaxIdentifierSize());
            ArrayList<String> statement = new ArrayList<String>();
            statement.add("ALTER TABLE");
            statement.add(StringUtils.quotize(entity.getName()));
            statement.add("ADD CONSTRAINT");
            statement.add(StringUtils.quotize(pkName));
            statement.add("PRIMARY KEY");
            statement.add("(" + org.apache.commons.lang3.StringUtils.join(pks, (String)", ") + ")");
            String addPrimaryKey = org.apache.commons.lang3.StringUtils.join(statement, (String)" ");
            this.logger.trace(addPrimaryKey);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(addPrimaryKey);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 1779) {
                    this.logger.debug(dev, "'{}' already has a primary key", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.PRIMARY_KEY_ALREADY_EXISTS), ex);
                    break block31;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addIndexes(DbEntity entity) throws DatabaseEngineException {
        List<DbIndex> indexes = entity.getIndexes();
        for (DbIndex index : indexes) {
            ArrayList<String> createIndex = new ArrayList<String>();
            createIndex.add("CREATE");
            if (index.isUnique()) {
                createIndex.add("UNIQUE");
            }
            createIndex.add("INDEX");
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<String> columnsForName = new ArrayList<String>();
            for (String column : index.getColumns()) {
                columns.add(StringUtils.quotize(column));
                columnsForName.add(column);
            }
            String idxName = StringUtils.md5(String.format("%s_%s_IDX", entity.getName(), org.apache.commons.lang3.StringUtils.join(columnsForName, (String)"_")), this.properties.getMaxIdentifierSize());
            createIndex.add(StringUtils.quotize(idxName));
            createIndex.add("ON");
            createIndex.add(StringUtils.quotize(entity.getName()));
            createIndex.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
            String statement = org.apache.commons.lang3.StringUtils.join(createIndex, (String)" ");
            this.logger.trace(statement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(statement);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 1913) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)idxName);
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.INDEX_ALREADY_EXISTS), ex);
                    continue;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s == null) continue;
                    s.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void addSequences(DbEntity entity) throws DatabaseEngineException {
    }

    @Override
    protected MappedEntity createPreparedStatementForInserts(DbEntity entity) throws DatabaseEngineException {
        ArrayList<String> insertInto = new ArrayList<String>();
        insertInto.add("INSERT INTO");
        insertInto.add(StringUtils.quotize(entity.getName()));
        ArrayList<String> insertIntoWithAutoInc = new ArrayList<String>();
        insertIntoWithAutoInc.add("INSERT INTO");
        insertIntoWithAutoInc.add(StringUtils.quotize(entity.getName()));
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> columnsWithAutoInc = new ArrayList<String>();
        ArrayList<String> valuesWithAutoInc = new ArrayList<String>();
        for (DbColumn column : entity.getColumns()) {
            columnsWithAutoInc.add(StringUtils.quotize(column.getName()));
            valuesWithAutoInc.add("?");
            if (column.isAutoInc()) continue;
            columns.add(StringUtils.quotize(column.getName()));
            values.add("?");
        }
        insertInto.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
        insertInto.add("VALUES (" + org.apache.commons.lang3.StringUtils.join(values, (String)", ") + ")");
        insertIntoWithAutoInc.add("(" + org.apache.commons.lang3.StringUtils.join(columnsWithAutoInc, (String)", ") + ")");
        insertIntoWithAutoInc.add("VALUES (" + org.apache.commons.lang3.StringUtils.join(valuesWithAutoInc, (String)", ") + ")");
        String statement = org.apache.commons.lang3.StringUtils.join(insertInto, (String)" ");
        String statementWithAutoInt = org.apache.commons.lang3.StringUtils.join(insertIntoWithAutoInc, (String)" ");
        this.logger.trace(statement);
        try {
            PreparedStatement ps = this.conn.prepareStatement(statement);
            PreparedStatement psReturn = this.conn.prepareStatement(statement, 1);
            PreparedStatement psWithAutoInc = this.conn.prepareStatement(statementWithAutoInt);
            return new MappedEntity().setInsert(ps).setInsertReturning(psReturn).setInsertWithAutoInc(psWithAutoInc);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
    }

    @Override
    protected void dropSequences(DbEntity entity) throws DatabaseEngineException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropTable(DbEntity entity) throws DatabaseEngineException {
        block13: {
            this.dropReferringFks(entity);
            Statement drop = null;
            try {
                drop = this.conn.createStatement();
                String query = String.format("DROP TABLE %s", StringUtils.quotize(entity.getName()));
                this.logger.trace(query);
                drop.executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 3701) {
                    this.logger.debug("Table '{}' does not exist", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.TABLE_DOES_NOT_EXIST), ex);
                    break block13;
                }
                throw new DatabaseEngineException("Error dropping table", ex);
            }
            finally {
                try {
                    if (drop != null) {
                        drop.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropColumn(DbEntity entity, String ... columns) throws DatabaseEngineException {
        block14: {
            Statement drop = null;
            ArrayList<String> removeColumns = new ArrayList<String>();
            removeColumns.add("ALTER TABLE");
            removeColumns.add(StringUtils.quotize(entity.getName()));
            removeColumns.add("DROP COLUMN");
            ArrayList<String> cols = new ArrayList<String>();
            for (String col : columns) {
                cols.add(StringUtils.quotize(col));
            }
            removeColumns.add(org.apache.commons.lang3.StringUtils.join(cols, (String)","));
            try {
                drop = this.conn.createStatement();
                String query = org.apache.commons.lang3.StringUtils.join(removeColumns, (String)" ");
                this.logger.trace(query);
                drop.executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 3701) {
                    this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.COLUMN_DOES_NOT_EXIST), ex);
                    break block14;
                }
                throw new DatabaseEngineException("Error dropping column", ex);
            }
            finally {
                try {
                    if (drop != null) {
                        drop.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void addColumn(DbEntity entity, DbColumn ... columns) throws DatabaseEngineException {
        ArrayList<String> addColumns = new ArrayList<String>();
        addColumns.add("ALTER TABLE");
        addColumns.add(StringUtils.quotize(entity.getName()));
        addColumns.add("ADD");
        ArrayList<String> cols = new ArrayList<String>();
        for (DbColumn c : columns) {
            ArrayList<String> column = new ArrayList<String>();
            column.add(StringUtils.quotize(c.getName()));
            column.add(this.translateType(c));
            for (DbColumnConstraint cc : c.getColumnConstraints()) {
                column.add(cc.translate());
            }
            if (c.isDefaultValueSet()) {
                column.add("DEFAULT");
                column.add(this.translate(c.getDefaultValue()));
            }
            cols.add(org.apache.commons.lang3.StringUtils.join(column, (String)" "));
        }
        addColumns.add(org.apache.commons.lang3.StringUtils.join(cols, (String)","));
        String addColumnsStatement = org.apache.commons.lang3.StringUtils.join(addColumns, (String)" ");
        this.logger.trace(addColumnsStatement);
        Statement s = null;
        try {
            s = this.conn.createStatement();
            s.executeUpdate(addColumnsStatement);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    @Override
    public Class<? extends AbstractTranslator> getTranslatorClass() {
        return SqlServerTranslator.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized long doPersist(PreparedStatement ps, MappedEntity me, boolean useAutoInc, int lastBindPosition) throws Exception {
        try {
            if (!useAutoInc && this.hasIdentityColumn(me.getEntity())) {
                this.executeUpdateSilently("SET IDENTITY_INSERT " + StringUtils.quotize(me.getEntity().getName()) + " ON");
            }
            ps.execute();
            if (useAutoInc) {
                try (ResultSet generatedKeys = ps.getGeneratedKeys();){
                    if (generatedKeys.next()) {
                        long l = generatedKeys.getLong(1);
                        return l;
                    }
                }
            }
            long l = 0L;
            return l;
        }
        finally {
            if (!useAutoInc && this.hasIdentityColumn(me.getEntity())) {
                this.executeUpdateSilently("SET IDENTITY_INSERT " + StringUtils.quotize(me.getEntity().getName()) + " OFF");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addFks(DbEntity entity, Set<DbFk> fks) throws DatabaseEngineException {
        for (DbFk fk : fks) {
            ArrayList<String> quotizedLocalColumns = new ArrayList<String>();
            for (String string : fk.getLocalColumns()) {
                quotizedLocalColumns.add(StringUtils.quotize(string));
            }
            ArrayList<String> quotizedForeignColumns = new ArrayList<String>();
            for (String s3 : fk.getReferencedColumns()) {
                quotizedForeignColumns.add(StringUtils.quotize(s3));
            }
            String string = StringUtils.quotize(entity.getName());
            String quotizedLocalColumnsSting = org.apache.commons.lang3.StringUtils.join(quotizedLocalColumns, (String)", ");
            String quotizedForeignColumnsString = org.apache.commons.lang3.StringUtils.join(quotizedForeignColumns, (String)", ");
            String alterTable = String.format("ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s (%s)", string, StringUtils.quotize(StringUtils.md5("FK_" + string + quotizedLocalColumnsSting + quotizedForeignColumnsString, this.properties.getMaxIdentifierSize())), quotizedLocalColumnsSting, StringUtils.quotize(fk.getReferencedTable()), quotizedForeignColumnsString);
            Statement alterTableStmt = null;
            try {
                alterTableStmt = this.conn.createStatement();
                this.logger.trace(alterTable);
                alterTableStmt.executeUpdate(alterTable);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 2714) {
                    this.logger.debug(dev, "Foreign key for table '{}' already exists. Error code: {}.", (Object)entity.getName(), (Object)ex.getErrorCode());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.FOREIGN_KEY_ALREADY_EXISTS), ex);
                    continue;
                }
                throw new DatabaseEngineException(String.format("Could not add Foreign Key to entity %s. Error code: %d.", entity.getName(), ex.getErrorCode()), ex);
            }
            finally {
                try {
                    if (alterTableStmt == null) continue;
                    alterTableStmt.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropReferringFks(DbEntity entity) throws DatabaseEngineException {
        Statement s = null;
        ResultSet dependentTables = null;
        try {
            s = this.conn.createStatement();
            String sString = String.format("SELECT T1.TABLE_NAME, CONSTRAINT_NAME FROM INFORMATION_SCHEMA.CONSTRAINT_TABLE_USAGE AS T1 JOIN SYS.FOREIGN_KEYS AS F ON (F.parent_object_id = OBJECT_ID(N'%s') OR F.referenced_object_id = OBJECT_ID(N'%s')) AND T1.CONSTRAINT_NAME = OBJECT_NAME(F.object_id) AND T1.TABLE_NAME NOT LIKE '%s'", entity.getName(), entity.getName(), entity.getName());
            this.logger.trace(sString);
            s.executeQuery(sString);
            dependentTables = s.getResultSet();
            while (dependentTables.next()) {
                Statement dropFk = null;
                try {
                    dropFk = this.conn.createStatement();
                    String dropFkString = String.format("ALTER TABLE %s DROP CONSTRAINT %s", StringUtils.quotize(dependentTables.getString(1)), StringUtils.quotize(dependentTables.getString(2)));
                    this.logger.trace(dropFkString);
                    dropFk.executeUpdate(dropFkString);
                }
                catch (SQLException ex) {
                    this.logger.debug(String.format("Unable to drop constraint '%s' in table '%s'", dependentTables.getString(2), dependentTables.getString(1)), (Throwable)ex);
                }
                finally {
                    if (dropFk == null) continue;
                    try {
                        dropFk.close();
                    }
                    catch (Exception e) {
                        this.logger.trace("Error closing statement.", (Throwable)e);
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException(String.format("Unable to drop foreign keys of the tables that depend on '%s'", entity.getName()), ex);
        }
        finally {
            if (dependentTables != null) {
                try {
                    dependentTables.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing result set.", (Throwable)e);
                }
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public synchronized int executeUpdate(Expression query) throws DatabaseEngineException {
        if (query instanceof View && ((View)query).isReplace()) {
            View v = (View)query;
            String dropIfExists = String.format("IF EXISTS (SELECT TABLE_NAME FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = '%s') DROP VIEW %s", v.getName(), StringUtils.quotize(v.getName()));
            this.logger.trace(dropIfExists);
            this.executeUpdate(dropIfExists);
        }
        return super.executeUpdate(query);
    }

    @Override
    public boolean isStringAggDistinctCapable() {
        return false;
    }

    @Override
    protected void setSchema(String schema) throws DatabaseEngineException {
        if (!this.properties.getSchema().equals(this.getSchema())) {
            throw new DatabaseEngineException("Microsoft Sql Server doesn't support setting a schema for the session! Use a different user or database instead.");
        }
    }

    @Override
    protected ResultIterator createResultIterator(Statement statement, String sql) throws DatabaseEngineException {
        return new SqlServerResultIterator(statement, sql);
    }

    @Override
    protected ResultIterator createResultIterator(PreparedStatement ps) throws DatabaseEngineException {
        return new SqlServerResultIterator(ps);
    }
}

