/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine;

import com.feedzai.commons.sql.abstraction.engine.AbstractDatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.AbstractTranslator;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.DatabaseFactoryException;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.util.Builder;
import com.google.common.base.Throwables;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Providers;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public final class DatabaseFactory {
    private DatabaseFactory() {
    }

    public static DatabaseEngine getConnection(Properties p) throws DatabaseFactoryException {
        PdbProperties pdbProperties = new PdbProperties(p, true);
        String engine = pdbProperties.getEngine();
        if (StringUtils.isBlank((CharSequence)engine)) {
            throw new DatabaseFactoryException("pdb.engine property is mandatory");
        }
        if (pdbProperties.getSocketTimeout() > 0 && pdbProperties.getCheckConnectionTimeout() > pdbProperties.getSocketTimeout()) {
            throw new DatabaseFactoryException("pdb.check_connection_timeout cannot be greater than pdb.socket_timeout");
        }
        try {
            Class<?> c = Class.forName(engine);
            Constructor<?> cons = c.getConstructor(PdbProperties.class);
            AbstractDatabaseEngine de = (AbstractDatabaseEngine)cons.newInstance(pdbProperties);
            Class<AbstractTranslator> tc = de.getTranslatorClass();
            if (pdbProperties.isTranslatorSet()) {
                Class<?> propertiesTranslator = Class.forName(pdbProperties.getTranslator());
                if (!AbstractTranslator.class.isAssignableFrom(propertiesTranslator)) {
                    throw new DatabaseFactoryException("Provided translator does extend from AbstractTranslator.");
                }
                tc = propertiesTranslator;
            }
            Injector injector = Guice.createInjector((Module[])new Module[]{new PdbModule.Builder().withTranslator(tc).withPdbProperties(pdbProperties).build()});
            injector.injectMembers((Object)de);
            return de;
        }
        catch (DatabaseFactoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DatabaseFactoryException(e);
        }
    }

    public static class PdbModule
    extends AbstractModule {
        private final Class<? extends AbstractTranslator> translator;
        private final PdbProperties pdbProperties;

        private PdbModule(Class<? extends AbstractTranslator> translator, PdbProperties pdbProperties) {
            this.translator = translator;
            this.pdbProperties = pdbProperties;
        }

        protected void configure() {
            try {
                this.bind(PdbProperties.class).toProvider(Providers.of((Object)this.pdbProperties));
                this.bind(AbstractTranslator.class).toInstance((Object)this.translator.newInstance());
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
        }

        public static class Builder
        implements com.feedzai.commons.sql.abstraction.util.Builder<PdbModule> {
            private Class<? extends AbstractTranslator> translator;
            private PdbProperties pdbProperties;

            public Builder withTranslator(Class<? extends AbstractTranslator> translator) {
                this.translator = translator;
                return this;
            }

            public Builder withPdbProperties(PdbProperties pdbProperties) {
                this.pdbProperties = pdbProperties;
                return this;
            }

            @Override
            public PdbModule build() {
                return new PdbModule(this.translator, this.pdbProperties);
            }
        }
    }
}

