/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.impl;

import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnType;
import com.feedzai.commons.sql.abstraction.ddl.DbEntity;
import com.feedzai.commons.sql.abstraction.ddl.DbFk;
import com.feedzai.commons.sql.abstraction.ddl.DbIndex;
import com.feedzai.commons.sql.abstraction.dml.dialect.Dialect;
import com.feedzai.commons.sql.abstraction.dml.result.DB2ResultIterator;
import com.feedzai.commons.sql.abstraction.dml.result.ResultColumn;
import com.feedzai.commons.sql.abstraction.dml.result.ResultIterator;
import com.feedzai.commons.sql.abstraction.engine.AbstractDatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.AbstractTranslator;
import com.feedzai.commons.sql.abstraction.engine.ConnectionResetException;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineDriver;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineRuntimeException;
import com.feedzai.commons.sql.abstraction.engine.MappedEntity;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.engine.handler.OperationFault;
import com.feedzai.commons.sql.abstraction.engine.impl.DB2Translator;
import com.feedzai.commons.sql.abstraction.entry.EntityEntry;
import com.feedzai.commons.sql.abstraction.util.PreparedStatementCapsule;
import com.feedzai.commons.sql.abstraction.util.StringUtils;
import com.ibm.db2.jcc.am.SqlSyntaxErrorException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DB2Engine
extends AbstractDatabaseEngine {
    private static final String DB2_DRIVER = DatabaseEngineDriver.DB2.driver();
    private static final int NAME_ALREADY_EXISTS = -601;
    private static final int TABLE_CAN_ONLY_HAVE_ONE_PRIMARY_KEY = -624;
    private static final int NAME_DOES_NOT_EXIST = -204;
    static final String DB2_DEFAULT_BLOB_SIZE = "2G";
    private static final int COLUMN_MUST_BE_NON_NULL = -542;

    public DB2Engine(PdbProperties properties) throws DatabaseEngineException {
        super(DB2_DRIVER, properties, Dialect.DB2);
    }

    @Override
    public Class<? extends AbstractTranslator> getTranslatorClass() {
        return DB2Translator.class;
    }

    @Override
    protected int entityToPreparedStatement(DbEntity entity, PreparedStatement ps, EntityEntry entry, boolean useAutoInc) throws DatabaseEngineException {
        int i = 1;
        for (DbColumn column : entity.getColumns()) {
            if (column.isAutoInc() && useAutoInc) continue;
            try {
                Object val = column.isDefaultValueSet() && !entry.containsKey(column.getName()) ? column.getDefaultValue().getConstant() : entry.get(column.getName());
                switch (column.getDbColumnType()) {
                    case JSON: 
                    case CLOB: 
                    case BLOB: {
                        ps.setBytes(i, this.objectToArray(val));
                        break;
                    }
                    case BOOLEAN: {
                        Boolean b = (Boolean)val;
                        if (b == null) {
                            ps.setObject(i, null);
                            break;
                        }
                        if (b.booleanValue()) {
                            ps.setObject(i, "1");
                            break;
                        }
                        ps.setObject(i, "0");
                        break;
                    }
                    default: {
                        ps.setObject(i, val);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                throw new DatabaseEngineException("Error while mapping variables to database", ex);
            }
            ++i;
        }
        return i - 1;
    }

    @Override
    protected void createTable(DbEntity entity) throws DatabaseEngineException {
        LinkedList<Object> createTable = new LinkedList<Object>();
        createTable.add("CREATE TABLE");
        createTable.add(StringUtils.quotize(entity.getName()));
        LinkedList<String> columns = new LinkedList<String>();
        for (DbColumn c : entity.getColumns()) {
            LinkedList<String> column = new LinkedList<String>();
            column.add(StringUtils.quotize(c.getName()));
            column.add(this.translateType(c));
            for (DbColumnConstraint cc : c.getColumnConstraints()) {
                column.add(cc.translate());
            }
            if (c.isDefaultValueSet()) {
                column.add("DEFAULT");
                column.add(this.translate(c.getDefaultValue()));
            }
            columns.add(org.apache.commons.lang3.StringUtils.join(column, (String)" "));
        }
        createTable.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
        String createTableStatement = org.apache.commons.lang3.StringUtils.join(createTable, (String)" ");
        this.logger.trace(createTableStatement);
        try (Statement s = this.conn.createStatement();){
            s.executeUpdate(createTableStatement);
        }
        catch (SQLException ex) {
            switch (ex.getErrorCode()) {
                case -601: {
                    this.logger.debug(dev, "'{}' is already defined", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.TABLE_ALREADY_EXISTS), ex);
                    break;
                }
                case -542: {
                    String errorMessage;
                    try {
                        errorMessage = ((SqlSyntaxErrorException)ex).getSqlca().getMessage();
                    }
                    catch (Exception sqlEx) {
                        errorMessage = ex.getMessage();
                    }
                    this.logger.error("Column must use NON_NULL constraint; error message: {}", (Object)errorMessage);
                }
                default: {
                    throw new DatabaseEngineException("Something went wrong handling statement", ex);
                }
            }
        }
    }

    @Override
    protected void addPrimaryKey(DbEntity entity) throws DatabaseEngineException {
        if (entity.getPkFields().isEmpty()) {
            return;
        }
        LinkedList<String> pks = new LinkedList<String>();
        for (String pk : entity.getPkFields()) {
            pks.add(StringUtils.quotize(pk));
        }
        String alterColumnSetNotNull = this.alterColumnSetNotNull(entity.getName(), entity.getPkFields());
        String pkName = StringUtils.md5(String.format("PK_%s", entity.getName()), this.properties.getMaxIdentifierSize());
        LinkedList<Object> statement = new LinkedList<Object>();
        statement.add("ALTER TABLE");
        statement.add(StringUtils.quotize(entity.getName()));
        statement.add("ADD CONSTRAINT");
        statement.add(StringUtils.quotize(pkName));
        statement.add("PRIMARY KEY");
        statement.add("(" + org.apache.commons.lang3.StringUtils.join(pks, (String)", ") + ")");
        String addPrimaryKey = org.apache.commons.lang3.StringUtils.join(statement, (String)" ");
        String reorg = this.reorg(entity.getName());
        try (Statement s = this.conn.createStatement();){
            this.logger.trace(alterColumnSetNotNull);
            s.executeUpdate(alterColumnSetNotNull);
            this.logger.trace(reorg);
            s.executeUpdate(reorg);
            this.logger.trace(addPrimaryKey);
            s.executeUpdate(addPrimaryKey);
            this.logger.trace(reorg);
            s.executeUpdate(reorg);
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == -624) {
                this.logger.debug(dev, "'{}' already has a primary key", (Object)entity.getName());
                this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.PRIMARY_KEY_ALREADY_EXISTS), ex);
            }
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
    }

    private String reorg(String tableName) {
        return String.format("CALL sysproc.admin_cmd('REORG TABLE %s')", StringUtils.quotize(tableName));
    }

    private String alterColumnSetNotNull(String tableName, List<String> columnNames) {
        ArrayList<String> statement = new ArrayList<String>();
        statement.add("ALTER TABLE");
        statement.add(StringUtils.quotize(tableName));
        for (String columnName : columnNames) {
            statement.add("ALTER COLUMN");
            statement.add(StringUtils.quotize(columnName));
            statement.add("SET NOT NULL");
        }
        return org.apache.commons.lang3.StringUtils.join(statement, (String)" ");
    }

    @Override
    protected void addIndexes(DbEntity entity) throws DatabaseEngineException {
        List<DbIndex> indexes = entity.getIndexes();
        for (DbIndex index : indexes) {
            LinkedList<Object> createIndex = new LinkedList<Object>();
            createIndex.add("CREATE");
            if (index.isUnique()) {
                createIndex.add("UNIQUE");
            }
            createIndex.add("INDEX");
            LinkedList<String> columns = new LinkedList<String>();
            LinkedList<String> columnsForName = new LinkedList<String>();
            for (String column : index.getColumns()) {
                columns.add(StringUtils.quotize(column));
                columnsForName.add(column);
            }
            String idxName = StringUtils.md5(String.format("%s_%s_IDX", entity.getName(), org.apache.commons.lang3.StringUtils.join(columnsForName, (String)"_")), this.properties.getMaxIdentifierSize());
            createIndex.add(StringUtils.quotize(idxName));
            createIndex.add("ON");
            createIndex.add(StringUtils.quotize(entity.getName()));
            createIndex.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
            String statement = org.apache.commons.lang3.StringUtils.join(createIndex, (String)" ");
            this.logger.trace(statement);
            try {
                Statement s = this.conn.createStatement();
                try {
                    s.executeUpdate(statement);
                }
                finally {
                    if (s == null) continue;
                    s.close();
                }
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == -601) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)idxName);
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.INDEX_ALREADY_EXISTS), ex);
                    continue;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
        }
    }

    @Override
    protected void addSequences(DbEntity entity) throws DatabaseEngineException {
        for (DbColumn column : entity.getColumns()) {
            if (!column.isAutoInc()) continue;
            String sequenceName = StringUtils.md5(String.format("%s_%s_SEQ", entity.getName(), column.getName()), this.properties.getMaxIdentifierSize());
            LinkedList<String> createSequence = new LinkedList<String>();
            createSequence.add("CREATE SEQUENCE");
            createSequence.add(StringUtils.quotize(sequenceName));
            createSequence.add("MINVALUE 0");
            switch (column.getDbColumnType()) {
                case INT: {
                    createSequence.add("MAXVALUE 2147483647");
                    break;
                }
                case LONG: {
                    createSequence.add("NO MAXVALUE");
                    break;
                }
                default: {
                    throw new DatabaseEngineException("Auto incrementation is only supported on INT and LONG");
                }
            }
            createSequence.add("START WITH 1");
            createSequence.add("INCREMENT BY 1");
            String statement = org.apache.commons.lang3.StringUtils.join(createSequence, (String)" ");
            this.logger.trace(statement);
            try {
                Statement s = this.conn.createStatement();
                try {
                    s.executeUpdate(statement);
                }
                finally {
                    if (s == null) continue;
                    s.close();
                }
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == -601) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)sequenceName);
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.SEQUENCE_ALREADY_EXISTS), ex);
                    continue;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
        }
    }

    @Override
    public synchronized int executeUpdate(String query) throws DatabaseEngineException {
        String[] split = query.split("\u001f");
        int i = -1;
        for (String s : split) {
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)s)) continue;
            i = super.executeUpdate(s);
        }
        return i;
    }

    @Override
    protected MappedEntity createPreparedStatementForInserts(DbEntity entity) throws DatabaseEngineException {
        ArrayList<Object> insertInto = new ArrayList<Object>();
        insertInto.add("INSERT INTO");
        insertInto.add(StringUtils.quotize(entity.getName()));
        ArrayList<Object> insertIntoWithAutoInc = new ArrayList<Object>();
        insertIntoWithAutoInc.add("INSERT INTO");
        insertIntoWithAutoInc.add(StringUtils.quotize(entity.getName()));
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> columnsWithAutoInc = new ArrayList<String>();
        ArrayList<String> valuesWithAutoInc = new ArrayList<String>();
        String returning = null;
        for (DbColumn column : entity.getColumns()) {
            columnsWithAutoInc.add(StringUtils.quotize(column.getName()));
            valuesWithAutoInc.add("?");
            columns.add(StringUtils.quotize(column.getName()));
            if (column.isAutoInc()) {
                String sequenceName = StringUtils.md5(String.format("%s_%s_SEQ", entity.getName(), column.getName()), this.properties.getMaxIdentifierSize());
                values.add(String.format("%s.nextval", StringUtils.quotize(sequenceName)));
                returning = column.getName();
                continue;
            }
            values.add("?");
        }
        insertInto.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
        insertInto.add("VALUES (" + org.apache.commons.lang3.StringUtils.join(values, (String)", ") + ")");
        insertIntoWithAutoInc.add("(" + org.apache.commons.lang3.StringUtils.join(columnsWithAutoInc, (String)", ") + ")");
        insertIntoWithAutoInc.add("VALUES (" + org.apache.commons.lang3.StringUtils.join(valuesWithAutoInc, (String)", ") + ")");
        ArrayList insertIntoReturn = new ArrayList(insertInto);
        String insertStatement = org.apache.commons.lang3.StringUtils.join(insertInto, (String)" ");
        String insertReturnStatement = org.apache.commons.lang3.StringUtils.join(insertIntoReturn, (String)" ");
        String insertWithAutoInc = org.apache.commons.lang3.StringUtils.join(insertIntoWithAutoInc, (String)" ");
        this.logger.trace(insertStatement);
        this.logger.trace(insertReturnStatement);
        try {
            PreparedStatement ps = this.conn.prepareStatement(insertStatement);
            PreparedStatement psReturn = this.conn.prepareStatement(insertReturnStatement);
            PreparedStatement psWithAutoInc = this.conn.prepareStatement(insertWithAutoInc);
            return new MappedEntity().setInsert(ps).setInsertReturning(psReturn).setInsertWithAutoInc(psWithAutoInc).setAutoIncColumn(returning);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
    }

    @Override
    protected void dropSequences(DbEntity entity) throws DatabaseEngineException {
        for (DbColumn column : entity.getColumns()) {
            if (!column.isAutoInc()) continue;
            String sequenceName = StringUtils.md5(String.format("%s_%s_SEQ", entity.getName(), column.getName()), this.properties.getMaxIdentifierSize());
            String stmt = String.format("DROP SEQUENCE %s", StringUtils.quotize(sequenceName));
            this.logger.trace(stmt);
            try {
                Statement s = this.conn.createStatement();
                try {
                    s.executeUpdate(stmt);
                }
                finally {
                    if (s == null) continue;
                    s.close();
                }
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == -204) {
                    this.logger.debug(dev, "Sequence '{}' does not exist", (Object)sequenceName);
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.SEQUENCE_DOES_NOT_EXIST), ex);
                    continue;
                }
                throw new DatabaseEngineException("Error dropping sequence", ex);
            }
        }
    }

    @Override
    protected void dropTable(DbEntity entity) throws DatabaseEngineException {
        String query = String.format("DROP TABLE %s", StringUtils.quotize(entity.getName()));
        this.logger.trace(query);
        try (Statement s = this.conn.createStatement();){
            s.executeUpdate(query);
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == -204) {
                this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.TABLE_DOES_NOT_EXIST), ex);
            }
            throw new DatabaseEngineException("Error dropping table", ex);
        }
    }

    @Override
    protected void dropColumn(DbEntity entity, String ... columns) throws DatabaseEngineException {
        ArrayList<String> removeColumns = new ArrayList<String>();
        removeColumns.add("ALTER TABLE");
        removeColumns.add(StringUtils.quotize(entity.getName()));
        for (String col : columns) {
            removeColumns.add("DROP COLUMN");
            removeColumns.add(StringUtils.quotize(col));
        }
        String query = org.apache.commons.lang3.StringUtils.join(removeColumns, (String)" ");
        String reorg = this.reorg(entity.getName());
        try (Statement s = this.conn.createStatement();){
            this.logger.trace(query);
            s.executeUpdate(query);
            this.logger.trace(reorg);
            s.executeUpdate(reorg);
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == -204) {
                this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.COLUMN_DOES_NOT_EXIST), ex);
            }
            throw new DatabaseEngineException("Error dropping column", ex);
        }
    }

    @Override
    public synchronized void updateEntity(DbEntity entity) throws DatabaseEngineException {
        super.updateEntity(entity);
        try (Statement reorg = this.conn.createStatement();){
            reorg.executeUpdate(this.reorg(entity.getName()));
        }
        catch (SQLException e) {
            throw new DatabaseEngineException("Error reorganizing table '" + entity.getName() + "'", e);
        }
    }

    @Override
    protected void addColumn(DbEntity entity, DbColumn ... columns) throws DatabaseEngineException {
        ArrayList<String> addColumns = new ArrayList<String>();
        addColumns.add("ALTER TABLE");
        addColumns.add(StringUtils.quotize(entity.getName(), this.translator.translateEscape()));
        for (DbColumn c : columns) {
            addColumns.add("ADD COLUMN");
            ArrayList<String> column = new ArrayList<String>();
            column.add(StringUtils.quotize(c.getName(), this.translator.translateEscape()));
            column.add(this.translateType(c));
            for (DbColumnConstraint cc : c.getColumnConstraints()) {
                column.add(cc.translate());
            }
            if (c.isDefaultValueSet()) {
                column.add("DEFAULT");
                column.add(this.translate(c.getDefaultValue()));
            }
            addColumns.add(org.apache.commons.lang3.StringUtils.join(column, (String)" "));
        }
        String addColumnsStatement = org.apache.commons.lang3.StringUtils.join(addColumns, (String)" ");
        this.logger.trace(addColumnsStatement);
        Statement s = null;
        Statement reorgStatement = null;
        try {
            s = this.conn.createStatement();
            s.executeUpdate(addColumnsStatement);
            String reorg = this.reorg(entity.getName());
            this.logger.trace(reorg);
            reorgStatement = this.conn.createStatement();
            reorgStatement.executeUpdate(reorg);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
            try {
                if (reorgStatement != null) {
                    reorgStatement.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    @Override
    protected synchronized long doPersist(PreparedStatement ps, MappedEntity me, boolean useAutoInc, int lastBindPosition) throws Exception {
        ps.execute();
        if (me.getAutoIncColumn() == null) {
            return 0L;
        }
        String name = me.getEntity().getName();
        String quotizedSeqName = StringUtils.quotize(StringUtils.md5(String.format("%s_%s_SEQ", name, me.getAutoIncColumn()), this.properties.getMaxIdentifierSize()));
        long ret = 0L;
        if (useAutoInc) {
            Iterator<ResultColumn> iterator;
            List<Map<String, ResultColumn>> q = this.query(String.format("SELECT PREVIOUS VALUE FOR %s FROM sysibm.sysdummy1", quotizedSeqName));
            if (!q.isEmpty() && (iterator = q.get(0).values().iterator()).hasNext()) {
                ResultColumn rc = iterator.next();
                return rc.toLong();
            }
        } else {
            List<Map<String, ResultColumn>> keys;
            String sql = "select (select max(\"" + me.getAutoIncColumn() + "\") from \"" + name + "\") , " + quotizedSeqName + ".NEXTVAL FROM sysibm.sysdummy1";
            List<Map<String, ResultColumn>> q = this.query(sql);
            if (!q.isEmpty()) {
                Iterator<ResultColumn> it = q.get(0).values().iterator();
                long max = Optional.ofNullable(it.next().toLong()).orElse(-1L);
                long seqCurVal = Optional.ofNullable(it.next().toLong()).orElse(-1L);
                if (seqCurVal != max) {
                    this.executeUpdateSilently("ALTER SEQUENCE " + quotizedSeqName + " RESTART WITH " + (ret + 1L));
                }
            }
            if (!(keys = this.query(sql)).isEmpty()) {
                Iterator<ResultColumn> it = keys.get(0).values().iterator();
                ret = it.next().toLong();
                long seqCurVal = it.next().toLong();
                if (seqCurVal != ret) {
                    this.executeUpdateSilently("ALTER SEQUENCE " + quotizedSeqName + " RESTART WITH " + (ret + 1L));
                }
            }
        }
        return ret;
    }

    @Override
    protected void addFks(DbEntity entity, Set<DbFk> fks) throws DatabaseEngineException {
        for (DbFk fk : fks) {
            LinkedList<String> quotizedLocalColumns = new LinkedList<String>();
            for (String string : fk.getLocalColumns()) {
                quotizedLocalColumns.add(StringUtils.quotize(string));
            }
            LinkedList<String> quotizedForeignColumns = new LinkedList<String>();
            for (String s3 : fk.getReferencedColumns()) {
                quotizedForeignColumns.add(StringUtils.quotize(s3));
            }
            String string = StringUtils.quotize(entity.getName(), this.translator.translateEscape());
            String quotizedLocalColumnsSting = org.apache.commons.lang3.StringUtils.join(quotizedLocalColumns, (String)", ");
            String quotizedForeignColumnsString = org.apache.commons.lang3.StringUtils.join(quotizedForeignColumns, (String)", ");
            String alterTable = String.format("ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s (%s)", string, StringUtils.quotize(StringUtils.md5("FK_" + string + quotizedLocalColumnsSting + quotizedForeignColumnsString, this.properties.getMaxIdentifierSize())), quotizedLocalColumnsSting, StringUtils.quotize(fk.getReferencedTable()), quotizedForeignColumnsString);
            String reorg = this.reorg(entity.getName());
            try {
                Statement s4 = this.conn.createStatement();
                try {
                    this.logger.trace(alterTable);
                    s4.executeUpdate(alterTable);
                    this.logger.trace(reorg);
                    s4.executeUpdate(reorg);
                }
                finally {
                    if (s4 == null) continue;
                    s4.close();
                }
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == -601) {
                    this.logger.debug(dev, "Foreign key for table '{}' already exists. Error code: {}.", (Object)entity.getName(), (Object)ex.getMessage());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.FOREIGN_KEY_ALREADY_EXISTS), ex);
                    continue;
                }
                throw new DatabaseEngineException(String.format("Could not add Foreign Key to entity %s. Error code: %s.", entity.getName(), ex.getMessage()), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean checkConnection(Connection conn) {
        boolean bl;
        int timeout = this.properties.getCheckConnectionTimeout();
        int socketTimeout = conn.getNetworkTimeout();
        try {
            conn.setNetworkTimeout(this.socketTimeoutExecutor, timeout * 1000);
            bl = this.pingConnection(conn);
        }
        catch (Exception ex) {
            boolean bl2;
            try {
                this.logger.debug("It wasn't possible to verify the connection state within the timeout of {} seconds.", (Object)timeout, (Object)ex);
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    conn.setNetworkTimeout(this.socketTimeoutExecutor, socketTimeout);
                    throw throwable;
                }
                catch (Exception ex2) {
                    this.logger.warn("It wasn't possible to reset the connection / fetch the timeout.");
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        this.logger.debug("Error closing the connection.", (Throwable)e);
                    }
                    return false;
                }
            }
            conn.setNetworkTimeout(this.socketTimeoutExecutor, socketTimeout);
            return bl2;
        }
        conn.setNetworkTimeout(this.socketTimeoutExecutor, socketTimeout);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pingConnection(Connection conn) {
        Statement s = null;
        try {
            s = conn.createStatement();
            s.executeQuery("SELECT 1 FROM sysibm.sysdummy1");
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.logger.debug("Connection is down.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    @Override
    protected ResultIterator createResultIterator(Statement statement, String sql) throws DatabaseEngineException {
        return new DB2ResultIterator(statement, sql);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getSchema() throws DatabaseEngineException {
        try (Statement stmt = this.conn.createStatement();){
            String string;
            block18: {
                ResultSet resultSet;
                block16: {
                    String string2;
                    block17: {
                        resultSet = stmt.executeQuery("VALUES(CURRENT SCHEMA)");
                        try {
                            if (resultSet.next()) break block16;
                            string2 = null;
                            if (resultSet == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return string2;
                }
                String schema = resultSet.getString(1);
                String string3 = string = schema == null ? null : schema.trim();
                if (resultSet == null) break block18;
                resultSet.close();
            }
            return string;
        }
        catch (Exception e) {
            throw new DatabaseEngineException("Could not get current schema", e);
        }
    }

    @Override
    protected void setSchema(String schema) throws DatabaseEngineException {
        boolean schemaExists;
        PreparedStatement ps;
        try {
            ps = this.conn.prepareStatement("SELECT count(*) FROM syscat.schemata WHERE SCHEMANAME = ?");
            try {
                ps.setString(1, schema);
                try (ResultSet resultSet = ps.executeQuery();){
                    schemaExists = resultSet.next() && resultSet.getInt(1) == 1;
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            throw new DatabaseEngineException(String.format("Could not set current schema to '%s'", schema), e);
        }
        if (!schemaExists) {
            throw new DatabaseEngineException(String.format("Could not set current schema to non existing '%s'", schema));
        }
        try {
            ps = this.conn.prepareStatement("SET CURRENT SCHEMA ?");
            try {
                ps.setString(1, schema);
                ps.execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            throw new DatabaseEngineException(String.format("Could not set current schema to '%s'", schema), e);
        }
    }

    @Override
    public synchronized Map<String, DbColumnType> getMetadata(String schemaPattern, String tableNamePattern) throws DatabaseEngineException {
        LinkedHashMap<String, DbColumnType> metaMap = new LinkedHashMap<String, DbColumnType>();
        PreparedStatement ps = null;
        ResultSet rsColumns = null;
        try {
            Object columnType;
            this.getConnection();
            ps = this.conn.prepareStatement("SELECT NAME, COLTYPE, SCALE FROM sysibm.SYSCOLUMNS WHERE tbname LIKE ? AND TBCREATOR LIKE ?");
            ps.setString(1, tableNamePattern == null ? "%" : tableNamePattern);
            ps.setString(2, schemaPattern == null ? "%" : schemaPattern);
            rsColumns = ps.executeQuery();
            while (rsColumns.next()) {
                columnType = rsColumns.getString("COLTYPE").trim();
                int scale = 0;
                try {
                    scale = Integer.parseInt(rsColumns.getString("SCALE"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                metaMap.put(rsColumns.getString("NAME"), this.toPdbType((String)(scale == 0 ? columnType : (String)columnType + scale)));
            }
            columnType = metaMap;
            return columnType;
        }
        catch (Exception e) {
            throw new DatabaseEngineException("Could not get metadata", e);
        }
        finally {
            try {
                if (rsColumns != null) {
                    rsColumns.close();
                }
            }
            catch (Exception a) {
                this.logger.trace("Error closing result set.", (Throwable)a);
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception a) {
                this.logger.trace("Error closing statement.", (Throwable)a);
            }
        }
    }

    private DbColumnType toPdbType(String type) {
        if (type.equals("INTEGER")) {
            return DbColumnType.INT;
        }
        if (type.equals("CHAR")) {
            return DbColumnType.BOOLEAN;
        }
        if (type.equals("DECIMAL")) {
            return DbColumnType.LONG;
        }
        if (type.equals("DOUBLE")) {
            return DbColumnType.DOUBLE;
        }
        if (type.equals("NUMBER19")) {
            return DbColumnType.LONG;
        }
        if (type.equals("VARCHAR2") || type.equals("VARCHAR")) {
            return DbColumnType.STRING;
        }
        if (type.equals("CLOB")) {
            return DbColumnType.BLOB;
        }
        if (type.equals("BLOB")) {
            return DbColumnType.BLOB;
        }
        return DbColumnType.UNMAPPED;
    }

    @Override
    public synchronized void setParameters(String name, Object ... params) throws DatabaseEngineException, ConnectionResetException {
        PreparedStatementCapsule ps = (PreparedStatementCapsule)this.stmts.get(name);
        if (ps == null) {
            throw new DatabaseEngineRuntimeException(String.format("PreparedStatement named '%s' does not exist", name));
        }
        int i = 1;
        for (Object o : params) {
            try {
                if (o instanceof byte[]) {
                    ps.ps.setBytes(i, (byte[])o);
                } else {
                    this.setObjectParameter(ps, i, o);
                }
            }
            catch (Exception ex) {
                if (this.checkConnection(this.conn) || !this.properties.isReconnectOnLost()) {
                    throw new DatabaseEngineException("Could not set parameters", ex);
                }
                this.reconnectExceptionally("Connection is down");
                throw new ConnectionResetException("Connection was lost, you must reset the prepared statement parameters and re-execute the statement");
            }
            ++i;
        }
    }

    @Override
    public synchronized void setParameter(String name, int index, Object param) throws DatabaseEngineException, ConnectionResetException {
        PreparedStatementCapsule ps = (PreparedStatementCapsule)this.stmts.get(name);
        if (ps == null) {
            throw new DatabaseEngineRuntimeException(String.format("PreparedStatement named '%s' does not exist", name));
        }
        try {
            if (param instanceof byte[]) {
                ps.ps.setBytes(index, (byte[])param);
            } else {
                this.setObjectParameter(ps, index, param);
            }
        }
        catch (Exception ex) {
            if (this.checkConnection(this.conn) || !this.properties.isReconnectOnLost()) {
                throw new DatabaseEngineException("Could not set parameter", ex);
            }
            this.reconnectExceptionally("Connection is down");
            throw new ConnectionResetException("Connection was lost, you must reset the prepared statement parameters and re-execute the statement");
        }
    }

    @Override
    public boolean isStringAggDistinctCapable() {
        return false;
    }

    private void setObjectParameter(PreparedStatementCapsule ps, int index, Object o) throws Exception {
        try {
            ps.ps.setObject(index, o);
        }
        catch (SQLException e) {
            if (!(o instanceof String)) {
                throw e;
            }
            ps.ps.setBytes(index, this.objectToArray(((String)o).getBytes()));
        }
    }

    @Override
    protected ResultIterator createResultIterator(PreparedStatement ps) throws DatabaseEngineException {
        return new DB2ResultIterator(ps);
    }
}

