/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.impl;

import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnType;
import com.feedzai.commons.sql.abstraction.ddl.DbEntity;
import com.feedzai.commons.sql.abstraction.ddl.DbFk;
import com.feedzai.commons.sql.abstraction.engine.AbstractTranslator;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineDriver;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.engine.MappedEntity;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.engine.handler.OperationFault;
import com.feedzai.commons.sql.abstraction.engine.impl.CockroachDBTranslator;
import com.feedzai.commons.sql.abstraction.engine.impl.PostgreSqlEngine;
import com.feedzai.commons.sql.abstraction.util.StringUtils;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class CockroachDBEngine
extends PostgreSqlEngine {
    protected static final String COCKROACHDB_DRIVER = DatabaseEngineDriver.COCKROACHDB.driver();
    public static final String CONSTRAINT_NAME_ALREADY_EXISTS_COCKROACH = "23503";

    public CockroachDBEngine(PdbProperties properties) throws DatabaseEngineException {
        super(properties, COCKROACHDB_DRIVER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createTable(DbEntity entity) throws DatabaseEngineException {
        block18: {
            ArrayList<Object> createTable = new ArrayList<Object>();
            createTable.add("CREATE TABLE");
            createTable.add(StringUtils.quotize(entity.getName()));
            ArrayList<String> columns = new ArrayList<String>();
            for (DbColumn dbColumn : entity.getColumns()) {
                ArrayList<String> column = new ArrayList<String>();
                column.add(StringUtils.quotize(dbColumn.getName()));
                column.add(this.translateType(dbColumn));
                for (DbColumnConstraint cc : dbColumn.getColumnConstraints()) {
                    column.add(cc.translate());
                }
                if (dbColumn.isDefaultValueSet()) {
                    column.add("DEFAULT");
                    column.add(this.translate(dbColumn.getDefaultValue()));
                }
                columns.add(org.apache.commons.lang3.StringUtils.join(column, (String)" "));
            }
            createTable.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", "));
            ArrayList<String> pks = new ArrayList<String>();
            for (String pk : entity.getPkFields()) {
                pks.add(StringUtils.quotize(pk));
            }
            if (!pks.isEmpty()) {
                createTable.add(",");
                String string = StringUtils.md5(String.format("PK_%s", entity.getName()), this.properties.getMaxIdentifierSize());
                createTable.add("CONSTRAINT");
                createTable.add(StringUtils.quotize(string));
                createTable.add("PRIMARY KEY");
                createTable.add("(" + org.apache.commons.lang3.StringUtils.join(pks, (String)", ") + ")");
            }
            createTable.add(")");
            String string = org.apache.commons.lang3.StringUtils.join(createTable, (String)" ");
            this.logger.trace(string);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(string);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().equals("42P07")) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.TABLE_ALREADY_EXISTS), ex);
                    break block18;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void addPrimaryKey(DbEntity entity) throws DatabaseEngineException {
    }

    @Override
    public Class<? extends AbstractTranslator> getTranslatorClass() {
        return CockroachDBTranslator.class;
    }

    @Override
    protected void updatePersistAutoIncSequence(MappedEntity mappedEntity, long currentAutoIncVal) {
        this.executeUpdateSilently(String.format("SELECT setval('%s', %d, false)", this.getQuotizedSequenceName(mappedEntity.getEntity(), mappedEntity.getAutoIncColumn()), currentAutoIncVal + 1L));
    }

    @Override
    protected void addFks(DbEntity entity, Set<DbFk> fks) throws DatabaseEngineException {
        try {
            super.addFks(entity, fks);
        }
        catch (DatabaseEngineException ex) {
            SQLException sqlException;
            if (ex.getCause() instanceof SQLException && (sqlException = (SQLException)ex.getCause()).getSQLState().equals(CONSTRAINT_NAME_ALREADY_EXISTS_COCKROACH)) {
                this.logger.debug(dev, "Foreign key for table '{}' already exists. Error code: {}.", (Object)entity.getName(), (Object)sqlException.getSQLState());
                return;
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addSequences(DbEntity entity) throws DatabaseEngineException {
        for (DbColumn column : entity.getColumns()) {
            if (!column.isAutoInc()) continue;
            String sequenceName = this.getQuotizedSequenceName(entity, column.getName());
            StringBuilder createSequence = new StringBuilder().append("CREATE SEQUENCE ").append(sequenceName).append(" MINVALUE 0 MAXVALUE ");
            switch (column.getDbColumnType()) {
                case INT: {
                    createSequence.append(Integer.MAX_VALUE);
                    break;
                }
                case LONG: {
                    createSequence.append(Long.MAX_VALUE);
                    break;
                }
                default: {
                    throw new DatabaseEngineException("Auto incrementation is only supported on INT and LONG");
                }
            }
            createSequence.append(" START 1 INCREMENT 1;");
            createSequence.append("ALTER TABLE ").append(StringUtils.quotize(entity.getName())).append(" ALTER COLUMN ").append(StringUtils.quotize(column.getName())).append(" SET DEFAULT nextval('").append(sequenceName).append("')");
            String statement = createSequence.toString();
            this.logger.trace(statement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(statement);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().equals("42P07")) {
                    this.logger.debug(dev, "Sequence {} is already defined", (Object)sequenceName);
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.SEQUENCE_ALREADY_EXISTS), ex);
                    continue;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s == null) continue;
                    s.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropSequences(DbEntity entity) throws DatabaseEngineException {
        for (DbColumn column : entity.getColumns()) {
            if (!column.isAutoInc()) continue;
            String sequenceName = this.getQuotizedSequenceName(entity, column.getName());
            String stmt = String.format("DROP SEQUENCE %s", sequenceName);
            Statement drop = null;
            try {
                drop = this.conn.createStatement();
                this.logger.trace(stmt);
                drop.executeUpdate(stmt);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().equals("42P01")) {
                    this.logger.debug(dev, "Sequence {} does not exist", (Object)sequenceName);
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.SEQUENCE_DOES_NOT_EXIST), ex);
                    continue;
                }
                throw new DatabaseEngineException("Error dropping sequence", ex);
            }
            finally {
                try {
                    if (drop == null) continue;
                    drop.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public synchronized Map<String, DbColumnType> getMetadata(String schemaPattern, String tableNamePattern) throws DatabaseEngineException {
        LinkedHashMap<String, DbColumnType> metaMap = new LinkedHashMap<String, DbColumnType>();
        ResultSet rsColumns = null;
        try {
            this.getConnection();
            DatabaseMetaData meta = this.conn.getMetaData();
            rsColumns = meta.getColumns(null, schemaPattern, tableNamePattern, null);
            while (rsColumns.next()) {
                String columnName = rsColumns.getString("COLUMN_NAME");
                if (columnName.equals("rowid")) continue;
                metaMap.put(columnName, this.toPdbType(rsColumns.getInt("DATA_TYPE"), rsColumns.getString("TYPE_NAME")));
            }
            LinkedHashMap<String, DbColumnType> linkedHashMap = metaMap;
            return linkedHashMap;
        }
        catch (Exception e) {
            throw new DatabaseEngineException("Could not get metadata", e);
        }
        finally {
            try {
                if (rsColumns != null) {
                    rsColumns.close();
                }
            }
            catch (Exception a) {
                this.logger.trace("Error closing result set.", (Throwable)a);
            }
        }
    }

    private String getQuotizedSequenceName(DbEntity entity, String colName) {
        return StringUtils.quotize(StringUtils.md5(String.format("%s_%s_SEQ", entity.getName(), colName), this.properties.getMaxIdentifierSize()));
    }
}

