/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.ddl;

import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnType;
import com.feedzai.commons.sql.abstraction.dml.K;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class DbColumn
implements Serializable {
    private final String name;
    private final DbColumnType dbColumnType;
    private final Integer size;
    private final List<DbColumnConstraint> columnConstraints;
    private final boolean autoInc;
    private final K defaultValue;

    private DbColumn(String name, DbColumnType dbColumnType, Integer size, List<DbColumnConstraint> columnConstraints, boolean autoInc, K defaultValue) {
        this.name = name;
        this.dbColumnType = dbColumnType;
        this.size = size;
        this.columnConstraints = columnConstraints;
        this.autoInc = autoInc;
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public DbColumnType getDbColumnType() {
        return this.dbColumnType;
    }

    public Integer getSize() {
        return this.size;
    }

    public List<DbColumnConstraint> getColumnConstraints() {
        return this.columnConstraints;
    }

    public boolean isAutoInc() {
        return this.autoInc;
    }

    public K getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isDefaultValueSet() {
        return this.defaultValue != null;
    }

    public boolean isSizeSet() {
        return this.size != null;
    }

    public Builder newBuilder() {
        return new Builder().name(this.name).type(this.dbColumnType).size(this.size).addConstraints(this.columnConstraints).autoInc(this.autoInc).defaultValue(this.defaultValue);
    }

    public static class Builder
    implements com.feedzai.commons.sql.abstraction.util.Builder<DbColumn>,
    Serializable {
        private String name;
        private DbColumnType dbColumnType;
        private Integer size = null;
        private final List<DbColumnConstraint> columnConstraints = new ArrayList<DbColumnConstraint>();
        private boolean autoInc = false;
        private K defaultValue = null;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public Builder type(DbColumnType dbColumnType) {
            this.dbColumnType = dbColumnType;
            return this;
        }

        public Builder addConstraint(DbColumnConstraint dbColumnConstraint) {
            this.columnConstraints.add(dbColumnConstraint);
            return this;
        }

        public Builder addConstraints(DbColumnConstraint ... constraints) {
            if (constraints == null) {
                return this;
            }
            return this.addConstraints(Arrays.asList(constraints));
        }

        public Builder addConstraints(Collection<DbColumnConstraint> constraints) {
            this.columnConstraints.addAll(constraints);
            return this;
        }

        public Builder autoInc(boolean autoInc) {
            this.autoInc = autoInc;
            return this;
        }

        public Builder defaultValue(K defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        public DbColumn build() {
            return new DbColumn(this.name, this.dbColumnType, this.size, (List<DbColumnConstraint>)ImmutableList.copyOf(this.columnConstraints), this.autoInc, this.defaultValue);
        }
    }
}

