/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.ddl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class DbFk
implements Serializable {
    private final List<String> localColumns;
    private final List<String> referencedColumns;
    private final String referencedTable;
    private final int hashCode;

    private DbFk(Builder builder) {
        this.localColumns = ImmutableList.copyOf((Collection)builder.localColumns);
        this.referencedColumns = ImmutableList.copyOf((Collection)builder.referencedColumns);
        this.referencedTable = builder.referencedTable;
        this.hashCode = Objects.hash(this.localColumns, this.referencedColumns, this.referencedTable);
    }

    public List<String> getLocalColumns() {
        return this.localColumns;
    }

    @Deprecated
    public List<String> getForeignColumns() {
        return this.referencedColumns;
    }

    public List<String> getReferencedColumns() {
        return this.referencedColumns;
    }

    @Deprecated
    public String getForeignTable() {
        return this.referencedTable;
    }

    public String getReferencedTable() {
        return this.referencedTable;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DbFk dbFk = (DbFk)obj;
        return this.localColumns.equals(dbFk.localColumns) && this.referencedColumns.equals(dbFk.referencedColumns) && this.referencedTable.equals(dbFk.referencedTable);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static class Builder
    implements com.feedzai.commons.sql.abstraction.util.Builder<DbFk>,
    Serializable {
        private final List<String> localColumns = new LinkedList<String>();
        private final List<String> referencedColumns = new LinkedList<String>();
        private String referencedTable = null;

        @Deprecated
        public Builder foreignTable(String referencedTable) {
            return this.referencedTable(referencedTable);
        }

        public Builder referencedTable(String referencedTable) {
            this.referencedTable = referencedTable;
            return this;
        }

        public Builder addColumn(String ... columns) {
            return this.addColumns(Arrays.asList(columns));
        }

        public Builder addColumns(Collection<String> columns) {
            this.localColumns.addAll(columns);
            return this;
        }

        @Deprecated
        public Builder addForeignColumn(String ... columns) {
            return this.addReferencedColumn(columns);
        }

        @Deprecated
        public Builder addForeignColumns(Collection<String> columns) {
            return this.addReferencedColumns(columns);
        }

        public Builder addReferencedColumn(String ... columns) {
            return this.addReferencedColumns(Arrays.asList(columns));
        }

        public Builder addReferencedColumns(Collection<String> columns) {
            this.referencedColumns.addAll(columns);
            return this;
        }

        @Override
        public DbFk build() {
            Preconditions.checkNotNull((Object)this.referencedTable, (Object)"The referenced table can't be null.");
            Preconditions.checkArgument((this.localColumns.size() == this.referencedColumns.size() ? 1 : 0) != 0, (String)"The number of local columns and referenced columns must be the same. local: %s ; referenced: %s", this.localColumns, this.referencedColumns);
            return new DbFk(this);
        }
    }
}

