/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.ddl;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class DbFk
implements Serializable {
    private final List<String> localColumns;
    private final List<String> referencedColumns;
    private final String referencedTable;

    private DbFk(Builder builder) {
        this.localColumns = ImmutableList.copyOf((Collection)builder.localColumns);
        this.referencedColumns = ImmutableList.copyOf((Collection)builder.referencedColumns);
        this.referencedTable = builder.referencedTable;
    }

    public List<String> getLocalColumns() {
        return this.localColumns;
    }

    @Deprecated
    public List<String> getForeignColumns() {
        return this.referencedColumns;
    }

    public List<String> getReferencedColumns() {
        return this.referencedColumns;
    }

    @Deprecated
    public String getForeignTable() {
        return this.referencedTable;
    }

    public String getReferencedTable() {
        return this.referencedTable;
    }

    public static class Builder
    implements com.feedzai.commons.sql.abstraction.util.Builder<DbFk>,
    Serializable {
        private final List<String> localColumns = new ArrayList<String>();
        private final List<String> referencedColumns = new ArrayList<String>();
        private String referencedTable = null;

        @Deprecated
        public Builder foreignTable(String referencedTable) {
            return this.referencedTable(referencedTable);
        }

        public Builder referencedTable(String referencedTable) {
            this.referencedTable = referencedTable;
            return this;
        }

        public Builder addColumn(String ... columns) {
            return this.addColumns(Arrays.asList(columns));
        }

        public Builder addColumns(Collection<String> columns) {
            this.localColumns.addAll(columns);
            return this;
        }

        @Deprecated
        public Builder addForeignColumn(String ... columns) {
            return this.addReferencedColumn(columns);
        }

        @Deprecated
        public Builder addForeignColumns(Collection<String> columns) {
            return this.addReferencedColumns(columns);
        }

        public Builder addReferencedColumn(String ... columns) {
            return this.addReferencedColumns(Arrays.asList(columns));
        }

        public Builder addReferencedColumns(Collection<String> columns) {
            this.referencedColumns.addAll(columns);
            return this;
        }

        @Override
        public DbFk build() {
            Objects.requireNonNull(this.referencedTable, "The referenced table can't be null");
            return new DbFk(this);
        }
    }
}

