/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.impl;

import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.dml.Cast;
import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.dml.RepeatDelimiter;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineRuntimeException;
import com.feedzai.commons.sql.abstraction.engine.OperationNotSupportedRuntimeException;
import com.feedzai.commons.sql.abstraction.engine.impl.PostgreSqlTranslator;
import java.util.ArrayList;

public class CockroachDBTranslator
extends PostgreSqlTranslator {
    @Override
    public String translate(DbColumn c) {
        switch (c.getDbColumnType()) {
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case DOUBLE: {
                return "DOUBLE PRECISION";
            }
            case INT: {
                return "INT4";
            }
            case LONG: {
                return "INT8";
            }
            case STRING: {
                return String.format("VARCHAR(%s)", c.isSizeSet() ? c.getSize().toString() : this.properties.getProperty("pdb.varchar_size"));
            }
            case CLOB: {
                return "TEXT";
            }
            case BLOB: {
                return "BYTEA";
            }
            case JSON: {
                return "JSONB";
            }
        }
        throw new DatabaseEngineRuntimeException(String.format("Mapping not found for '%s'. Please report this error.", new Object[]{c.getDbColumnType()}));
    }

    @Override
    public String translate(Cast cast) {
        String type;
        switch (cast.getType()) {
            case BOOLEAN: {
                type = "BOOLEAN";
                break;
            }
            case DOUBLE: {
                type = "DOUBLE PRECISION";
                break;
            }
            case INT: {
                type = "INT4";
                break;
            }
            case LONG: {
                type = "INT8";
                break;
            }
            case STRING: {
                type = "VARCHAR";
                break;
            }
            default: {
                throw new OperationNotSupportedRuntimeException(String.format("Cannot cast to '%s'.", new Object[]{cast.getType()}));
            }
        }
        this.inject(cast.getExpression());
        String translation = String.format("CAST(%s AS %s)", cast.getExpression().translate(), type);
        return cast.isEnclosed() ? "(" + translation + ")" : translation;
    }

    @Override
    public String translate(RepeatDelimiter rd) {
        String delimiter = rd.getDelimiter();
        ArrayList<String> all = new ArrayList<String>();
        for (Expression expression : rd.getExpressions()) {
            this.inject(expression);
            if (" / ".equals(delimiter)) {
                all.add(String.format("CAST(%s AS DOUBLE PRECISION)", expression.translate()));
                continue;
            }
            all.add(expression.translate());
        }
        if (rd.isEnclosed()) {
            return "(" + this.join(all, delimiter) + ")";
        }
        return this.join(all, delimiter);
    }
}

