/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.impl;

import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnType;
import com.feedzai.commons.sql.abstraction.ddl.DbEntity;
import com.feedzai.commons.sql.abstraction.ddl.DbFk;
import com.feedzai.commons.sql.abstraction.ddl.DbIndex;
import com.feedzai.commons.sql.abstraction.dml.dialect.Dialect;
import com.feedzai.commons.sql.abstraction.dml.result.DB2ResultIterator;
import com.feedzai.commons.sql.abstraction.dml.result.ResultColumn;
import com.feedzai.commons.sql.abstraction.dml.result.ResultIterator;
import com.feedzai.commons.sql.abstraction.engine.AbstractDatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.AbstractTranslator;
import com.feedzai.commons.sql.abstraction.engine.ConnectionResetException;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineDriver;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineRuntimeException;
import com.feedzai.commons.sql.abstraction.engine.MappedEntity;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.engine.handler.OperationFault;
import com.feedzai.commons.sql.abstraction.engine.impl.DB2Translator;
import com.feedzai.commons.sql.abstraction.entry.EntityEntry;
import com.feedzai.commons.sql.abstraction.util.PreparedStatementCapsule;
import com.feedzai.commons.sql.abstraction.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DB2Engine
extends AbstractDatabaseEngine {
    protected static final String DB2_DRIVER = DatabaseEngineDriver.DB2.driver();
    public static final String NAME_ALREADY_EXISTS = "DB2 SQL Error: SQLCODE=-601, SQLSTATE=42710";
    public static final String TABLE_CAN_ONLY_HAVE_ONE_PRIMARY_KEY = "DB2 SQL Error: SQLCODE=-624, SQLSTATE=42889";
    public static final String SEQUENCE_DOES_NOT_EXIST = "DB2 SQL Error: SQLCODE=-204, SQLSTATE=42704";
    public static final String TABLE_OR_VIEW_DOES_NOT_EXIST = "DB2 SQL Error: SQLCODE=-204, SQLSTATE=42704";
    public static final String FOREIGN_ALREADY_EXISTS = "DB2 SQL Error: SQLCODE=-601, SQLSTATE=42710";
    public static final String DB2_DEFAULT_BLOB_SIZE = "2G";

    public DB2Engine(PdbProperties properties) throws DatabaseEngineException {
        super(DB2_DRIVER, properties, Dialect.DB2);
    }

    @Override
    public Class<? extends AbstractTranslator> getTranslatorClass() {
        return DB2Translator.class;
    }

    @Override
    protected int entityToPreparedStatement(DbEntity entity, PreparedStatement ps, EntityEntry entry, boolean useAutoInc) throws DatabaseEngineException {
        int i = 1;
        for (DbColumn column : entity.getColumns()) {
            if (column.isAutoInc() && useAutoInc) continue;
            try {
                Object val = column.isDefaultValueSet() && !entry.containsKey(column.getName()) ? column.getDefaultValue().getConstant() : entry.get(column.getName());
                switch (column.getDbColumnType()) {
                    case JSON: 
                    case CLOB: 
                    case BLOB: {
                        ps.setBytes(i, this.objectToArray(val));
                        break;
                    }
                    case BOOLEAN: {
                        Boolean b = (Boolean)val;
                        if (b == null) {
                            ps.setObject(i, null);
                            break;
                        }
                        if (b.booleanValue()) {
                            ps.setObject(i, "1");
                            break;
                        }
                        ps.setObject(i, "0");
                        break;
                    }
                    default: {
                        ps.setObject(i, val);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                throw new DatabaseEngineException("Error while mapping variables to database", ex);
            }
            ++i;
        }
        return i - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createTable(DbEntity entity) throws DatabaseEngineException {
        block16: {
            ArrayList<String> createTable = new ArrayList<String>();
            createTable.add("CREATE TABLE");
            createTable.add(StringUtils.quotize(entity.getName()));
            ArrayList<String> columns = new ArrayList<String>();
            for (DbColumn c : entity.getColumns()) {
                ArrayList<String> column = new ArrayList<String>();
                column.add(StringUtils.quotize(c.getName()));
                column.add(this.translateType(c));
                for (DbColumnConstraint cc : c.getColumnConstraints()) {
                    column.add(cc.translate());
                }
                if (c.isDefaultValueSet()) {
                    column.add("DEFAULT");
                    column.add(this.translate(c.getDefaultValue()));
                }
                columns.add(org.apache.commons.lang3.StringUtils.join(column, (String)" "));
            }
            createTable.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
            String createTableStatement = org.apache.commons.lang3.StringUtils.join(createTable, (String)" ");
            this.logger.trace(createTableStatement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(createTableStatement);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith("DB2 SQL Error: SQLCODE=-601, SQLSTATE=42710")) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.TABLE_ALREADY_EXISTS), ex);
                    break block16;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addPrimaryKey(DbEntity entity) throws DatabaseEngineException {
        block15: {
            if (entity.getPkFields().size() == 0) {
                return;
            }
            ArrayList<String> pks = new ArrayList<String>();
            for (String pk : entity.getPkFields()) {
                pks.add(StringUtils.quotize(pk));
            }
            String alterColumnSetNotNull = this.alterColumnSetNotNull(entity.getName(), entity.getPkFields());
            String pkName = StringUtils.md5(String.format("PK_%s", entity.getName()), this.properties.getMaxIdentifierSize());
            ArrayList<String> statement = new ArrayList<String>();
            statement.add("ALTER TABLE");
            statement.add(StringUtils.quotize(entity.getName()));
            statement.add("ADD CONSTRAINT");
            statement.add(StringUtils.quotize(pkName));
            statement.add("PRIMARY KEY");
            statement.add("(" + org.apache.commons.lang3.StringUtils.join(pks, (String)", ") + ")");
            String addPrimaryKey = org.apache.commons.lang3.StringUtils.join(statement, (String)" ");
            String reorg = this.reorg(entity.getName());
            Statement s = null;
            try {
                this.logger.trace(alterColumnSetNotNull);
                s = this.conn.createStatement();
                s.executeUpdate(alterColumnSetNotNull);
                s.close();
                this.logger.trace(reorg);
                s = this.conn.createStatement();
                s.executeUpdate(reorg);
                s.close();
                this.logger.trace(addPrimaryKey);
                s = this.conn.createStatement();
                s.executeUpdate(addPrimaryKey);
                s.close();
                this.logger.trace(reorg);
                s = this.conn.createStatement();
                s.executeUpdate(reorg);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith(TABLE_CAN_ONLY_HAVE_ONE_PRIMARY_KEY)) {
                    this.logger.debug(dev, "'{}' already has a primary key", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.PRIMARY_KEY_ALREADY_EXISTS), ex);
                    break block15;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    private String reorg(String tableName) {
        ArrayList<String> statement = new ArrayList<String>();
        statement.add("CALL sysproc.admin_cmd('REORG TABLE");
        statement.add(StringUtils.quotize(tableName));
        statement.add("')");
        return org.apache.commons.lang3.StringUtils.join(statement, (String)" ");
    }

    private String alterColumnSetNotNull(String tableName, List<String> columnNames) {
        ArrayList<String> statement = new ArrayList<String>();
        statement.add("ALTER TABLE");
        statement.add(StringUtils.quotize(tableName));
        for (String columnName : columnNames) {
            statement.add("ALTER COLUMN");
            statement.add(StringUtils.quotize(columnName));
            statement.add("SET NOT NULL");
        }
        return org.apache.commons.lang3.StringUtils.join(statement, (String)" ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addIndexes(DbEntity entity) throws DatabaseEngineException {
        List<DbIndex> indexes = entity.getIndexes();
        for (DbIndex index : indexes) {
            ArrayList<String> createIndex = new ArrayList<String>();
            createIndex.add("CREATE");
            if (index.isUnique()) {
                createIndex.add("UNIQUE");
            }
            createIndex.add("INDEX");
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<String> columnsForName = new ArrayList<String>();
            for (String column : index.getColumns()) {
                columns.add(StringUtils.quotize(column));
                columnsForName.add(column);
            }
            String idxName = StringUtils.md5(String.format("%s_%s_IDX", entity.getName(), org.apache.commons.lang3.StringUtils.join(columnsForName, (String)"_")), this.properties.getMaxIdentifierSize());
            createIndex.add(StringUtils.quotize(idxName));
            createIndex.add("ON");
            createIndex.add(StringUtils.quotize(entity.getName()));
            createIndex.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
            String statement = org.apache.commons.lang3.StringUtils.join(createIndex, (String)" ");
            this.logger.trace(statement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(statement);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith("DB2 SQL Error: SQLCODE=-601, SQLSTATE=42710")) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)idxName);
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.INDEX_ALREADY_EXISTS), ex);
                    continue;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s == null) continue;
                    s.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addSequences(DbEntity entity) throws DatabaseEngineException {
        for (DbColumn column : entity.getColumns()) {
            if (!column.isAutoInc()) continue;
            String sequenceName = StringUtils.md5(String.format("%s_%s_SEQ", entity.getName(), column.getName()), this.properties.getMaxIdentifierSize());
            ArrayList<String> createSequence = new ArrayList<String>();
            createSequence.add("CREATE SEQUENCE");
            createSequence.add(StringUtils.quotize(sequenceName));
            createSequence.add("MINVALUE 0");
            switch (column.getDbColumnType()) {
                case INT: {
                    createSequence.add("MAXVALUE");
                    createSequence.add(String.format("%d", Integer.MAX_VALUE));
                    break;
                }
                case LONG: {
                    createSequence.add("NO MAXVALUE");
                    break;
                }
                default: {
                    throw new DatabaseEngineException("Auto incrementation is only supported on INT and LONG");
                }
            }
            createSequence.add("START WITH 1");
            createSequence.add("INCREMENT BY 1");
            String statement = org.apache.commons.lang3.StringUtils.join(createSequence, (String)" ");
            this.logger.trace(statement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(statement);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith("DB2 SQL Error: SQLCODE=-601, SQLSTATE=42710")) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)sequenceName);
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.SEQUENCE_ALREADY_EXISTS), ex);
                    continue;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s == null) continue;
                    s.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public synchronized int executeUpdate(String query) throws DatabaseEngineException {
        String[] split = query.split("\u001f");
        int i = -1;
        for (String s : split) {
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)s)) continue;
            i = super.executeUpdate(s);
        }
        return i;
    }

    @Override
    protected MappedEntity createPreparedStatementForInserts(DbEntity entity) throws DatabaseEngineException {
        ArrayList<String> insertInto = new ArrayList<String>();
        insertInto.add("INSERT INTO");
        insertInto.add(StringUtils.quotize(entity.getName()));
        ArrayList<String> insertIntoWithAutoInc = new ArrayList<String>();
        insertIntoWithAutoInc.add("INSERT INTO");
        insertIntoWithAutoInc.add(StringUtils.quotize(entity.getName()));
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> columnsWithAutoInc = new ArrayList<String>();
        ArrayList<String> valuesWithAutoInc = new ArrayList<String>();
        String returning = null;
        for (DbColumn column : entity.getColumns()) {
            columnsWithAutoInc.add(StringUtils.quotize(column.getName()));
            valuesWithAutoInc.add("?");
            columns.add(StringUtils.quotize(column.getName()));
            if (column.isAutoInc()) {
                String sequenceName = StringUtils.md5(String.format("%s_%s_SEQ", entity.getName(), column.getName()), this.properties.getMaxIdentifierSize());
                values.add(String.format("%s.nextval", StringUtils.quotize(sequenceName)));
                returning = column.getName();
                continue;
            }
            values.add("?");
        }
        insertInto.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
        insertInto.add("VALUES (" + org.apache.commons.lang3.StringUtils.join(values, (String)", ") + ")");
        insertIntoWithAutoInc.add("(" + org.apache.commons.lang3.StringUtils.join(columnsWithAutoInc, (String)", ") + ")");
        insertIntoWithAutoInc.add("VALUES (" + org.apache.commons.lang3.StringUtils.join(valuesWithAutoInc, (String)", ") + ")");
        ArrayList insertIntoReturn = new ArrayList(insertInto);
        String insertStatement = org.apache.commons.lang3.StringUtils.join(insertInto, (String)" ");
        String insertReturnStatement = org.apache.commons.lang3.StringUtils.join(insertIntoReturn, (String)" ");
        String insertWithAutoInc = org.apache.commons.lang3.StringUtils.join(insertIntoWithAutoInc, (String)" ");
        this.logger.trace(insertStatement);
        this.logger.trace(insertReturnStatement);
        try {
            PreparedStatement ps = this.conn.prepareStatement(insertStatement);
            PreparedStatement psReturn = this.conn.prepareStatement(insertReturnStatement);
            PreparedStatement psWithAutoInc = this.conn.prepareStatement(insertWithAutoInc);
            return new MappedEntity().setInsert(ps).setInsertReturning(psReturn).setInsertWithAutoInc(psWithAutoInc).setAutoIncColumn(returning);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropSequences(DbEntity entity) throws DatabaseEngineException {
        for (DbColumn column : entity.getColumns()) {
            if (!column.isAutoInc()) continue;
            String sequenceName = StringUtils.md5(String.format("%s_%s_SEQ", entity.getName(), column.getName()), this.properties.getMaxIdentifierSize());
            String stmt = String.format("DROP SEQUENCE %s", StringUtils.quotize(sequenceName));
            Statement drop = null;
            try {
                drop = this.conn.createStatement();
                this.logger.trace(stmt);
                drop.executeUpdate(stmt);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith("DB2 SQL Error: SQLCODE=-204, SQLSTATE=42704")) {
                    this.logger.debug(dev, "Sequence '{}' does not exist", (Object)sequenceName);
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.SEQUENCE_DOES_NOT_EXIST), ex);
                    continue;
                }
                throw new DatabaseEngineException("Error dropping sequence", ex);
            }
            finally {
                try {
                    if (drop == null) continue;
                    drop.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropTable(DbEntity entity) throws DatabaseEngineException {
        block13: {
            Statement drop = null;
            try {
                drop = this.conn.createStatement();
                String query = String.format("DROP TABLE %s", StringUtils.quotize(entity.getName()));
                this.logger.trace(query);
                drop.executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith("DB2 SQL Error: SQLCODE=-204, SQLSTATE=42704")) {
                    this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.TABLE_DOES_NOT_EXIST), ex);
                    break block13;
                }
                throw new DatabaseEngineException("Error dropping table", ex);
            }
            finally {
                try {
                    if (drop != null) {
                        drop.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropColumn(DbEntity entity, String ... columns) throws DatabaseEngineException {
        block21: {
            Statement drop = null;
            Statement reorgStatement = null;
            ArrayList<String> removeColumns = new ArrayList<String>();
            removeColumns.add("ALTER TABLE");
            removeColumns.add(StringUtils.quotize(entity.getName()));
            for (String col : columns) {
                removeColumns.add("DROP COLUMN");
                removeColumns.add(StringUtils.quotize(col));
            }
            try {
                drop = this.conn.createStatement();
                String query = org.apache.commons.lang3.StringUtils.join(removeColumns, (String)" ");
                this.logger.trace(query);
                drop.executeUpdate(query);
                String reorg = this.reorg(entity.getName());
                this.logger.trace(reorg);
                reorgStatement = this.conn.createStatement();
                reorgStatement.executeUpdate(reorg);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith("DB2 SQL Error: SQLCODE=-204, SQLSTATE=42704")) {
                    this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.COLUMN_DOES_NOT_EXIST), ex);
                    break block21;
                }
                throw new DatabaseEngineException("Error dropping column", ex);
            }
            finally {
                try {
                    if (drop != null) {
                        drop.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
                try {
                    if (reorgStatement != null) {
                        reorgStatement.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public synchronized void updateEntity(DbEntity entity) throws DatabaseEngineException {
        super.updateEntity(entity);
        try (Statement reorg = this.conn.createStatement();){
            reorg.executeUpdate(this.reorg(entity.getName()));
        }
        catch (SQLException e) {
            throw new DatabaseEngineException("Error reorganizing table '" + entity.getName() + "'", e);
        }
    }

    @Override
    protected void addColumn(DbEntity entity, DbColumn ... columns) throws DatabaseEngineException {
        ArrayList<String> addColumns = new ArrayList<String>();
        addColumns.add("ALTER TABLE");
        addColumns.add(StringUtils.quotize(entity.getName(), this.translator.translateEscape()));
        for (DbColumn c : columns) {
            addColumns.add("ADD COLUMN");
            ArrayList<String> column = new ArrayList<String>();
            column.add(StringUtils.quotize(c.getName(), this.translator.translateEscape()));
            column.add(this.translateType(c));
            for (DbColumnConstraint cc : c.getColumnConstraints()) {
                column.add(cc.translate());
            }
            if (c.isDefaultValueSet()) {
                column.add("DEFAULT");
                column.add(this.translate(c.getDefaultValue()));
            }
            addColumns.add(org.apache.commons.lang3.StringUtils.join(column, (String)" "));
        }
        String addColumnsStatement = org.apache.commons.lang3.StringUtils.join(addColumns, (String)" ");
        this.logger.trace(addColumnsStatement);
        Statement s = null;
        Statement reorgStatement = null;
        try {
            s = this.conn.createStatement();
            s.executeUpdate(addColumnsStatement);
            String reorg = this.reorg(entity.getName());
            this.logger.trace(reorg);
            reorgStatement = this.conn.createStatement();
            reorgStatement.executeUpdate(reorg);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
            try {
                if (reorgStatement != null) {
                    reorgStatement.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    @Override
    protected synchronized long doPersist(PreparedStatement ps, MappedEntity me, boolean useAutoInc, int lastBindPosition) throws Exception {
        ps.execute();
        if (me.getAutoIncColumn() == null) {
            return 0L;
        }
        String name = me.getEntity().getName();
        String quotizedSeqName = StringUtils.quotize(StringUtils.md5(String.format("%s_%s_SEQ", name, me.getAutoIncColumn()), this.properties.getMaxIdentifierSize()));
        long ret = 0L;
        if (useAutoInc) {
            Iterator<ResultColumn> iterator;
            List<Map<String, ResultColumn>> q = this.query(String.format("SELECT PREVIOUS VALUE FOR %s FROM sysibm.sysdummy1", quotizedSeqName));
            if (!q.isEmpty() && (iterator = q.get(0).values().iterator()).hasNext()) {
                ResultColumn rc = iterator.next();
                return rc.toLong();
            }
        } else {
            List<Map<String, ResultColumn>> keys;
            String sql = "select (select max(\"" + me.getAutoIncColumn() + "\") from \"" + name + "\") , " + quotizedSeqName + ".NEXTVAL FROM sysibm.sysdummy1";
            List<Map<String, ResultColumn>> q = this.query(sql);
            if (!q.isEmpty()) {
                Iterator<ResultColumn> it = q.get(0).values().iterator();
                long max = Optional.ofNullable(it.next().toLong()).orElse(-1L);
                long seqCurVal = Optional.ofNullable(it.next().toLong()).orElse(-1L);
                if (seqCurVal != max) {
                    this.executeUpdateSilently("ALTER SEQUENCE " + quotizedSeqName + " RESTART WITH " + (ret + 1L));
                }
            }
            if (!(keys = this.query(sql)).isEmpty()) {
                Iterator<ResultColumn> it = keys.get(0).values().iterator();
                ret = it.next().toLong();
                long seqCurVal = it.next().toLong();
                if (seqCurVal != ret) {
                    this.executeUpdateSilently("ALTER SEQUENCE " + quotizedSeqName + " RESTART WITH " + (ret + 1L));
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addFks(DbEntity entity) throws DatabaseEngineException {
        for (DbFk fk : entity.getFks()) {
            ArrayList<String> quotizedLocalColumns = new ArrayList<String>();
            for (String string : fk.getLocalColumns()) {
                quotizedLocalColumns.add(StringUtils.quotize(string));
            }
            ArrayList<String> quotizedForeignColumns = new ArrayList<String>();
            for (String s3 : fk.getForeignColumns()) {
                quotizedForeignColumns.add(StringUtils.quotize(s3));
            }
            String string = StringUtils.quotize(entity.getName(), this.translator.translateEscape());
            String quotizedLocalColumnsSting = org.apache.commons.lang3.StringUtils.join(quotizedLocalColumns, (String)", ");
            String quotizedForeignColumnsString = org.apache.commons.lang3.StringUtils.join(quotizedForeignColumns, (String)", ");
            String alterTable = String.format("ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s (%s)", string, StringUtils.quotize(StringUtils.md5("FK_" + string + quotizedLocalColumnsSting + quotizedForeignColumnsString, this.properties.getMaxIdentifierSize())), quotizedLocalColumnsSting, StringUtils.quotize(fk.getForeignTable()), quotizedForeignColumnsString);
            Statement alterTableStmt = null;
            Statement reorgStatement = null;
            try {
                alterTableStmt = this.conn.createStatement();
                this.logger.trace(alterTable);
                alterTableStmt.executeUpdate(alterTable);
                String reorg = this.reorg(entity.getName());
                this.logger.trace(reorg);
                reorgStatement = this.conn.createStatement();
                reorgStatement.executeUpdate(reorg);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith("DB2 SQL Error: SQLCODE=-601, SQLSTATE=42710")) {
                    this.logger.debug(dev, "Foreign key for table '{}' already exists. Error code: {}.", (Object)entity.getName(), (Object)ex.getMessage());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.FOREIGN_KEY_ALREADY_EXISTS), ex);
                    continue;
                }
                throw new DatabaseEngineException(String.format("Could not add Foreign Key to entity %s. Error code: %s.", entity.getName(), ex.getMessage()), ex);
            }
            finally {
                try {
                    if (alterTableStmt != null) {
                        alterTableStmt.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
                try {
                    if (reorgStatement == null) continue;
                    reorgStatement.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean checkConnection(Connection conn) {
        boolean bl;
        int timeout = this.properties.getCheckConnectionTimeout();
        int socketTimeout = conn.getNetworkTimeout();
        try {
            conn.setNetworkTimeout(this.socketTimeoutExecutor, timeout * 1000);
            bl = this.pingConnection(conn);
        }
        catch (Exception ex) {
            boolean bl2;
            try {
                this.logger.debug("It wasn't possible to verify the connection state within the timeout of {} seconds.", (Object)timeout, (Object)ex);
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    conn.setNetworkTimeout(this.socketTimeoutExecutor, socketTimeout);
                    throw throwable;
                }
                catch (Exception ex2) {
                    this.logger.warn("It wasn't possible to reset the connection / fetch the timeout.");
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        this.logger.debug("Error closing the connection.", (Throwable)e);
                    }
                    return false;
                }
            }
            conn.setNetworkTimeout(this.socketTimeoutExecutor, socketTimeout);
            return bl2;
        }
        conn.setNetworkTimeout(this.socketTimeoutExecutor, socketTimeout);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pingConnection(Connection conn) {
        Statement s = null;
        try {
            s = conn.createStatement();
            s.executeQuery("SELECT 1 FROM sysibm.sysdummy1");
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.logger.debug("Connection is down.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    @Override
    protected ResultIterator createResultIterator(Statement statement, String sql) throws DatabaseEngineException {
        return new DB2ResultIterator(statement, sql);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected String getSchema() throws DatabaseEngineException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void setSchema(String schema) throws DatabaseEngineException {
        boolean schemaExists;
        Throwable throwable;
        PreparedStatement ps;
        try {
            ps = this.conn.prepareStatement("SELECT count(*) FROM syscat.schemata WHERE SCHEMANAME = ?");
            throwable = null;
            try {
                ps.setString(1, schema);
                try (ResultSet resultSet = ps.executeQuery();){
                    schemaExists = resultSet.next() && resultSet.getInt(1) == 1;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ps != null) {
                    if (throwable != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new DatabaseEngineException(String.format("Could not set current schema to '%s'", schema), e);
        }
        if (!schemaExists) {
            throw new DatabaseEngineException(String.format("Could not set current schema to non existing '%s'", schema));
        }
        try {
            ps = this.conn.prepareStatement("SET CURRENT SCHEMA ?");
            throwable = null;
            try {
                ps.setString(1, schema);
                ps.execute();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (ps != null) {
                    if (throwable != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new DatabaseEngineException(String.format("Could not set current schema to '%s'", schema), e);
        }
    }

    @Override
    public synchronized Map<String, DbColumnType> getMetadata(String schemaPattern, String tableNamePattern) throws DatabaseEngineException {
        LinkedHashMap<String, DbColumnType> metaMap = new LinkedHashMap<String, DbColumnType>();
        PreparedStatement ps = null;
        ResultSet rsColumns = null;
        try {
            Object columnType;
            this.getConnection();
            ps = this.conn.prepareStatement("SELECT NAME, COLTYPE, SCALE FROM sysibm.SYSCOLUMNS WHERE tbname LIKE ? AND TBCREATOR LIKE ?");
            ps.setString(1, tableNamePattern == null ? "%" : tableNamePattern);
            ps.setString(2, schemaPattern == null ? "%" : schemaPattern);
            rsColumns = ps.executeQuery();
            while (rsColumns.next()) {
                columnType = rsColumns.getString("COLTYPE").trim();
                int scale = 0;
                try {
                    scale = Integer.parseInt(rsColumns.getString("SCALE"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                metaMap.put(rsColumns.getString("NAME"), this.toPdbType((String)(scale == 0 ? columnType : (String)columnType + scale)));
            }
            columnType = metaMap;
            return columnType;
        }
        catch (Exception e) {
            throw new DatabaseEngineException("Could not get metadata", e);
        }
        finally {
            try {
                if (rsColumns != null) {
                    rsColumns.close();
                }
            }
            catch (Exception a) {
                this.logger.trace("Error closing result set.", (Throwable)a);
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception a) {
                this.logger.trace("Error closing statement.", (Throwable)a);
            }
        }
    }

    private DbColumnType toPdbType(String type) {
        if (type.equals("INTEGER")) {
            return DbColumnType.INT;
        }
        if (type.equals("CHAR")) {
            return DbColumnType.BOOLEAN;
        }
        if (type.equals("DECIMAL")) {
            return DbColumnType.LONG;
        }
        if (type.equals("DOUBLE")) {
            return DbColumnType.DOUBLE;
        }
        if (type.equals("NUMBER19")) {
            return DbColumnType.LONG;
        }
        if (type.equals("VARCHAR2") || type.equals("VARCHAR")) {
            return DbColumnType.STRING;
        }
        if (type.equals("CLOB")) {
            return DbColumnType.BLOB;
        }
        if (type.equals("BLOB")) {
            return DbColumnType.BLOB;
        }
        return DbColumnType.UNMAPPED;
    }

    @Override
    public synchronized void setParameters(String name, Object ... params) throws DatabaseEngineException, ConnectionResetException {
        PreparedStatementCapsule ps = (PreparedStatementCapsule)this.stmts.get(name);
        if (ps == null) {
            throw new DatabaseEngineRuntimeException(String.format("PreparedStatement named '%s' does not exist", name));
        }
        int i = 1;
        for (Object o : params) {
            try {
                if (o instanceof byte[]) {
                    ps.ps.setBytes(i, (byte[])o);
                } else {
                    this.setObjectParameter(ps, i, o);
                }
            }
            catch (Exception ex) {
                if (this.checkConnection(this.conn) || !this.properties.isReconnectOnLost()) {
                    throw new DatabaseEngineException("Could not set parameters", ex);
                }
                this.reconnectExceptionally("Connection is down");
                throw new ConnectionResetException("Connection was lost, you must reset the prepared statement parameters and re-execute the statement");
            }
            ++i;
        }
    }

    @Override
    public synchronized void setParameter(String name, int index, Object param) throws DatabaseEngineException, ConnectionResetException {
        PreparedStatementCapsule ps = (PreparedStatementCapsule)this.stmts.get(name);
        if (ps == null) {
            throw new DatabaseEngineRuntimeException(String.format("PreparedStatement named '%s' does not exist", name));
        }
        try {
            if (param instanceof byte[]) {
                ps.ps.setBytes(index, (byte[])param);
            } else {
                this.setObjectParameter(ps, index, param);
            }
        }
        catch (Exception ex) {
            if (this.checkConnection(this.conn) || !this.properties.isReconnectOnLost()) {
                throw new DatabaseEngineException("Could not set parameter", ex);
            }
            this.reconnectExceptionally("Connection is down");
            throw new ConnectionResetException("Connection was lost, you must reset the prepared statement parameters and re-execute the statement");
        }
    }

    @Override
    public boolean isStringAggDistinctCapable() {
        return false;
    }

    private void setObjectParameter(PreparedStatementCapsule ps, int index, Object o) throws Exception {
        try {
            ps.ps.setObject(index, o);
        }
        catch (SQLException e) {
            if (!(o instanceof String)) {
                throw e;
            }
            ps.ps.setBytes(index, this.objectToArray(((String)o).getBytes()));
        }
    }

    @Override
    protected ResultIterator createResultIterator(PreparedStatement ps) throws DatabaseEngineException {
        return new DB2ResultIterator(ps);
    }
}

