/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml.result;

import com.feedzai.commons.sql.abstraction.dml.result.ResultColumn;
import com.feedzai.commons.sql.abstraction.engine.AbstractDatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.engine.handler.QueryExceptionHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResultIterator
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ResultIterator.class);
    private final Statement statement;
    private final ResultSet resultSet;
    private final List<String> columnNames;
    private boolean closed = false;
    private boolean statementCloseable;
    private int currentRowCount;

    private ResultIterator(Statement statement, String sql, boolean isPreparedStatement) throws DatabaseEngineException {
        this.statement = statement;
        this.columnNames = new ArrayList<String>();
        this.currentRowCount = 0;
        try {
            long start = System.currentTimeMillis();
            if (isPreparedStatement) {
                this.resultSet = ((PreparedStatement)statement).executeQuery();
                this.statementCloseable = false;
            } else {
                this.resultSet = statement.executeQuery(sql);
                this.statementCloseable = true;
            }
            logger.trace("[{} ms] {}", (Object)(System.currentTimeMillis() - start), (Object)(sql == null ? "" : sql));
            ResultSetMetaData meta = this.resultSet.getMetaData();
            int columnCount = meta.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                this.columnNames.add(meta.getColumnLabel(i));
            }
        }
        catch (Exception e) {
            throw this.closeAndHandleException(e, "Could not process result set.");
        }
    }

    public ResultIterator(Statement statement, String sql) throws DatabaseEngineException {
        this(statement, sql, false);
    }

    public ResultIterator(PreparedStatement statement) throws DatabaseEngineException {
        this(statement, null, true);
    }

    public int getCurrentRowCount() {
        return this.currentRowCount;
    }

    public Map<String, ResultColumn> next() throws DatabaseEngineException {
        try {
            if (this.closed) {
                return null;
            }
            if (!this.resultSet.next()) {
                this.close();
                return null;
            }
            ++this.currentRowCount;
            LinkedHashMap<String, ResultColumn> temp = new LinkedHashMap<String, ResultColumn>(this.columnNames.size());
            int i = 1;
            for (String cname : this.columnNames) {
                temp.put(cname, this.createResultColumn(cname, this.resultSet.getObject(i)));
                ++i;
            }
            return temp;
        }
        catch (Exception e) {
            throw this.closeAndHandleException(e, "Could not fetch data.");
        }
    }

    public ResultColumn[] nextResult() throws DatabaseEngineException {
        try {
            if (this.closed) {
                return null;
            }
            if (!this.resultSet.next()) {
                this.close();
                return null;
            }
            ++this.currentRowCount;
            ResultColumn[] temp = new ResultColumn[this.columnNames.size()];
            for (int i = 0; i < this.columnNames.size(); ++i) {
                temp[i] = this.createResultColumn(this.columnNames.get(i), this.resultSet.getObject(i + 1));
            }
            return temp;
        }
        catch (Exception e) {
            throw this.closeAndHandleException(e, "Could not fetch data.");
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public boolean cancel() {
        try {
            if (!this.closed) {
                this.statement.cancel();
            }
            return true;
        }
        catch (SQLException ex) {
            logger.debug("Could not cancel statement", (Throwable)ex);
            return false;
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            try {
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
            }
            catch (Exception e) {
                logger.warn("Could not close result set.", (Throwable)e);
            }
            if (this.statementCloseable && this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception e) {
                    logger.warn("Could not close statement.", (Throwable)e);
                }
            }
        }
        this.closed = true;
    }

    public abstract ResultColumn createResultColumn(String var1, Object var2);

    private DatabaseEngineException closeAndHandleException(Exception exception, String message) throws DatabaseEngineException {
        this.close();
        return this.getQueryExceptionHandler().handleException(exception, message);
    }

    protected QueryExceptionHandler getQueryExceptionHandler() {
        return AbstractDatabaseEngine.DEFAULT_QUERY_EXCEPTION_HANDLER;
    }
}

