/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml;

import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class RepeatDelimiter
extends Expression {
    public static final String AND = " AND ";
    public static final String OR = " OR ";
    public static final String PLUS = " + ";
    public static final String MINUS = " - ";
    public static final String MULT = " * ";
    public static final String DIV = " / ";
    public static final String GT = " > ";
    public static final String LT = " < ";
    public static final String GTEQ = " >= ";
    public static final String LTEQ = " <= ";
    public static final String LIKE = " LIKE ";
    public static final String EQ = " = ";
    public static final String NEQ = " <> ";
    public static final String COMMA = ", ";
    public static final String IN = " IN ";
    public static final String NOTIN = " NOT IN ";
    private String delimiter;
    private final List<Expression> expressions = new ArrayList<Expression>();

    public RepeatDelimiter(String delimiter, Expression ... dbe) {
        this.delimiter = delimiter;
        this.expressions.addAll(Arrays.asList(dbe));
    }

    public RepeatDelimiter(String delimiter, Collection<? extends Expression> dbe) {
        this.delimiter = delimiter;
        this.expressions.addAll(dbe);
    }

    public List<Expression> getExpressions() {
        return ImmutableList.copyOf(this.expressions);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    public String translate() {
        return this.translator.translate(this);
    }
}

