/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class StringUtils {
    public static String quotize(String s) {
        return StringUtils.quotize(s, "\"");
    }

    public static String quotize(String s, String quoteChar) {
        return quoteChar + s + quoteChar;
    }

    public static String singleQuotize(String s) {
        return StringUtils.quotize(s, "'");
    }

    public static String md5(String message) {
        byte[] res;
        try {
            MessageDigest instance = MessageDigest.getInstance("MD5");
            instance.reset();
            instance.update(message.getBytes());
            res = instance.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        StringBuilder hexString = new StringBuilder();
        for (byte resByte : res) {
            hexString.append(Integer.toString((resByte & 0xFF) + 256, 16).substring(1));
        }
        return hexString.toString();
    }

    public static String md5(String message, int nchar) {
        String hash = StringUtils.md5(message);
        return nchar > hash.length() ? hash : hash.substring(0, nchar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(InputStream stream) throws IOException {
        InputStreamReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            br = new InputStreamReader(stream);
            while (!Thread.currentThread().isInterrupted()) {
                int got = br.read();
                if (got == -1) {
                    break;
                }
                sb.append((char)got);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    public static String escapeSql(String str) {
        if (str == null) {
            return null;
        }
        return org.apache.commons.lang3.StringUtils.replace((String)str, (String)"'", (String)"''");
    }
}

