/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.impl;

import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnType;
import com.feedzai.commons.sql.abstraction.ddl.DbEntity;
import com.feedzai.commons.sql.abstraction.ddl.DbEntityType;
import com.feedzai.commons.sql.abstraction.ddl.DbFk;
import com.feedzai.commons.sql.abstraction.ddl.DbIndex;
import com.feedzai.commons.sql.abstraction.dml.dialect.Dialect;
import com.feedzai.commons.sql.abstraction.dml.result.MySqlResultIterator;
import com.feedzai.commons.sql.abstraction.dml.result.ResultIterator;
import com.feedzai.commons.sql.abstraction.engine.AbstractDatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.AbstractTranslator;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineDriver;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.engine.MappedEntity;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.engine.handler.OperationFault;
import com.feedzai.commons.sql.abstraction.engine.handler.QueryExceptionHandler;
import com.feedzai.commons.sql.abstraction.engine.impl.MySqlTranslator;
import com.feedzai.commons.sql.abstraction.engine.impl.mysql.MySqlQueryExceptionHandler;
import com.feedzai.commons.sql.abstraction.entry.EntityEntry;
import com.feedzai.commons.sql.abstraction.util.StringUtils;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MySqlEngine
extends AbstractDatabaseEngine {
    protected static final String MYSQL_DRIVER = DatabaseEngineDriver.MYSQL.driver();
    public static final int TABLE_NAME_ALREADY_EXISTS = 1050;
    public static final int DUPLICATE_KEY_NAME = 1061;
    public static final int TABLE_CAN_ONLY_HAVE_ONE_PRIMARY_KEY = 1068;
    public static final int TABLE_DOES_NOT_EXIST = 1051;
    public static final List<Integer> CONSTRAINT_NAME_ALREADY_EXISTS = Arrays.asList(1005, 1022);
    public static final QueryExceptionHandler MYSQL_QUERY_EXCEPTION_HANDLER = new MySqlQueryExceptionHandler();

    public MySqlEngine(PdbProperties properties) throws DatabaseEngineException {
        super(MYSQL_DRIVER, properties, Dialect.MYSQL);
    }

    private void setAnsiMode() throws SQLException {
        Statement s = this.conn.createStatement();
        s.executeUpdate("SET sql_mode = 'ansi'");
        s.close();
    }

    @Override
    protected int entityToPreparedStatement(DbEntity entity, PreparedStatement ps, EntityEntry entry, boolean useAutoInc) throws DatabaseEngineException {
        int i = 1;
        for (DbColumn column : entity.getColumns()) {
            if (column.isAutoInc() && useAutoInc) continue;
            try {
                Object val = column.isDefaultValueSet() && !entry.containsKey(column.getName()) ? column.getDefaultValue().getConstant() : entry.get(column.getName());
                switch (column.getDbColumnType()) {
                    case BLOB: {
                        ps.setBytes(i, this.objectToArray(val));
                        break;
                    }
                    case JSON: 
                    case CLOB: {
                        if (val == null) {
                            ps.setNull(i, 2005);
                            break;
                        }
                        if (val instanceof String) {
                            StringReader sr = new StringReader((String)val);
                            ps.setClob(i, sr);
                            break;
                        }
                        throw new DatabaseEngineException("Cannot convert " + val.getClass().getSimpleName() + " to String. CLOB columns only accept Strings.");
                    }
                    case BOOLEAN: {
                        Boolean b = (Boolean)val;
                        if (b == null) {
                            ps.setObject(i, null);
                            break;
                        }
                        if (b.booleanValue()) {
                            ps.setObject(i, 1);
                            break;
                        }
                        ps.setObject(i, 0);
                        break;
                    }
                    default: {
                        ps.setObject(i, val);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                throw new DatabaseEngineException("Error while mapping variable s to database", ex);
            }
            ++i;
        }
        return i - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createTable(DbEntity entity) throws DatabaseEngineException {
        block19: {
            ArrayList<String> createTable = new ArrayList<String>();
            createTable.add("CREATE TABLE");
            createTable.add(StringUtils.quotize(entity.getName(), this.escapeCharacter()));
            ArrayList<String> columns = new ArrayList<String>();
            String autoIncName = "";
            int numberOfAutoIncs = 0;
            for (DbColumn c : entity.getColumns()) {
                ArrayList<String> column = new ArrayList<String>();
                column.add(StringUtils.quotize(c.getName(), this.escapeCharacter()));
                column.add(this.translateType(c));
                if (c.isAutoInc()) {
                    autoIncName = c.getName();
                    column.add("AUTO_INCREMENT");
                    ++numberOfAutoIncs;
                }
                for (DbColumnConstraint cc : c.getColumnConstraints()) {
                    column.add(cc.translate());
                }
                if (c.isDefaultValueSet()) {
                    column.add("DEFAULT");
                    column.add(this.translate(c.getDefaultValue()));
                }
                columns.add(org.apache.commons.lang3.StringUtils.join(column, (String)" "));
            }
            if (numberOfAutoIncs > 1) {
                throw new DatabaseEngineException("In MySQL you can only define one auto increment column");
            }
            String pks = "";
            if (numberOfAutoIncs == 1) {
                pks = entity.getPkFields().size() == 0 ? ", PRIMARY KEY(" + autoIncName + ")" : ", PRIMARY KEY(" + org.apache.commons.lang3.StringUtils.join(entity.getPkFields(), (String)", ") + ")";
            }
            createTable.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + pks + ")");
            String createTableStatement = org.apache.commons.lang3.StringUtils.join(createTable, (String)" ");
            this.logger.trace(createTableStatement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(createTableStatement);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 1050) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.TABLE_ALREADY_EXISTS), ex);
                    break block19;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addPrimaryKey(DbEntity entity) throws DatabaseEngineException {
        block16: {
            if (entity.getPkFields().size() == 0) {
                return;
            }
            for (DbColumn dbColumn : entity.getColumns()) {
                if (!dbColumn.isAutoInc()) continue;
                this.logger.debug(dev, "There's already a primary key since you set '{}' to AUTO INCREMENT", (Object)dbColumn.getName());
                return;
            }
            ArrayList<String> pks = new ArrayList<String>();
            for (String pk : entity.getPkFields()) {
                pks.add(StringUtils.quotize(pk, this.escapeCharacter()));
            }
            String string = StringUtils.md5(String.format("PK_%s", entity.getName()), this.properties.getMaxIdentifierSize());
            ArrayList<String> statement = new ArrayList<String>();
            statement.add("ALTER TABLE");
            statement.add(StringUtils.quotize(entity.getName(), this.escapeCharacter()));
            statement.add("ADD CONSTRAINT");
            statement.add(StringUtils.quotize(string, this.escapeCharacter()));
            statement.add("PRIMARY KEY");
            statement.add("(" + org.apache.commons.lang3.StringUtils.join(pks, (String)", ") + ")");
            String addPrimaryKey = org.apache.commons.lang3.StringUtils.join(statement, (String)" ");
            this.logger.trace(addPrimaryKey);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(addPrimaryKey);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 1068) {
                    this.logger.debug(dev, "'{}' already has a primary key", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.PRIMARY_KEY_ALREADY_EXISTS), ex);
                    break block16;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addIndexes(DbEntity entity) throws DatabaseEngineException {
        if (entity.getIndexes().isEmpty()) {
            return;
        }
        List<DbIndex> indexes = entity.getIndexes();
        for (DbIndex index : indexes) {
            ArrayList<String> createIndex = new ArrayList<String>();
            createIndex.add("CREATE");
            if (index.isUnique()) {
                createIndex.add("UNIQUE");
            }
            createIndex.add("INDEX");
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<String> columnsForName = new ArrayList<String>();
            for (String column : index.getColumns()) {
                columns.add(StringUtils.quotize(column, this.escapeCharacter()));
                columnsForName.add(column);
            }
            String idxName = StringUtils.md5(String.format("%s_%s_IDX", entity.getName(), org.apache.commons.lang3.StringUtils.join(columnsForName, (String)"_")), this.properties.getMaxIdentifierSize());
            createIndex.add(StringUtils.quotize(idxName, this.escapeCharacter()));
            createIndex.add("ON");
            createIndex.add(StringUtils.quotize(entity.getName(), this.escapeCharacter()));
            createIndex.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
            String statement = org.apache.commons.lang3.StringUtils.join(createIndex, (String)" ");
            this.logger.trace(statement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(statement);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 1061) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)idxName);
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.INDEX_ALREADY_EXISTS), ex);
                    continue;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s == null) continue;
                    s.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void addSequences(DbEntity entity) throws DatabaseEngineException {
    }

    @Override
    protected MappedEntity createPreparedStatementForInserts(DbEntity entity) throws DatabaseEngineException {
        ArrayList<String> insertInto = new ArrayList<String>();
        insertInto.add("INSERT INTO");
        insertInto.add(StringUtils.quotize(entity.getName(), this.escapeCharacter()));
        ArrayList<String> insertIntoWithAutoInc = new ArrayList<String>();
        insertIntoWithAutoInc.add("INSERT INTO");
        insertIntoWithAutoInc.add(StringUtils.quotize(entity.getName(), this.escapeCharacter()));
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> columnsWithAutoInc = new ArrayList<String>();
        ArrayList<String> valuesWithAutoInc = new ArrayList<String>();
        for (DbColumn column : entity.getColumns()) {
            columnsWithAutoInc.add(StringUtils.quotize(column.getName(), this.escapeCharacter()));
            valuesWithAutoInc.add("?");
            if (column.isAutoInc()) continue;
            columns.add(StringUtils.quotize(column.getName(), this.escapeCharacter()));
            values.add("?");
        }
        insertInto.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
        insertInto.add("VALUES (" + org.apache.commons.lang3.StringUtils.join(values, (String)", ") + ")");
        insertIntoWithAutoInc.add("(" + org.apache.commons.lang3.StringUtils.join(columnsWithAutoInc, (String)", ") + ")");
        insertIntoWithAutoInc.add("VALUES (" + org.apache.commons.lang3.StringUtils.join(valuesWithAutoInc, (String)", ") + ")");
        String statement = org.apache.commons.lang3.StringUtils.join(insertInto, (String)" ");
        String insertReturnStatement = "";
        String statementWithAutoInt = org.apache.commons.lang3.StringUtils.join(insertIntoWithAutoInc, (String)" ");
        this.logger.trace(statement);
        this.logger.trace(statementWithAutoInt);
        try {
            PreparedStatement ps = this.conn.prepareStatement(statement, 1);
            PreparedStatement psReturn = this.conn.prepareStatement("");
            PreparedStatement psWithAutoInc = this.conn.prepareStatement(statementWithAutoInt);
            return new MappedEntity().setInsert(ps).setInsertReturning(psReturn).setInsertWithAutoInc(psWithAutoInc);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
    }

    @Override
    protected void dropSequences(DbEntity entity) throws DatabaseEngineException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropTable(DbEntity entity) throws DatabaseEngineException {
        block13: {
            this.dropReferringFks(entity);
            Statement drop = null;
            try {
                drop = this.conn.createStatement();
                String query = String.format("DROP TABLE %s", StringUtils.quotize(entity.getName(), this.escapeCharacter()));
                this.logger.trace(query);
                drop.executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 1051) {
                    this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.TABLE_DOES_NOT_EXIST), ex);
                    break block13;
                }
                throw new DatabaseEngineException("Error dropping table", ex);
            }
            finally {
                try {
                    if (drop != null) {
                        drop.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropColumn(DbEntity entity, String ... columns) throws DatabaseEngineException {
        block14: {
            Statement drop = null;
            ArrayList<String> removeColumns = new ArrayList<String>();
            removeColumns.add("ALTER TABLE");
            removeColumns.add(StringUtils.quotize(entity.getName(), this.escapeCharacter()));
            ArrayList<String> cols = new ArrayList<String>();
            for (String col : columns) {
                cols.add("DROP COLUMN " + StringUtils.quotize(col, this.escapeCharacter()));
            }
            removeColumns.add(org.apache.commons.lang3.StringUtils.join(cols, (String)","));
            try {
                drop = this.conn.createStatement();
                String query = org.apache.commons.lang3.StringUtils.join(removeColumns, (String)" ");
                this.logger.trace(query);
                drop.executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 1051) {
                    this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.COLUMN_DOES_NOT_EXIST), ex);
                    break block14;
                }
                throw new DatabaseEngineException("Error dropping column", ex);
            }
            finally {
                try {
                    if (drop != null) {
                        drop.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void addColumn(DbEntity entity, DbColumn ... columns) throws DatabaseEngineException {
        ArrayList<String> addColumns = new ArrayList<String>();
        addColumns.add("ALTER TABLE");
        addColumns.add(StringUtils.quotize(entity.getName(), this.escapeCharacter()));
        ArrayList<String> cols = new ArrayList<String>();
        for (DbColumn c : columns) {
            ArrayList<String> column = new ArrayList<String>();
            column.add("ADD COLUMN");
            column.add(StringUtils.quotize(c.getName(), this.escapeCharacter()));
            column.add(this.translateType(c));
            for (DbColumnConstraint cc : c.getColumnConstraints()) {
                column.add(cc.translate());
            }
            if (c.isDefaultValueSet()) {
                column.add("DEFAULT");
                column.add(this.translate(c.getDefaultValue()));
            }
            cols.add(org.apache.commons.lang3.StringUtils.join(column, (String)" "));
        }
        addColumns.add(org.apache.commons.lang3.StringUtils.join(cols, (String)","));
        String addColumnsStatement = org.apache.commons.lang3.StringUtils.join(addColumns, (String)" ");
        this.logger.trace(addColumnsStatement);
        Statement s = null;
        try {
            s = this.conn.createStatement();
            s.executeUpdate(addColumnsStatement);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    @Override
    public Class<? extends AbstractTranslator> getTranslatorClass() {
        return MySqlTranslator.class;
    }

    @Override
    protected PreparedStatement getPreparedStatementForPersist(boolean useAutoInc, MappedEntity mappedEntity) {
        return useAutoInc ? mappedEntity.getInsert() : mappedEntity.getInsertWithAutoInc();
    }

    @Override
    protected synchronized long doPersist(PreparedStatement ps, MappedEntity me, boolean useAutoInc, int lastBindPosition) throws Exception {
        ps.execute();
        if (useAutoInc) {
            try (ResultSet generatedKeys = ps.getGeneratedKeys();){
                if (generatedKeys.next()) {
                    long l = generatedKeys.getLong(1);
                    return l;
                }
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addFks(DbEntity entity) throws DatabaseEngineException {
        for (DbFk fk : entity.getFks()) {
            ArrayList<String> quotizedLocalColumns = new ArrayList<String>();
            for (String string : fk.getLocalColumns()) {
                quotizedLocalColumns.add(StringUtils.quotize(string, this.escapeCharacter()));
            }
            ArrayList<String> quotizedForeignColumns = new ArrayList<String>();
            for (String s3 : fk.getForeignColumns()) {
                quotizedForeignColumns.add(StringUtils.quotize(s3, this.escapeCharacter()));
            }
            String string = StringUtils.quotize(entity.getName(), this.escapeCharacter());
            String quotizedLocalColumnsSting = org.apache.commons.lang3.StringUtils.join(quotizedLocalColumns, (String)", ");
            String quotizedForeignColumnsString = org.apache.commons.lang3.StringUtils.join(quotizedForeignColumns, (String)", ");
            String alterTable = String.format("ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s (%s)", string, StringUtils.quotize(StringUtils.md5("FK_" + string + quotizedLocalColumnsSting + quotizedForeignColumnsString, this.properties.getMaxIdentifierSize()), this.escapeCharacter()), quotizedLocalColumnsSting, StringUtils.quotize(fk.getForeignTable(), this.escapeCharacter()), quotizedForeignColumnsString);
            Statement alterTableStmt = null;
            try {
                alterTableStmt = this.conn.createStatement();
                this.logger.trace(alterTable);
                alterTableStmt.executeUpdate(alterTable);
                alterTableStmt.close();
            }
            catch (SQLException ex) {
                if (CONSTRAINT_NAME_ALREADY_EXISTS.contains(ex.getErrorCode())) {
                    this.logger.debug(dev, "Foreign key for table '{}' already exists. Error code: {}.", (Object)entity.getName(), (Object)ex.getErrorCode());
                    continue;
                }
                throw new DatabaseEngineException(String.format("Could not add Foreign Key to entity %s. Error code: %d.", entity.getName(), ex.getErrorCode()), ex);
            }
            finally {
                try {
                    if (alterTableStmt == null) continue;
                    alterTableStmt.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void dropFks(String table) throws DatabaseEngineException {
        ResultSet rs = null;
        try {
            this.getConnection();
            rs = this.conn.getMetaData().getImportedKeys(null, this.currentSchema, table);
            HashSet<String> fks = new HashSet<String>();
            while (rs.next()) {
                fks.add(rs.getString("FK_NAME"));
            }
            for (String fk : fks) {
                try {
                    this.executeUpdate(String.format("ALTER TABLE %s DROP FOREIGN KEY %s", StringUtils.quotize(table, this.escapeCharacter()), StringUtils.quotize(fk, this.escapeCharacter())));
                }
                catch (Exception e) {
                    this.logger.warn("Could not drop foreign key '{}' on table '{}'", (Object)fk, (Object)table);
                    this.logger.debug("Could not drop foreign key.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new DatabaseEngineException("Error dropping foreign key", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception a) {
                this.logger.trace("Error closing result set.", (Throwable)a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void dropReferringFks(DbEntity entity) throws DatabaseEngineException {
        block39: {
            try (Statement s = this.conn.createStatement();){
                String sString = String.format("SELECT TABLE_NAME, CONSTRAINT_NAME FROM information_schema.KEY_COLUMN_USAGE WHERE REFERENCED_TABLE_NAME = '%s'", entity.getName());
                this.logger.trace(sString);
                s.executeQuery(sString);
                ResultSet dependentTables = s.getResultSet();
                Throwable throwable = null;
                block31: while (true) {
                    try {
                        while (dependentTables.next()) {
                            Statement dropFk = null;
                            String tableName = dependentTables.getString(1);
                            String constraintName = dependentTables.getString(2);
                            dropFk = this.conn.createStatement();
                            String dropFkString = String.format("ALTER TABLE %s DROP FOREIGN KEY %s", StringUtils.quotize(tableName, this.escapeCharacter()), StringUtils.quotize(constraintName, this.escapeCharacter()));
                            this.logger.trace(dropFkString);
                            dropFk.executeUpdate(dropFkString);
                            if (dropFk == null) continue;
                            try {
                                dropFk.close();
                                continue block31;
                            }
                            catch (Exception e) {
                                this.logger.trace("Error closing statement.", (Throwable)e);
                                continue;
                            }
                            catch (SQLException ex) {
                                this.logger.debug(String.format("Unable to drop constraint '%s' in table '%s'", constraintName, tableName), (Throwable)ex);
                                continue block31;
                            }
                            finally {
                                if (dropFk == null) continue;
                                try {
                                    dropFk.close();
                                    continue block31;
                                }
                                catch (Exception e) {
                                    this.logger.trace("Error closing statement.", (Throwable)e);
                                }
                            }
                        }
                        break block39;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (dependentTables != null) {
                        if (throwable != null) {
                            try {
                                dependentTables.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            dependentTables.close();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                throw new DatabaseEngineException(String.format("Unable to drop foreign keys of the tables that depend on '%s'", entity.getName()), ex);
            }
        }
    }

    @Override
    public synchronized Map<String, DbEntityType> getEntities(String schemaPattern) throws DatabaseEngineException {
        LinkedHashMap<Object, DbEntityType> entities = new LinkedHashMap<Object, DbEntityType>();
        ResultSet rs = null;
        try {
            Object entityName;
            this.getConnection();
            rs = this.conn.getMetaData().getTables(schemaPattern, null, "%", null);
            while (rs.next()) {
                entityName = rs.getString("table_name");
                String entityType = rs.getString("table_type");
                DbEntityType type = "TABLE".equals(entityType) ? DbEntityType.TABLE : ("VIEW".equals(entityType) ? DbEntityType.VIEW : ("SYSTEM TABLE".equals(entityType) ? DbEntityType.SYSTEM_TABLE : ("SYSTEM VIEW".equals(entityType) ? DbEntityType.SYSTEM_VIEW : DbEntityType.UNMAPPED)));
                entities.put(entityName, type);
            }
            entityName = entities;
            return entityName;
        }
        catch (Exception e) {
            throw new DatabaseEngineException("Could not get entities", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception a) {
                this.logger.trace("Error closing result set.", (Throwable)a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean checkConnection(Connection conn) {
        Statement s = null;
        try {
            s = conn.createStatement();
            s.executeQuery("select 1");
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.logger.debug("Connection is down.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    @Override
    protected String getSchema() throws DatabaseEngineException {
        try {
            return this.conn.getCatalog();
        }
        catch (Exception e) {
            throw new DatabaseEngineException("Could not get current schema", e);
        }
    }

    @Override
    protected void setSchema(String schema) throws DatabaseEngineException {
        boolean isSchemaSet;
        try {
            this.conn.setCatalog(schema);
            isSchemaSet = this.conn.getCatalog() != null;
        }
        catch (Exception e) {
            throw new DatabaseEngineException(String.format("Could not set current schema to '%s'", schema), e);
        }
        if (!isSchemaSet) {
            throw new DatabaseEngineException(String.format("Schema '%s' doesn't exist", schema));
        }
    }

    @Override
    public synchronized Map<String, DbColumnType> getMetadata(String schemaPattern, String tableNamePattern) throws DatabaseEngineException {
        LinkedHashMap<String, DbColumnType> metaMap = new LinkedHashMap<String, DbColumnType>();
        ResultSet rsColumns = null;
        try {
            this.getConnection();
            DatabaseMetaData meta = this.conn.getMetaData();
            rsColumns = meta.getColumns(schemaPattern, null, tableNamePattern, null);
            while (rsColumns.next()) {
                metaMap.put(rsColumns.getString("COLUMN_NAME"), this.toPdbType(rsColumns.getInt("DATA_TYPE"), rsColumns.getString("TYPE_NAME")));
            }
            LinkedHashMap<String, DbColumnType> linkedHashMap = metaMap;
            return linkedHashMap;
        }
        catch (Exception e) {
            throw new DatabaseEngineException("Could not get metadata", e);
        }
        finally {
            try {
                if (rsColumns != null) {
                    rsColumns.close();
                }
            }
            catch (Exception a) {
                this.logger.trace("Error closing result set.", (Throwable)a);
            }
        }
    }

    @Override
    public boolean isStringAggDistinctCapable() {
        return true;
    }

    @Override
    public String commentCharacter() {
        return "#";
    }

    @Override
    public String escapeCharacter() {
        return this.translator.translateEscape();
    }

    @Override
    protected ResultIterator createResultIterator(Statement statement, String sql) throws DatabaseEngineException {
        return new MySqlResultIterator(statement, sql);
    }

    @Override
    protected ResultIterator createResultIterator(PreparedStatement ps) throws DatabaseEngineException {
        return new MySqlResultIterator(ps);
    }

    @Override
    protected QueryExceptionHandler getQueryExceptionHandler() {
        return MYSQL_QUERY_EXCEPTION_HANDLER;
    }
}

