/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.handler;

import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineTimeoutException;
import com.feedzai.commons.sql.abstraction.exceptions.DatabaseEngineRetryableException;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;

public class QueryExceptionHandler {
    public boolean isTimeoutException(SQLException exception) {
        return exception instanceof SQLTimeoutException;
    }

    public boolean isRetryableException(SQLException exception) {
        return "40001".equals(exception.getSQLState());
    }

    public DatabaseEngineException handleException(Exception exception, String message) throws DatabaseEngineException {
        if (exception instanceof SQLException) {
            SQLException sqlException = (SQLException)exception;
            if (this.isTimeoutException(sqlException)) {
                throw new DatabaseEngineTimeoutException(message + " [timeout]", sqlException);
            }
            if (this.isRetryableException(sqlException)) {
                throw new DatabaseEngineRetryableException(message + " [retryable]", sqlException);
            }
        }
        throw new DatabaseEngineException(message, exception);
    }
}

