/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine;

import java.util.EnumSet;

public enum DatabaseEngineDriver {
    H2("H2", "com.feedzai.commons.sql.abstraction.engine.impl.H2Engine", "org.h2.Driver", 0){

        @Override
        public String connectionStringFor(String hostname, String database) {
            return String.format("jdbc:h2:%s/%s", hostname, database);
        }

        @Override
        public String connectionStringFor(String hostname, String database, int port) {
            return this.connectionStringFor(hostname, database);
        }
    }
    ,
    POSTGRES("Postgres", "com.feedzai.commons.sql.abstraction.engine.impl.PostgreSqlEngine", "org.postgresql.Driver", 5432){

        @Override
        public String connectionStringFor(String hostname, String database, int port) {
            return String.format("jdbc:postgresql://%s:%d/%s", hostname, port, database);
        }
    }
    ,
    COCKROACHDB("CockroachDB", "com.feedzai.commons.sql.abstraction.engine.impl.CockroachDBEngine", "org.postgresql.Driver", 26257){

        @Override
        public String connectionStringFor(String hostname, String database, int port) {
            return String.format("jdbc:postgresql://%s:%d/%s", hostname, port, database);
        }
    }
    ,
    SQLSERVER("SQLServer", "com.feedzai.commons.sql.abstraction.engine.impl.SqlServerEngine", "com.microsoft.sqlserver.jdbc.SQLServerDriver", 1433){

        @Override
        public String connectionStringFor(String hostname, String database, int port) {
            return String.format("jdbc:sqlserver://%s:%d;database=%s", hostname, port, database);
        }
    }
    ,
    ORACLE("Oracle", "com.feedzai.commons.sql.abstraction.engine.impl.OracleEngine", "oracle.jdbc.OracleDriver", 1521){

        @Override
        public String connectionStringFor(String hostname, String database, int port) {
            return String.format("jdbc:oracle:thin:@%s:%d:%s", hostname, port, database);
        }
    }
    ,
    MYSQL("MySQL", "com.feedzai.commons.sql.abstraction.engine.impl.MySqlEngine", "com.mysql.jdbc.Driver", 3306){

        @Override
        public String connectionStringFor(String hostname, String database, int port) {
            return String.format("jdbc:mysql://%s:%d/%s", hostname, port, database);
        }
    }
    ,
    DB2("DB2", "com.feedzai.commons.sql.abstraction.engine.impl.DB2Engine", "com.ibm.db2.jcc.DB2Driver", 50000){

        @Override
        public String connectionStringFor(String hostname, String database, int port) {
            return String.format("jdbc:db2://%s:%d/%s", hostname, port, database);
        }
    };

    private String name;
    private String engineClass;
    private String driverClass;
    private int port;

    private DatabaseEngineDriver(String name, String engine, String driver, int port) {
        this.name = name;
        this.engineClass = engine;
        this.driverClass = driver;
        this.port = port;
    }

    public static DatabaseEngineDriver fromEngine(String engine) {
        for (DatabaseEngineDriver element : EnumSet.allOf(DatabaseEngineDriver.class)) {
            if (!element.engineClass.equals(engine)) continue;
            return element;
        }
        return null;
    }

    public static DatabaseEngineDriver fromDriver(String driverClass) {
        for (DatabaseEngineDriver element : EnumSet.allOf(DatabaseEngineDriver.class)) {
            if (!element.driverClass.equals(driverClass)) continue;
            return element;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public String engine() {
        return this.engineClass;
    }

    public String driver() {
        return this.driverClass;
    }

    public int defaultPort() throws UnsupportedOperationException {
        if (H2.equals((Object)this)) {
            throw new UnsupportedOperationException("Cannot get a default port for H2 since there's no default port assigned by IANA.");
        }
        return this.port;
    }

    public String connectionStringFor(String hostname, String database) {
        return this.connectionStringFor(hostname, database, this.defaultPort());
    }

    public abstract String connectionStringFor(String var1, String var2, int var3);
}

