/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.ddl;

import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnType;
import com.feedzai.commons.sql.abstraction.ddl.DbFk;
import com.feedzai.commons.sql.abstraction.ddl.DbIndex;
import com.feedzai.commons.sql.abstraction.dml.K;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DbEntity
implements Serializable {
    private final String name;
    private final List<DbColumn> columns;
    private final List<DbFk> fks;
    private final List<String> pkFields;
    private final List<DbIndex> indexes;

    protected DbEntity(String name, List<DbColumn> columns, List<DbFk> fks, List<String> pkFields, List<DbIndex> indexes) {
        this.name = name;
        this.columns = columns;
        this.fks = fks;
        this.pkFields = pkFields;
        this.indexes = indexes;
    }

    public String getName() {
        return this.name;
    }

    public List<DbColumn> getColumns() {
        return this.columns;
    }

    public List<DbFk> getFks() {
        return this.fks;
    }

    public List<String> getPkFields() {
        return this.pkFields;
    }

    public List<DbIndex> getIndexes() {
        return this.indexes;
    }

    public boolean containsColumn(String columnName) {
        return this.columns.stream().map(DbColumn::getName).anyMatch(listColName -> listColName.equals(columnName));
    }

    public Builder newBuilder() {
        return new Builder().name(this.name).addColumn(this.columns).addFk(this.fks).pkFields(this.pkFields).addIndexes(this.indexes);
    }

    public static class Builder
    implements com.feedzai.commons.sql.abstraction.util.Builder<DbEntity>,
    Serializable {
        protected String name;
        protected final List<DbColumn> columns = new ArrayList<DbColumn>();
        protected final List<DbFk> fks = new ArrayList<DbFk>();
        protected final List<String> pkFields = new ArrayList<String>();
        protected final List<DbIndex> indexes = new ArrayList<DbIndex>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addColumn(DbColumn dbColumn) {
            this.columns.add(dbColumn);
            return this;
        }

        public Builder removeColumn(String name) {
            Iterator<DbColumn> iterator = this.columns.iterator();
            while (iterator.hasNext()) {
                DbColumn next = iterator.next();
                if (!next.getName().equals(name)) continue;
                iterator.remove();
                return this;
            }
            return this;
        }

        public Builder addColumn(Collection<DbColumn> dbColumn) {
            this.columns.addAll(dbColumn);
            return this;
        }

        public Builder addColumn(String name, DbColumnType type, DbColumnConstraint ... constraints) {
            this.addColumn(new DbColumn.Builder().name(name).addConstraints(constraints).type(type).build());
            return this;
        }

        public Builder addColumn(String name, DbColumnType type, Integer size, DbColumnConstraint ... constraints) {
            this.addColumn(new DbColumn.Builder().name(name).addConstraints(constraints).type(type).size(size).build());
            return this;
        }

        public Builder addColumn(String name, DbColumnType type, boolean autoInc, DbColumnConstraint ... constraints) {
            this.addColumn(new DbColumn.Builder().name(name).addConstraints(constraints).type(type).autoInc(autoInc).build());
            return this;
        }

        public Builder addColumn(String name, DbColumnType type, K defaultValue, DbColumnConstraint ... constraints) {
            this.addColumn(new DbColumn.Builder().name(name).addConstraints(constraints).type(type).defaultValue(defaultValue).build());
            return this;
        }

        public Builder addColumn(String name, DbColumnType type, Integer size, boolean autoInc, DbColumnConstraint ... constraints) {
            this.addColumn(new DbColumn.Builder().name(name).addConstraints(constraints).type(type).autoInc(autoInc).size(size).build());
            return this;
        }

        public Builder pkFields(String ... pkFields) {
            return this.pkFields(Arrays.asList(pkFields));
        }

        public Builder pkFields(Collection<String> pkFields) {
            this.pkFields.addAll(pkFields);
            return this;
        }

        public Builder addIndex(DbIndex index) {
            this.indexes.add(index);
            return this;
        }

        public Builder addIndexes(Collection<DbIndex> indexes) {
            this.indexes.addAll(indexes);
            return this;
        }

        public Builder addIndex(boolean unique, String ... columns) {
            return this.addIndex(new DbIndex.Builder().columns(columns).unique(unique).build());
        }

        public Builder addIndex(String ... columns) {
            return this.addIndex(false, columns);
        }

        public Builder addIndex(Collection<String> columns) {
            this.addIndex(new DbIndex.Builder().columns(columns).build());
            return this;
        }

        public Builder addFk(DbFk ... fks) {
            return this.addFk(Arrays.asList(fks));
        }

        public Builder addFk(DbFk.Builder ... fks) {
            for (DbFk.Builder fk : fks) {
                this.addFk(fk.build());
            }
            return this;
        }

        public Builder addFk(Collection<DbFk> fks) {
            this.fks.addAll(fks);
            return this;
        }

        public Builder clearFks() {
            this.fks.clear();
            return this;
        }

        public Builder addFks(Collection<DbFk> fks) {
            this.fks.addAll(fks);
            return this;
        }

        @Override
        public DbEntity build() {
            return new DbEntity(this.name, (List<DbColumn>)ImmutableList.copyOf(this.columns), (List<DbFk>)ImmutableList.copyOf(this.fks), (List<String>)ImmutableList.copyOf(this.pkFields), (List<DbIndex>)ImmutableList.copyOf(this.indexes));
        }
    }
}

