/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.configuration;

import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineRuntimeException;
import com.feedzai.commons.sql.abstraction.engine.configuration.IsolationLevel;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbConfigurationException;
import com.feedzai.commons.sql.abstraction.util.Cloneable;
import com.feedzai.commons.sql.abstraction.util.Constants;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class PdbProperties
extends Properties
implements Cloneable<PdbProperties> {
    private static final long serialVersionUID = -4948574874005506022L;
    public static final String JDBC = "pdb.jdbc";
    public static final String USERNAME = "pdb.username";
    public static final String PASSWORD = "pdb.password";
    public static final String VARCHAR_SIZE = "pdb.varchar_size";
    public static final String SCHEMA_POLICY = "pdb.schema_policy";
    public static final String ENGINE = "pdb.engine";
    public static final String TRANSLATOR = "pdb.translator";
    public static final String SCHEMA = "pdb.schema";
    public static final String MAX_IDENTIFIER_SIZE = "pdb.max_identifier_size";
    public static final String MAX_BLOB_SIZE = "pdb.max_blob_size";
    public static final String BLOB_BUFFER_SIZE = "pdb.blob_buffer_size";
    public static final String MAX_NUMBER_OF_RETRIES = "pdb.max_number_retries";
    public static final String RETRY_INTERVAL = "pdb.retry_interval";
    public static final String ISOLATION_LEVEL = "pdb.isolation_level";
    public static final String DRIVER = "pdb.driver";
    public static final String RECONNECT_ON_LOST = "pdb.reconnect_on_lost";
    public static final String ENCRYPTED_PASSWORD = "pdb.encrypted_password";
    public static final String SECRET_LOCATION = "pdb.secret_location";
    public static final String ENCRYPTED_USERNAME = "pdb.encrypted_username";
    public static final String ALLOW_COLUMN_DROP = "pdb.allow_column_drop";
    public static final String FETCH_SIZE = "pdb.fetch_size";
    public static final String MAXIMUM_TIME_BATCH_SHUTDOWN = "pdb.maximum_await_time_batch";
    public static final String COMPRESS_LOBS = "pdb.compress_lobs";
    public static final String DISABLE_LOB_CACHING = "pdb.disable_lob_caching";

    public PdbProperties() {
        this(false);
    }

    public PdbProperties(boolean useDefaults) {
        if (useDefaults) {
            this.setProperty(VARCHAR_SIZE, 256);
            this.setProperty(SCHEMA_POLICY, "create");
            this.setProperty(MAX_IDENTIFIER_SIZE, 30);
            this.setProperty(MAX_BLOB_SIZE, -1);
            this.setProperty(BLOB_BUFFER_SIZE, 0x100000);
            this.setProperty(MAX_NUMBER_OF_RETRIES, -1);
            this.setProperty(RETRY_INTERVAL, Constants.DEFAULT_RETRY_INTERVAL);
            this.setProperty(ISOLATION_LEVEL, (Object)Constants.DEFAULT_ISOLATION_LEVEL);
            this.setProperty(RECONNECT_ON_LOST, true);
            this.setProperty(SECRET_LOCATION, "secret.key");
            this.setProperty(ALLOW_COLUMN_DROP, true);
            this.setProperty(FETCH_SIZE, 1000);
            this.setProperty(MAXIMUM_TIME_BATCH_SHUTDOWN, Constants.DEFAULT_MAXIMUM_TIME_BATCH_SHUTDOWN);
            this.setProperty(COMPRESS_LOBS, false);
            this.setProperty(DISABLE_LOB_CACHING, false);
        }
    }

    public void setProperty(String key, Object o) {
        this.setProperty(key, o.toString());
    }

    public PdbProperties(Properties properties, boolean useDefaults) {
        this(useDefaults);
        this.merge(properties);
    }

    public final void merge(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    public boolean isTranslatorSet() {
        return !StringUtils.isBlank((CharSequence)this.getTranslator());
    }

    public boolean isEncryptedUsername() {
        return !StringUtils.isBlank((CharSequence)this.getProperty(ENCRYPTED_USERNAME));
    }

    public boolean isEncryptedPassword() {
        return !StringUtils.isBlank((CharSequence)this.getProperty(ENCRYPTED_PASSWORD));
    }

    public int getFetchSize() {
        return Integer.parseInt(this.getProperty(FETCH_SIZE));
    }

    public long getMaximumAwaitTimeBatchShutdown() {
        return Long.parseLong(this.getProperty(MAXIMUM_TIME_BATCH_SHUTDOWN));
    }

    public boolean isSchemaPolicyCreateDrop() {
        return "create-drop".equals(this.getProperty(SCHEMA_POLICY));
    }

    public boolean isSchemaPolicyDropCreate() {
        return "drop-create".equals(this.getProperty(SCHEMA_POLICY));
    }

    public boolean isSchemaPolicyCreate() {
        return "create".equals(this.getProperty(SCHEMA_POLICY));
    }

    public boolean isSchemaPolicyNone() {
        return "none".equals(this.getProperty(SCHEMA_POLICY));
    }

    public int getMaxIdentifierSize() {
        return Integer.parseInt(this.getProperty(MAX_IDENTIFIER_SIZE));
    }

    public int getMaxBlobSize() {
        return Integer.parseInt(this.getProperty(MAX_BLOB_SIZE));
    }

    public boolean isMaxBlobSizeSet() {
        return this.getMaxBlobSize() != -1;
    }

    public int getBlobBufferSize() {
        return Integer.parseInt(this.getProperty(BLOB_BUFFER_SIZE));
    }

    public int getMaxRetries() {
        return Integer.parseInt(this.getProperty(MAX_NUMBER_OF_RETRIES));
    }

    public long getRetryInterval() {
        return Long.parseLong(this.getProperty(RETRY_INTERVAL));
    }

    public boolean isReconnectOnLost() {
        return Boolean.parseBoolean(this.getProperty(RECONNECT_ON_LOST));
    }

    public boolean shouldCompressLobs() {
        return Boolean.parseBoolean(this.getProperty(COMPRESS_LOBS));
    }

    public boolean isLobCachingDisabled() {
        return Boolean.parseBoolean(this.getProperty(DISABLE_LOB_CACHING));
    }

    public int getIsolationLevel() {
        Optional e = Enums.getIfPresent(IsolationLevel.class, (String)this.getProperty(ISOLATION_LEVEL).toUpperCase());
        if (!e.isPresent()) {
            throw new DatabaseEngineRuntimeException("pdb.isolation_level must be set and be one of the following: " + EnumSet.allOf(IsolationLevel.class));
        }
        switch ((IsolationLevel)((Object)e.get())) {
            case READ_UNCOMMITTED: {
                return 1;
            }
            case READ_COMMITTED: {
                return 2;
            }
            case REPEATABLE_READ: {
                return 4;
            }
            case SERIALIZABLE: {
                return 8;
            }
        }
        throw new DatabaseEngineRuntimeException("New isolation level?!" + e.get());
    }

    public String getJdbc() {
        return this.getProperty(JDBC);
    }

    public String getUsername() {
        return this.getProperty(USERNAME);
    }

    public String getPassword() {
        return this.getProperty(PASSWORD);
    }

    public String getEngine() {
        return this.getProperty(ENGINE);
    }

    public String getTranslator() {
        return this.getProperty(TRANSLATOR);
    }

    public String getSchema() {
        return this.getProperty(SCHEMA);
    }

    public boolean isDriverSet() {
        return this.getProperty(DRIVER) != null;
    }

    public boolean isSchemaSet() {
        return StringUtils.isNotBlank((CharSequence)this.getSchema());
    }

    public boolean allowColumnDrop() {
        return Boolean.parseBoolean(this.getProperty(ALLOW_COLUMN_DROP));
    }

    public void checkMandatoryProperties() throws PdbConfigurationException {
        StringBuilder exceptionMessage = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)this.getJdbc())) {
            exceptionMessage.append("- A connection string should be declared under the 'database.jdbc' property.\n");
        }
        if (StringUtils.isBlank((CharSequence)this.getEngine())) {
            exceptionMessage.append("- An engine string should be declared under the 'database.engine' property.\n");
        }
        if (exceptionMessage.length() > 0) {
            throw new PdbConfigurationException("The following configuration errors were detected in the configuration file: \n" + exceptionMessage.toString());
        }
    }

    @Override
    public PdbProperties clone() {
        return new PdbProperties(this, false);
    }

    public String getDriver() {
        return this.getProperty(DRIVER);
    }
}

