/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine;

import com.feedzai.commons.sql.abstraction.FailureListener;
import com.feedzai.commons.sql.abstraction.batch.AbstractBatch;
import com.feedzai.commons.sql.abstraction.batch.DefaultBatch;
import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnType;
import com.feedzai.commons.sql.abstraction.ddl.DbEntity;
import com.feedzai.commons.sql.abstraction.ddl.DbEntityType;
import com.feedzai.commons.sql.abstraction.ddl.DbFk;
import com.feedzai.commons.sql.abstraction.ddl.DbIndex;
import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.dml.dialect.Dialect;
import com.feedzai.commons.sql.abstraction.dml.result.ResultColumn;
import com.feedzai.commons.sql.abstraction.dml.result.ResultIterator;
import com.feedzai.commons.sql.abstraction.engine.AbstractTranslator;
import com.feedzai.commons.sql.abstraction.engine.ConnectionResetException;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineRuntimeException;
import com.feedzai.commons.sql.abstraction.engine.DatabaseFactory;
import com.feedzai.commons.sql.abstraction.engine.DuplicateEngineException;
import com.feedzai.commons.sql.abstraction.engine.MappedEntity;
import com.feedzai.commons.sql.abstraction.engine.NameAlreadyExistsException;
import com.feedzai.commons.sql.abstraction.engine.RecoveryException;
import com.feedzai.commons.sql.abstraction.engine.RetryLimitExceededException;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.engine.handler.ExceptionHandler;
import com.feedzai.commons.sql.abstraction.engine.handler.OperationFault;
import com.feedzai.commons.sql.abstraction.entry.EntityEntry;
import com.feedzai.commons.sql.abstraction.util.AESHelper;
import com.feedzai.commons.sql.abstraction.util.InitiallyReusableByteArrayOutputStream;
import com.feedzai.commons.sql.abstraction.util.PreparedStatementCapsule;
import com.feedzai.commons.sql.abstraction.util.StringUtils;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public abstract class AbstractDatabaseEngine
implements DatabaseEngine {
    @Inject
    protected Injector injector;
    @Inject
    protected AbstractTranslator translator;
    private static final int DEFAULT_FETCH_SIZE = 1000;
    protected Connection conn;
    protected static final Marker dev = MarkerFactory.getMarker((String)"DEV");
    private final int maximumNumberOfTries;
    private final long retryInterval;
    protected final Logger logger;
    protected final Logger notificationLogger;
    protected final Map<String, MappedEntity> entities = new HashMap<String, MappedEntity>();
    protected final Map<String, PreparedStatementCapsule> stmts = new HashMap<String, PreparedStatementCapsule>();
    protected String currentSchema;
    protected final PdbProperties properties;
    protected final Dialect dialect;
    private byte[] reusableByteBuffer;
    protected ExceptionHandler eh = ExceptionHandler.DEFAULT;

    public AbstractDatabaseEngine(String driver, PdbProperties properties, Dialect dialect) throws DatabaseEngineException {
        this.properties = properties;
        if (properties.isDriverSet()) {
            driver = properties.getDriver();
        }
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.notificationLogger = LoggerFactory.getLogger((String)"admin-notifications");
        this.dialect = dialect;
        String jdbc = this.properties.getJdbc();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)jdbc)) {
            throw new DatabaseEngineException(String.format("%s property is mandatory", "pdb.jdbc"));
        }
        this.maximumNumberOfTries = this.properties.getMaxRetries();
        this.retryInterval = this.properties.getRetryInterval();
        try {
            Class.forName(driver);
            this.connect();
        }
        catch (ClassNotFoundException ex) {
            throw new DatabaseEngineException("Driver not found", ex);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Unable to connect to database", ex);
        }
        catch (DatabaseEngineException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DatabaseEngineException("An unknown error occurred while establishing a connection to the database.", ex);
        }
    }

    protected String getPrivateKey() throws Exception {
        String location = this.properties.getProperty("pdb.secret_location");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)location)) {
            throw new DatabaseEngineException("Encryption was specified but there's no location specified for the private key.");
        }
        File f = new File(location);
        if (!f.canRead()) {
            throw new DatabaseEngineException("Specified file '" + location + "' does not exist or the application does not have read permissions over it.");
        }
        return StringUtils.readString(new FileInputStream(f)).trim();
    }

    protected void connect() throws Exception {
        String username = this.properties.getUsername();
        String password = this.properties.getPassword();
        if (this.properties.isEncryptedPassword() || this.properties.isEncryptedUsername()) {
            String privateKey = this.getPrivateKey();
            if (this.properties.isEncryptedUsername()) {
                String decryptedUsername = AESHelper.decrypt(this.properties.getProperty("pdb.encrypted_username"), privateKey);
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)decryptedUsername)) {
                    throw new DatabaseEngineException("The encrypted username could not be decrypted.");
                }
                username = decryptedUsername;
            }
            if (this.properties.isEncryptedPassword()) {
                String decryptedPassword = AESHelper.decrypt(this.properties.getProperty("pdb.encrypted_password"), privateKey);
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)decryptedPassword)) {
                    throw new DatabaseEngineException("The encrypted password could not be decrypted.");
                }
                password = decryptedPassword;
            }
        }
        String jdbc = this.getFinalJdbcConnection(this.properties.getJdbc());
        this.conn = DriverManager.getConnection(jdbc, username, password);
        if (this.properties.isSchemaSet()) {
            this.setSchema(this.properties.getSchema());
        }
        this.currentSchema = Optional.ofNullable(this.getSchema()).orElseThrow(() -> new DatabaseEngineException("Could not get current schema"));
        this.setTransactionIsolation();
        this.logger.debug("Connection successful.");
    }

    protected String getFinalJdbcConnection(String jdbc) {
        return jdbc;
    }

    protected void setTransactionIsolation() throws SQLException {
        this.conn.setTransactionIsolation(this.properties.getIsolationLevel());
    }

    public abstract Class<? extends AbstractTranslator> getTranslatorClass();

    @Override
    public synchronized Connection getConnection() throws RetryLimitExceededException, InterruptedException, RecoveryException {
        if (!this.properties.isReconnectOnLost()) {
            return this.conn;
        }
        int retries = 1;
        if (this.checkConnection(this.conn)) {
            return this.conn;
        }
        this.logger.debug("Connection is down.");
        while (true) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                if (this.maximumNumberOfTries > 0) {
                    if (retries == this.maximumNumberOfTries / 2 || retries == this.maximumNumberOfTries - 1) {
                        this.logger.error("The connection to the database was lost. Remaining retries: {}", (Object)(this.maximumNumberOfTries - retries));
                        this.notificationLogger.error("The connection to the database was lost. Remaining retries: {}", (Object)(this.maximumNumberOfTries - retries));
                    } else {
                        this.logger.debug("Retrying ({}/{}) in {} seconds...", new Object[]{retries, this.maximumNumberOfTries, TimeUnit.MILLISECONDS.toSeconds(this.retryInterval)});
                    }
                } else {
                    this.logger.debug("Retry number {} in {} seconds...", (Object)retries, (Object)TimeUnit.MILLISECONDS.toSeconds(this.retryInterval));
                    if (retries % 10 == 0) {
                        this.notificationLogger.error("The connection to the database was lost. Retry number {} in {}", (Object)retries, (Object)TimeUnit.MILLISECONDS.toSeconds(this.retryInterval));
                    }
                }
                Thread.sleep(this.retryInterval);
                this.connect();
                try {
                    this.recover();
                }
                catch (Exception e) {
                    throw new RecoveryException("Error recovering from lost connection.", e);
                }
                return this.conn;
            }
            catch (InterruptedException ex) {
                this.logger.debug("Thread interrupted.");
                throw new InterruptedException();
            }
            catch (SQLException ex) {
                this.logger.debug("Connection failed.");
                if (this.maximumNumberOfTries > 0 && retries > this.maximumNumberOfTries) {
                    throw new RetryLimitExceededException("Maximum number of retries for a connection exceeded.", ex);
                }
                ++retries;
                continue;
            }
            catch (Exception e) {
                this.logger.error("An unexpected error occurred.", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private synchronized void recover() throws DatabaseEngineException, NameAlreadyExistsException {
        HashMap<String, MappedEntity> niw = new HashMap<String, MappedEntity>(this.entities);
        this.entities.clear();
        for (MappedEntity me : niw.values()) {
            try {
                me.close();
            }
            catch (Exception e) {
                this.logger.trace("Could not close prepared statement.", (Throwable)e);
            }
            this.loadEntity(me.getEntity());
        }
        HashMap<String, PreparedStatementCapsule> niwStmts = new HashMap<String, PreparedStatementCapsule>(this.stmts);
        for (Map.Entry e : niwStmts.entrySet()) {
            this.createPreparedStatement((String)e.getKey(), ((PreparedStatementCapsule)e.getValue()).query, ((PreparedStatementCapsule)e.getValue()).timeout, true);
        }
        this.logger.debug("State recovered.");
    }

    @Override
    public synchronized void close() {
        try {
            for (PreparedStatementCapsule preparedStatement : this.stmts.values()) {
                try {
                    preparedStatement.ps.close();
                }
                catch (SQLException e) {
                    this.logger.warn("Could not close statement.", (Throwable)e);
                }
            }
            this.stmts.clear();
            this.entities.forEach((key, mappedEntity) -> this.closeMappedEntity((MappedEntity)mappedEntity));
            if (this.properties.isSchemaPolicyCreateDrop()) {
                this.dropAllEntities();
            }
            this.conn.close();
            this.logger.debug("Connection to database closed");
        }
        catch (SQLException ex) {
            this.logger.warn("Unable to close connection", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeMappedEntity(MappedEntity mappedEntity) {
        try {
            PreparedStatement insert = mappedEntity.getInsert();
            PreparedStatement insertReturning = mappedEntity.getInsertReturning();
            PreparedStatement insertWithAutoInc = mappedEntity.getInsertWithAutoInc();
            insert.executeBatch();
            if (insertReturning != null) {
                insertReturning.executeBatch();
            }
            if (insertWithAutoInc != null) {
                insertWithAutoInc.executeBatch();
            }
        }
        catch (SQLException e) {
            this.logger.debug(String.format("Failed to flush before closing mapped entity '%s'", mappedEntity.getEntity().getName()), (Throwable)e);
        }
        finally {
            try {
                mappedEntity.close();
            }
            catch (Exception e) {
                this.logger.warn("Could not close insert statements from mapped entity.", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void beginTransaction() throws DatabaseEngineRuntimeException {
        try {
            this.getConnection();
            if (!this.conn.getAutoCommit()) {
                this.logger.debug("There's already one transaction active");
                return;
            }
            this.conn.setAutoCommit(false);
        }
        catch (Exception ex) {
            throw new DatabaseEngineRuntimeException("Error occurred while starting transaction", ex);
        }
    }

    @Override
    public synchronized void addEntity(DbEntity entity) throws DatabaseEngineException {
        this.addEntity(entity, false);
    }

    @Override
    public synchronized void loadEntity(DbEntity entity) throws DatabaseEngineException {
        if (!this.entities.containsKey(entity.getName())) {
            this.validateEntity(entity);
            MappedEntity me = this.createPreparedStatementForInserts(entity).setEntity(entity);
            this.entities.put(entity.getName(), me);
            this.logger.trace("Entity '{}' loaded", (Object)entity.getName());
        }
    }

    private void addEntity(DbEntity entity, boolean recovering) throws DatabaseEngineException {
        if (!recovering) {
            try {
                this.getConnection();
            }
            catch (Exception e) {
                throw new DatabaseEngineException("Could not add entity", e);
            }
            this.validateEntity(entity);
            if (this.entities.containsKey(entity.getName())) {
                throw new DatabaseEngineException(String.format("Entity '%s' is already defined", entity.getName()));
            }
            if (this.properties.isSchemaPolicyDropCreate()) {
                this.dropEntity(entity);
            }
        }
        if (!this.properties.isSchemaPolicyNone()) {
            this.createTable(entity);
            this.addPrimaryKey(entity);
            this.addFks(entity);
            this.addIndexes(entity);
            this.addSequences(entity);
        }
        this.loadEntity(entity);
    }

    @Override
    public synchronized void updateEntity(DbEntity entity) throws DatabaseEngineException {
        if (!this.properties.isSchemaPolicyNone()) {
            Map<String, DbColumnType> tableMetadata = this.getMetadata(entity.getName());
            if (tableMetadata.size() == 0) {
                this.addEntity(entity);
            } else if (this.properties.isSchemaPolicyDropCreate()) {
                this.dropEntity(entity);
                this.addEntity(entity);
            } else {
                this.validateEntity(entity);
                this.dropFks(entity.getName());
                ArrayList<String> toRemove = new ArrayList<String>();
                for (String dbColumn : tableMetadata.keySet()) {
                    if (entity.containsColumn(dbColumn)) continue;
                    toRemove.add(dbColumn);
                }
                if (!toRemove.isEmpty()) {
                    if (this.properties.allowColumnDrop()) {
                        this.dropColumn(entity, toRemove.toArray(new String[toRemove.size()]));
                    } else {
                        this.logger.warn("Need to remove {} columns to update {} entity, but property allowColumnDrop is set to false.", (Object)org.apache.commons.lang3.StringUtils.join(toRemove, (String)","), (Object)entity.getName());
                    }
                }
                ArrayList<DbColumn> columns = new ArrayList<DbColumn>();
                for (DbColumn localColumn : entity.getColumns()) {
                    if (tableMetadata.containsKey(localColumn.getName())) continue;
                    columns.add(localColumn);
                }
                if (!columns.isEmpty()) {
                    this.addColumn(entity, columns.toArray(new DbColumn[columns.size()]));
                }
                this.addFks(entity);
            }
        }
        MappedEntity me = this.createPreparedStatementForInserts(entity);
        me = me.setEntity(entity);
        this.entities.put(entity.getName(), me);
        this.logger.trace("Entity '{}' updated", (Object)entity.getName());
    }

    @Override
    public synchronized DbEntity removeEntity(String name) {
        MappedEntity toRemove = this.entities.get(name);
        if (toRemove == null) {
            return null;
        }
        try {
            toRemove.getInsert().executeBatch();
        }
        catch (SQLException ex) {
            this.logger.debug("Could not flush before remove '{}'", (Object)name, (Object)ex);
        }
        if (this.properties.isSchemaPolicyCreateDrop()) {
            try {
                this.dropEntity(toRemove.getEntity());
            }
            catch (DatabaseEngineException ex) {
                this.logger.debug(String.format("Something went wrong while dropping entity '%s'", name), (Throwable)ex);
            }
        }
        this.entities.remove(name);
        return toRemove.getEntity();
    }

    @Override
    public synchronized boolean containsEntity(String name) {
        return this.entities.containsKey(name);
    }

    @Override
    public synchronized void dropEntity(String entity) throws DatabaseEngineException {
        if (!this.containsEntity(entity)) {
            return;
        }
        this.dropEntity(this.entities.get(entity).getEntity());
    }

    @Override
    public synchronized void dropEntity(DbEntity entity) throws DatabaseEngineException {
        this.dropSequences(entity);
        this.dropTable(entity);
        this.entities.remove(entity.getName());
        this.logger.trace("Entity {} dropped", (Object)entity.getName());
    }

    private void dropAllEntities() {
        for (MappedEntity mappedEntity : ImmutableList.copyOf(this.entities.values())) {
            try {
                this.dropEntity(mappedEntity.getEntity());
            }
            catch (DatabaseEngineException ex) {
                this.logger.debug(String.format("Failed to drop entity '%s'", mappedEntity.getEntity().getName()), (Throwable)ex);
            }
        }
    }

    @Override
    public abstract Long persist(String var1, EntityEntry var2) throws DatabaseEngineException;

    @Override
    public abstract Long persist(String var1, EntityEntry var2, boolean var3) throws DatabaseEngineException;

    @Override
    public synchronized void flush() throws DatabaseEngineException {
        try {
            for (MappedEntity me : this.entities.values()) {
                me.getInsert().executeBatch();
            }
        }
        catch (Exception ex) {
            throw new DatabaseEngineException("Something went wrong while flushing", ex);
        }
    }

    @Override
    public synchronized void commit() throws DatabaseEngineRuntimeException {
        try {
            this.conn.commit();
            this.conn.setAutoCommit(true);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineRuntimeException("Something went wrong while committing transaction", ex);
        }
    }

    @Override
    public synchronized void rollback() throws DatabaseEngineRuntimeException {
        try {
            for (MappedEntity mappedEntity : this.entities.values()) {
                mappedEntity.getInsert().clearBatch();
                mappedEntity.getInsertReturning().clearBatch();
                mappedEntity.getInsertWithAutoInc().clearBatch();
            }
            this.conn.rollback();
            this.conn.setAutoCommit(true);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineRuntimeException("Something went wrong while rolling back the transaction", ex);
        }
    }

    @Override
    public synchronized boolean isTransactionActive() throws DatabaseEngineRuntimeException {
        try {
            return !this.conn.getAutoCommit();
        }
        catch (SQLException ex) {
            throw new DatabaseEngineRuntimeException("Something went wrong while rolling back the transaction", ex);
        }
    }

    @Override
    public synchronized int executeUpdate(String query) throws DatabaseEngineException {
        Statement s = null;
        try {
            this.getConnection();
            s = this.conn.createStatement();
            int n = s.executeUpdate(query);
            return n;
        }
        catch (Exception ex) {
            throw new DatabaseEngineException("Error handling native query", ex);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    public synchronized int executeUpdate(Expression query) throws DatabaseEngineException {
        String trans = this.translate(query);
        this.logger.trace(trans);
        return this.executeUpdate(trans);
    }

    @Override
    public String translate(Expression query) {
        this.inject(query);
        return query.translate();
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public AbstractBatch createBatch(int batchSize, long batchTimeout) {
        return this.createBatch(batchSize, batchTimeout, null);
    }

    @Override
    public AbstractBatch createBatch(int batchSize, long batchTimeout, String batchName) {
        return this.createBatch(batchSize, batchTimeout, batchName, AbstractBatch.NO_OP);
    }

    @Override
    public AbstractBatch createBatch(int batchSize, long batchTimeout, String batchName, FailureListener failureListener) {
        return DefaultBatch.create(this, batchName, batchSize, batchTimeout, this.properties.getMaximumAwaitTimeBatchShutdown(), failureListener);
    }

    private void validateEntity(DbEntity entity) throws DatabaseEngineException {
        List<DbFk> list;
        if (entity.getName() == null || entity.getName().length() == 0) {
            throw new DatabaseEngineException("You have to define the entity name");
        }
        int maxIdentSize = this.properties.getMaxIdentifierSize();
        if (entity.getName().length() > maxIdentSize) {
            throw new DatabaseEngineException(String.format("Entity '%s' exceeds the maximum number of characters (%d)", entity.getName(), maxIdentSize));
        }
        if (entity.getColumns().isEmpty()) {
            throw new DatabaseEngineException("You have to specify at least one column");
        }
        int numberOfAutoIncs = 0;
        for (DbColumn dbColumn : entity.getColumns()) {
            if (dbColumn.getName() == null || dbColumn.getName().length() == 0) {
                throw new DatabaseEngineException(String.format("Column in entity '%s' must have a name", entity.getName()));
            }
            if (dbColumn.getName().length() > maxIdentSize) {
                throw new DatabaseEngineException(String.format("Column '%s' in entity '%s' exceeds the maximum number of characters (%d)", dbColumn.getName(), entity.getName(), maxIdentSize));
            }
            if (!dbColumn.isAutoInc()) continue;
            ++numberOfAutoIncs;
        }
        if (numberOfAutoIncs > 1) {
            throw new DatabaseEngineException("You can only define one auto incremented column");
        }
        List<DbIndex> indexes = entity.getIndexes();
        if (!indexes.isEmpty()) {
            for (DbIndex index : indexes) {
                if (index.getColumns().isEmpty()) {
                    throw new DatabaseEngineException(String.format("You have to specify at least one column to create an index in entity '%s'", entity.getName()));
                }
                for (String column : index.getColumns()) {
                    if (column != null && column.length() != 0) continue;
                    throw new DatabaseEngineException(String.format("Column indexes must have a name in entity '%s'", entity.getName()));
                }
            }
        }
        if (!(list = entity.getFks()).isEmpty()) {
            for (DbFk fk : list) {
                if (fk.getForeignTable() == null || fk.getForeignTable().length() == 0) {
                    throw new DatabaseEngineException(String.format("You have to specify the table when creating a Foreign Key in entity '%s'", entity.getName()));
                }
                if (fk.getLocalColumns().isEmpty()) {
                    throw new DatabaseEngineException(String.format("You must specify at least one local column when defining a Foreign Key in '%s'", entity.getName()));
                }
                if (fk.getForeignColumns().isEmpty()) {
                    throw new DatabaseEngineException(String.format("You must specify at least one foreign column when defining a Foreign Key in '%s'", entity.getName()));
                }
                if (fk.getLocalColumns().size() == fk.getForeignColumns().size()) continue;
                throw new DatabaseEngineException(String.format("Number of local columns does not match foreign ones in entity '%s'", entity.getName()));
            }
        }
    }

    protected abstract boolean checkConnection(Connection var1);

    @Override
    public synchronized boolean checkConnection(boolean forceReconnect) {
        if (this.checkConnection(this.conn)) {
            return true;
        }
        if (forceReconnect) {
            try {
                this.connect();
                this.recover();
                return true;
            }
            catch (Exception ex) {
                this.logger.debug(dev, "reconnection failure", (Throwable)ex);
                return false;
            }
        }
        return false;
    }

    @Override
    public synchronized boolean checkConnection() {
        return this.checkConnection(false);
    }

    @Override
    public synchronized void addBatch(String name, EntityEntry entry) throws DatabaseEngineException {
        try {
            MappedEntity me = this.entities.get(name);
            if (me == null) {
                throw new DatabaseEngineException(String.format("Unknown entity '%s'", name));
            }
            PreparedStatement ps = me.getInsert();
            this.entityToPreparedStatementForBatch(me.getEntity(), ps, entry, true);
            ps.addBatch();
        }
        catch (Exception ex) {
            throw new DatabaseEngineException("Error adding to batch", ex);
        }
    }

    protected int entityToPreparedStatementForBatch(DbEntity entity, PreparedStatement ps, EntityEntry entry, boolean useAutoIncs) throws DatabaseEngineException {
        return this.entityToPreparedStatement(entity, ps, entry, useAutoIncs);
    }

    protected abstract int entityToPreparedStatement(DbEntity var1, PreparedStatement var2, EntityEntry var3, boolean var4) throws DatabaseEngineException;

    @Override
    public synchronized List<Map<String, ResultColumn>> query(Expression query) throws DatabaseEngineException {
        return this.query(this.translate(query));
    }

    @Override
    public synchronized List<Map<String, ResultColumn>> query(String query) throws DatabaseEngineException {
        return this.processResultIterator(this.iterator(query));
    }

    protected List<Map<String, ResultColumn>> processResultIterator(ResultIterator it) throws DatabaseEngineException {
        Map<String, ResultColumn> temp;
        ArrayList<Map<String, ResultColumn>> res = new ArrayList<Map<String, ResultColumn>>();
        while ((temp = it.next()) != null) {
            res.add(temp);
        }
        return res;
    }

    @Override
    public synchronized ResultIterator iterator(String query) throws DatabaseEngineException {
        return this.iterator(query, 1000);
    }

    @Override
    public synchronized ResultIterator iterator(Expression query) throws DatabaseEngineException {
        return this.iterator(query, 1000);
    }

    @Override
    public ResultIterator iterator(String query, int fetchSize) throws DatabaseEngineException {
        try {
            this.getConnection();
            Statement stmt = this.conn.createStatement();
            stmt.setFetchSize(fetchSize);
            this.logger.trace(query);
            return this.createResultIterator(stmt, query);
        }
        catch (Exception e) {
            throw new DatabaseEngineException("Error querying", e);
        }
    }

    @Override
    public ResultIterator iterator(Expression query, int fetchSize) throws DatabaseEngineException {
        return this.iterator(this.translate(query), fetchSize);
    }

    protected abstract ResultIterator createResultIterator(Statement var1, String var2) throws DatabaseEngineException;

    protected abstract void createTable(DbEntity var1) throws DatabaseEngineException;

    protected abstract void addPrimaryKey(DbEntity var1) throws DatabaseEngineException;

    protected abstract void addIndexes(DbEntity var1) throws DatabaseEngineException;

    protected abstract void addSequences(DbEntity var1) throws DatabaseEngineException;

    protected abstract void dropSequences(DbEntity var1) throws DatabaseEngineException;

    protected abstract void dropTable(DbEntity var1) throws DatabaseEngineException;

    protected abstract void dropColumn(DbEntity var1, String ... var2) throws DatabaseEngineException;

    protected abstract void addColumn(DbEntity var1, DbColumn ... var2) throws DatabaseEngineException;

    protected abstract void addFks(DbEntity var1) throws DatabaseEngineException;

    protected abstract MappedEntity createPreparedStatementForInserts(DbEntity var1) throws DatabaseEngineException;

    protected abstract String translateType(DbColumn var1) throws DatabaseEngineException;

    protected abstract ResultIterator createResultIterator(PreparedStatement var1) throws DatabaseEngineException;

    protected void dropFks(String table) throws DatabaseEngineException {
        ResultSet rs = null;
        try {
            this.getConnection();
            rs = this.conn.getMetaData().getImportedKeys(null, this.currentSchema, table);
            HashSet<String> fks = new HashSet<String>();
            while (rs.next()) {
                fks.add(rs.getString("FK_NAME"));
            }
            for (String fk : fks) {
                try {
                    this.executeUpdate(String.format("ALTER TABLE %s DROP CONSTRAINT %s", StringUtils.quotize(table, this.escapeCharacter()), StringUtils.quotize(fk, this.escapeCharacter())));
                }
                catch (Exception e) {
                    this.logger.warn("Could not drop foreign key '{}' on table '{}'", (Object)fk, (Object)table);
                    this.logger.debug("Could not drop foreign key.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new DatabaseEngineException("Error dropping foreign key", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception a) {
                this.logger.trace("Error closing result set.", (Throwable)a);
            }
        }
    }

    @Override
    public synchronized Map<String, DbEntityType> getEntities() throws DatabaseEngineException {
        return this.getEntities(this.currentSchema);
    }

    @Override
    public synchronized Map<String, DbEntityType> getEntities(String schemaPattern) throws DatabaseEngineException {
        LinkedHashMap<Object, DbEntityType> entities = new LinkedHashMap<Object, DbEntityType>();
        ResultSet rs = null;
        try {
            Object entityName;
            this.getConnection();
            rs = this.conn.getMetaData().getTables(null, schemaPattern, "%", null);
            while (rs.next()) {
                entityName = rs.getString("table_name");
                String entityType = rs.getString("table_type");
                DbEntityType type = "TABLE".equals(entityType) ? DbEntityType.TABLE : ("VIEW".equals(entityType) ? DbEntityType.VIEW : ("SYSTEM TABLE".equals(entityType) ? DbEntityType.SYSTEM_TABLE : ("SYSTEM VIEW".equals(entityType) ? DbEntityType.SYSTEM_VIEW : DbEntityType.UNMAPPED)));
                entities.put(entityName, type);
            }
            entityName = entities;
            return entityName;
        }
        catch (Exception e) {
            throw new DatabaseEngineException("Could not get entities", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception a) {
                this.logger.trace("Error closing result set.", (Throwable)a);
            }
        }
    }

    protected void executeUpdateSilently(String statement) {
        this.logger.trace(statement);
        try (Statement alter = this.conn.createStatement();){
            alter.execute(statement);
        }
        catch (SQLException e) {
            this.logger.debug("Could not execute {}.", (Object)statement, (Object)e);
        }
    }

    protected String getSchema() throws DatabaseEngineException {
        try {
            return this.conn.getSchema();
        }
        catch (Exception e) {
            throw new DatabaseEngineException("Could not get current schema", e);
        }
    }

    protected void setSchema(String schema) throws DatabaseEngineException {
        try {
            this.conn.setSchema(schema);
        }
        catch (Exception e) {
            throw new DatabaseEngineException(String.format("Could not set current schema to '%s'", schema), e);
        }
    }

    @Override
    public synchronized Map<String, DbColumnType> getMetadata(String tableNamePattern) throws DatabaseEngineException {
        return this.getMetadata(this.currentSchema, tableNamePattern);
    }

    @Override
    public synchronized Map<String, DbColumnType> getMetadata(String schemaPattern, String tableNamePattern) throws DatabaseEngineException {
        LinkedHashMap<String, DbColumnType> metaMap = new LinkedHashMap<String, DbColumnType>();
        ResultSet rsColumns = null;
        try {
            this.getConnection();
            DatabaseMetaData meta = this.conn.getMetaData();
            rsColumns = meta.getColumns(null, schemaPattern, tableNamePattern, null);
            while (rsColumns.next()) {
                metaMap.put(rsColumns.getString("COLUMN_NAME"), this.toPdbType(rsColumns.getInt("DATA_TYPE"), rsColumns.getString("TYPE_NAME")));
            }
            LinkedHashMap<String, DbColumnType> linkedHashMap = metaMap;
            return linkedHashMap;
        }
        catch (Exception e) {
            throw new DatabaseEngineException("Could not get metadata", e);
        }
        finally {
            try {
                if (rsColumns != null) {
                    rsColumns.close();
                }
            }
            catch (Exception a) {
                this.logger.trace("Error closing result set.", (Throwable)a);
            }
        }
    }

    @Override
    public Map<String, DbColumnType> getQueryMetadata(Expression query) throws DatabaseEngineException {
        String queryString = this.translate(query);
        this.logger.trace(queryString);
        return this.getQueryMetadata(queryString);
    }

    @Override
    public Map<String, DbColumnType> getQueryMetadata(String query) throws DatabaseEngineException {
        LinkedHashMap<String, DbColumnType> metaMap = new LinkedHashMap<String, DbColumnType>();
        ResultSet rs = null;
        Statement stmt = null;
        try {
            this.getConnection();
            stmt = this.conn.createStatement();
            long start = System.currentTimeMillis();
            rs = stmt.executeQuery(query);
            this.logger.trace("[{} ms] {}", (Object)(System.currentTimeMillis() - start), (Object)query);
            ResultSetMetaData meta = rs.getMetaData();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                metaMap.put(meta.getColumnName(i), this.toPdbType(meta.getColumnType(i), meta.getColumnTypeName(i)));
            }
            LinkedHashMap<String, DbColumnType> linkedHashMap = metaMap;
            return linkedHashMap;
        }
        catch (Exception e) {
            throw new DatabaseEngineException("Error querying", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing result set.", (Throwable)e);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    protected DbColumnType toPdbType(int type, String typeName) {
        switch (type) {
            case -7: 
            case 16: {
                return DbColumnType.BOOLEAN;
            }
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: 
            case 2009: {
                return DbColumnType.STRING;
            }
            case -6: 
            case 4: 
            case 5: {
                return DbColumnType.INT;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return DbColumnType.DOUBLE;
            }
            case -5: 
            case 93: {
                return DbColumnType.LONG;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2000: 
            case 2004: {
                return DbColumnType.BLOB;
            }
            case 2005: 
            case 2011: {
                return DbColumnType.CLOB;
            }
        }
        return DbColumnType.UNMAPPED;
    }

    @Override
    public synchronized DatabaseEngine duplicate(Properties mergeProperties, boolean copyEntities) throws DuplicateEngineException {
        if (mergeProperties == null) {
            mergeProperties = new Properties();
        }
        PdbProperties niwProps = this.properties.clone();
        niwProps.merge(mergeProperties);
        if (!niwProps.isSchemaPolicyNone() && !niwProps.isSchemaPolicyCreate()) {
            throw new DuplicateEngineException("Duplicate can only be called if pdb.policy is set to 'create' or 'none'");
        }
        try {
            DatabaseEngine niw = DatabaseFactory.getConnection(niwProps);
            if (copyEntities) {
                for (MappedEntity entity : this.entities.values()) {
                    niw.addEntity(entity.getEntity());
                }
            }
            return niw;
        }
        catch (Exception e) {
            throw new DuplicateEngineException("Could not duplicate connection", e);
        }
    }

    @Override
    public PdbProperties getProperties() {
        return this.properties.clone();
    }

    @Override
    public synchronized void createPreparedStatement(String name, Expression query) throws NameAlreadyExistsException, DatabaseEngineException {
        this.createPreparedStatement(name, query, -1);
    }

    @Override
    public synchronized void createPreparedStatement(String name, String query) throws NameAlreadyExistsException, DatabaseEngineException {
        this.createPreparedStatement(name, query, -1);
    }

    @Override
    public synchronized void createPreparedStatement(String name, Expression query, int timeout) throws NameAlreadyExistsException, DatabaseEngineException {
        String queryString = this.translate(query);
        this.logger.trace(queryString);
        this.createPreparedStatement(name, queryString, timeout);
    }

    @Override
    public synchronized void createPreparedStatement(String name, String query, int timeout) throws NameAlreadyExistsException, DatabaseEngineException {
        this.createPreparedStatement(name, query, timeout, false);
    }

    @Override
    public synchronized void removePreparedStatement(String name) {
        PreparedStatementCapsule ps = this.stmts.remove(name);
        if (ps == null) {
            return;
        }
        try {
            ps.ps.close();
        }
        catch (SQLException e) {
            this.logger.debug("Error closing prepared statement '{}'.", (Object)name, (Object)e);
        }
    }

    @Override
    public synchronized List<Map<String, ResultColumn>> getPSResultSet(String name) throws DatabaseEngineException {
        return this.processResultIterator(this.getPSIterator(name));
    }

    @Override
    public synchronized ResultIterator getPSIterator(String name) throws DatabaseEngineException {
        return this.getPSIterator(name, 1000);
    }

    @Override
    public ResultIterator getPSIterator(String name, int fetchSize) throws DatabaseEngineException {
        PreparedStatementCapsule ps = this.stmts.get(name);
        if (ps == null) {
            throw new DatabaseEngineRuntimeException(String.format("PreparedStatement named '%s' does not exist", name));
        }
        try {
            ps.ps.setFetchSize(fetchSize);
        }
        catch (SQLException e) {
            throw new DatabaseEngineException("Error creating PS Iterator", e);
        }
        return this.createResultIterator(ps.ps);
    }

    @Override
    public synchronized void setParameters(String name, Object ... params) throws DatabaseEngineException, ConnectionResetException {
        PreparedStatementCapsule ps = this.stmts.get(name);
        if (ps == null) {
            throw new DatabaseEngineRuntimeException(String.format("PreparedStatement named '%s' does not exist", name));
        }
        int i = 1;
        for (Object o : params) {
            try {
                this.setParameterValues(ps.ps, i, o);
            }
            catch (SQLException ex) {
                if (this.checkConnection(this.conn) || !this.properties.isReconnectOnLost()) {
                    throw new DatabaseEngineException("Could not set parameters", ex);
                }
                try {
                    this.getConnection();
                }
                catch (Exception e2) {
                    throw new DatabaseEngineException("Connection is down", e2);
                }
                throw new ConnectionResetException("Connection was lost, you must reset the prepared statement parameters and re-execute the statement");
            }
            ++i;
        }
    }

    @Override
    public synchronized void setParameter(String name, int index, Object param) throws DatabaseEngineException, ConnectionResetException {
        PreparedStatementCapsule ps = this.stmts.get(name);
        if (ps == null) {
            throw new DatabaseEngineRuntimeException(String.format("PreparedStatement named '%s' does not exist", name));
        }
        try {
            this.setParameterValues(ps.ps, index, param);
        }
        catch (SQLException ex) {
            if (this.checkConnection(this.conn) || !this.properties.isReconnectOnLost()) {
                throw new DatabaseEngineException("Could not set parameter", ex);
            }
            try {
                this.getConnection();
            }
            catch (Exception e2) {
                throw new DatabaseEngineException("Connection is down", e2);
            }
            throw new ConnectionResetException("Connection was lost, you must reset the prepared statement parameters and re-execute the statement");
        }
    }

    @Override
    public synchronized void setParameter(String name, int index, Object param, DbColumnType paramType) throws DatabaseEngineException, ConnectionResetException {
        this.setParameter(name, index, param);
    }

    @Override
    public synchronized void executePS(String name) throws DatabaseEngineException, ConnectionResetException {
        PreparedStatementCapsule ps = this.stmts.get(name);
        if (ps == null) {
            throw new DatabaseEngineRuntimeException(String.format("PreparedStatement named '%s' does not exist", name));
        }
        try {
            ps.ps.execute();
        }
        catch (SQLException e) {
            this.logger.error("Error executing prepared statement", (Throwable)e);
            if (this.checkConnection(this.conn) || !this.properties.isReconnectOnLost()) {
                throw new DatabaseEngineException(String.format("Something went wrong executing the prepared statement '%s'", name), e);
            }
            try {
                this.getConnection();
            }
            catch (Exception e2) {
                throw new DatabaseEngineException("Connection is down", e2);
            }
            throw new ConnectionResetException("Connection was lost, you must reset the prepared statement parameters and re-execute the statement");
        }
    }

    @Override
    public synchronized void clearParameters(String name) throws DatabaseEngineException, ConnectionResetException {
        PreparedStatementCapsule ps = this.stmts.get(name);
        if (ps == null) {
            throw new DatabaseEngineRuntimeException(String.format("PreparedStatement named '%s' does not exist", name));
        }
        try {
            ps.ps.clearParameters();
        }
        catch (SQLException ex) {
            if (this.checkConnection(this.conn) || !this.properties.isReconnectOnLost()) {
                throw new DatabaseEngineException("Error clearing parameters", ex);
            }
            try {
                this.getConnection();
            }
            catch (Exception e2) {
                throw new DatabaseEngineException("Connection is down", e2);
            }
            throw new ConnectionResetException("Connection was reset.");
        }
    }

    @Override
    public synchronized boolean preparedStatementExists(String name) {
        return this.stmts.containsKey(name);
    }

    @Override
    public synchronized Integer executePSUpdate(String name) throws DatabaseEngineException, ConnectionResetException {
        PreparedStatementCapsule ps = this.stmts.get(name);
        if (ps == null) {
            throw new DatabaseEngineRuntimeException(String.format("PreparedStatement named '%s' does not exist", name));
        }
        try {
            return ps.ps.executeUpdate();
        }
        catch (SQLException e) {
            if (this.checkConnection(this.conn) || !this.properties.isReconnectOnLost()) {
                throw new DatabaseEngineException(String.format("Something went wrong executing the prepared statement '%s'", name), e);
            }
            try {
                this.getConnection();
            }
            catch (Exception e2) {
                throw new DatabaseEngineException("Connection is down", e2);
            }
            throw new ConnectionResetException("Connection was lost, you must reset the prepared statement parameters and re-execute the statement");
        }
    }

    private void createPreparedStatement(String name, String query, int timeout, boolean recovering) throws NameAlreadyExistsException, DatabaseEngineException {
        if (!recovering) {
            if (this.stmts.containsKey(name)) {
                throw new NameAlreadyExistsException(String.format("There's already a PreparedStatement with the name '%s'", name));
            }
            try {
                this.getConnection();
            }
            catch (Exception e) {
                throw new DatabaseEngineException("Could not create prepared statement", e);
            }
        }
        try {
            PreparedStatement ps = this.conn.prepareStatement(query);
            if (timeout > 0) {
                ps.setQueryTimeout(timeout);
            }
            this.stmts.put(name, new PreparedStatementCapsule(query, ps, timeout));
        }
        catch (SQLException e) {
            throw new DatabaseEngineException("Could not create prepared statement", e);
        }
    }

    @Override
    public String commentCharacter() {
        return "--";
    }

    @Override
    public String escapeCharacter() {
        return this.translator.translateEscape();
    }

    @Override
    public synchronized void setExceptionHandler(ExceptionHandler eh) {
        this.eh = eh;
    }

    protected void handleOperation(OperationFault op, Exception e) throws DatabaseEngineException {
        if (!this.eh.proceed(op, e)) {
            throw new DatabaseEngineException("An error occurred adding the entity.", e);
        }
    }

    private byte[] getReusableByteBuffer() {
        if (this.reusableByteBuffer == null) {
            this.reusableByteBuffer = new byte[this.properties.getBlobBufferSize()];
        }
        return this.reusableByteBuffer;
    }

    protected final synchronized byte[] objectToArray(Object val) throws IOException {
        InitiallyReusableByteArrayOutputStream bos = new InitiallyReusableByteArrayOutputStream(this.getReusableByteBuffer());
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(val);
        return bos.toByteArray();
    }

    public boolean hasIdentityColumn(DbEntity entity) {
        for (DbColumn column : entity.getColumns()) {
            if (!column.isAutoInc()) continue;
            return true;
        }
        return false;
    }

    protected void inject(Expression ... objs) {
        for (Expression o : objs) {
            if (o == null) continue;
            this.injector.injectMembers((Object)o);
        }
    }

    protected void setParameterValues(PreparedStatement ps, int index, Object param) throws SQLException {
        if (param instanceof byte[]) {
            ps.setBytes(index, (byte[])param);
        } else {
            ps.setObject(index, param);
        }
    }
}

