/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.impl;

import com.feedzai.commons.sql.abstraction.ddl.AlterColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DropPrimaryKey;
import com.feedzai.commons.sql.abstraction.ddl.Rename;
import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.dml.Function;
import com.feedzai.commons.sql.abstraction.dml.Join;
import com.feedzai.commons.sql.abstraction.dml.Modulo;
import com.feedzai.commons.sql.abstraction.dml.Name;
import com.feedzai.commons.sql.abstraction.dml.Query;
import com.feedzai.commons.sql.abstraction.dml.RepeatDelimiter;
import com.feedzai.commons.sql.abstraction.dml.StringAgg;
import com.feedzai.commons.sql.abstraction.dml.View;
import com.feedzai.commons.sql.abstraction.engine.AbstractTranslator;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineRuntimeException;
import com.feedzai.commons.sql.abstraction.engine.OperationNotSupportedRuntimeException;
import com.feedzai.commons.sql.abstraction.util.StringUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class OracleTranslator
extends AbstractTranslator {
    @Override
    public String translate(AlterColumn ac) {
        DbColumn column = ac.getColumn();
        Expression table = ac.getTable();
        Name name = new Name(column.getName());
        this.inject(table, name);
        StringBuilder sb = new StringBuilder("ALTER TABLE ").append(table.translate()).append(" MODIFY (").append(name.translate()).append(" ").append(this.translate(column)).append(" ");
        List trans = Lists.transform(column.getColumnConstraints(), DbColumnConstraint::translate);
        sb.append(Joiner.on((String)" ").join((Iterable)trans));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String translate(DropPrimaryKey dpk) {
        Expression table = dpk.getTable();
        this.inject(table);
        if (!(table instanceof Name)) {
            throw new DatabaseEngineRuntimeException("DropPrimaryKey must receive a Name object");
        }
        String tableName = ((Name)table).getName();
        String pkName = StringUtils.md5(String.format("PK_%s", tableName), this.properties.getMaxIdentifierSize());
        return String.format("ALTER TABLE %s DROP CONSTRAINT %s", table.translate(), StringUtils.quotize(pkName));
    }

    @Override
    public String translate(Function f) {
        String function = f.getFunction();
        Expression exp = f.getExp();
        this.inject(exp);
        String expTranslated = "";
        if (exp != null) {
            expTranslated = exp.translate();
        }
        return function + "(" + expTranslated + ")";
    }

    @Override
    public String translate(Modulo m) {
        Expression dividend = m.getDividend();
        Expression divisor = m.getDivisor();
        this.inject(dividend, divisor);
        return String.format("MOD(%s, %s)", dividend.translate(), divisor.translate());
    }

    @Override
    public String translate(Rename r) {
        Expression oldName = r.getOldName();
        Expression newName = r.getNewName();
        this.inject(oldName, newName);
        return String.format("ALTER TABLE %s RENAME TO %s", oldName.translate(), newName.translate());
    }

    @Override
    public String translate(RepeatDelimiter rd) {
        String delimiter = rd.getDelimiter();
        List all = Lists.transform(rd.getExpressions(), input -> {
            this.inject((Expression)input);
            return input.translate();
        });
        if (rd.isEnclosed()) {
            return "(" + org.apache.commons.lang3.StringUtils.join((Iterable)all, (String)delimiter) + ")";
        }
        return org.apache.commons.lang3.StringUtils.join((Iterable)all, (String)delimiter);
    }

    @Override
    public String translate(Query q) {
        List<Expression> fromColumns = q.getFromColumns();
        List<Expression> groupbyColumns = q.getGroupbyColumns();
        List<Expression> orderbyColumns = q.getOrderbyColumns();
        List<Expression> selectColumns = q.getSelectColumns();
        Expression having = q.getHaving();
        Expression where = q.getWhere();
        this.inject(fromColumns);
        this.inject(groupbyColumns);
        this.inject(orderbyColumns);
        this.inject(selectColumns);
        this.inject(having, where);
        ArrayList<String> query = new ArrayList<String>();
        query.add("SELECT" + (q.isDistinct() ? " DISTINCT" : ""));
        ArrayList<String> querySelectColumns = new ArrayList<String>();
        for (Expression dbe : selectColumns) {
            if (dbe instanceof Query) {
                querySelectColumns.add("(" + dbe.translate() + (!dbe.isAliased() ? ")" : ") AS " + StringUtils.quotize(dbe.getAlias())));
                continue;
            }
            querySelectColumns.add(dbe.translate() + (!dbe.isAliased() ? "" : " AS " + StringUtils.quotize(dbe.getAlias())));
        }
        query.add(this.join(querySelectColumns, ", "));
        query.add("FROM");
        if (!fromColumns.isEmpty()) {
            ArrayList<String> queryFromColumns = new ArrayList<String>();
            for (Expression dbe : fromColumns) {
                ArrayList<String> insideFrom = new ArrayList<String>();
                if (dbe instanceof Query) {
                    insideFrom.add("(" + dbe.translate() + (!dbe.isAliased() ? ")" : ") " + StringUtils.quotize(dbe.getAlias())));
                } else {
                    insideFrom.add(dbe.translate() + (!dbe.isAliased() ? "" : " " + StringUtils.quotize(dbe.getAlias())));
                }
                List<Join> joins = dbe.getJoins();
                if (!joins.isEmpty()) {
                    for (Join j : joins) {
                        this.inject(j);
                        insideFrom.add(j.translate());
                    }
                }
                queryFromColumns.add(this.join(insideFrom, " "));
            }
            query.add(this.join(queryFromColumns, ", "));
        } else {
            query.add(StringUtils.quotize("DUAL"));
        }
        if (where != null) {
            query.add("WHERE");
            query.add(where.translate());
        }
        if (!groupbyColumns.isEmpty()) {
            query.add("GROUP BY");
            ArrayList<String> queryGroupByColumns = new ArrayList<String>();
            for (Expression column : groupbyColumns) {
                queryGroupByColumns.add(column.translate());
            }
            query.add(this.join(queryGroupByColumns, ", "));
        }
        if (having != null) {
            query.add("HAVING");
            query.add(having.translate());
        }
        if (!orderbyColumns.isEmpty()) {
            query.add("ORDER BY");
            ArrayList<String> queryOrderByColumns = new ArrayList<String>();
            for (Expression column : orderbyColumns) {
                queryOrderByColumns.add(column.translate());
            }
            query.add(this.join(queryOrderByColumns, ", "));
        }
        String finalQuery = this.join(query, " ");
        if (q.getLimit() > 0) {
            finalQuery = q.getOffset() > 0 ? String.format("SELECT * FROM (SELECT rownum rnum ,offlim.* FROM (%s) offlim WHERE rownum <= %d) WHERE rnum > %d", finalQuery, q.getLimit() + q.getOffset(), q.getOffset()) : String.format("SELECT * FROM (%s) a WHERE rownum <= %d", finalQuery, q.getLimit());
        }
        return q.isEnclosed() ? "(" + finalQuery + ")" : finalQuery;
    }

    @Override
    public String translate(View v) {
        Expression as = v.getAs();
        String name = v.getName();
        this.inject(as);
        ArrayList<String> res = new ArrayList<String>();
        res.add("CREATE");
        if (v.isReplace()) {
            res.add("OR REPLACE");
        }
        res.add("VIEW");
        res.add(StringUtils.quotize(name));
        res.add("AS " + as.translate());
        return this.join(res, " ");
    }

    @Override
    public String translate(DbColumn c) {
        this.inject(c.getDefaultValue());
        switch (c.getDbColumnType()) {
            case BOOLEAN: {
                return String.format("char %s check (%s in ('0', '1'))", c.isDefaultValueSet() ? "DEFAULT " + c.getDefaultValue().translate() : "", StringUtils.quotize(c.getName()));
            }
            case DOUBLE: {
                return "BINARY_DOUBLE";
            }
            case INT: {
                return "INT";
            }
            case LONG: {
                return "NUMBER(19,0)";
            }
            case STRING: {
                return String.format("VARCHAR(%s)", c.isSizeSet() ? c.getSize().toString() : this.properties.getProperty("pdb.varchar_size"));
            }
            case CLOB: 
            case JSON: {
                return "CLOB";
            }
            case BLOB: {
                return "BLOB";
            }
        }
        throw new DatabaseEngineRuntimeException(String.format("Mapping not found for '%s'. Please report this error.", new Object[]{c.getDbColumnType()}));
    }

    @Override
    public String translate(StringAgg stringAgg) {
        if (stringAgg.isDistinct()) {
            throw new OperationNotSupportedRuntimeException("LISTAGG does not support distinct. If you really need it, you may do it using regex or a subquery. Check this: https://dba.stackexchange.com/a/8478 or this:https://stackoverflow.com/a/50589222");
        }
        this.inject(stringAgg.column);
        String column = stringAgg.getColumn().translate();
        return String.format("LISTAGG(%s, '%c') WITHIN GROUP (ORDER BY %s)", column, Character.valueOf(stringAgg.getDelimiter()), column);
    }

    @Override
    public String translateEscape() {
        return "\"";
    }

    @Override
    public String translateTrue() {
        return "'1'";
    }

    @Override
    public String translateFalse() {
        return "'0'";
    }
}

