/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.impl;

import com.feedzai.commons.sql.abstraction.ddl.AlterColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DropPrimaryKey;
import com.feedzai.commons.sql.abstraction.ddl.Rename;
import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.dml.Function;
import com.feedzai.commons.sql.abstraction.dml.Join;
import com.feedzai.commons.sql.abstraction.dml.Modulo;
import com.feedzai.commons.sql.abstraction.dml.Name;
import com.feedzai.commons.sql.abstraction.dml.Query;
import com.feedzai.commons.sql.abstraction.dml.RepeatDelimiter;
import com.feedzai.commons.sql.abstraction.dml.Truncate;
import com.feedzai.commons.sql.abstraction.dml.View;
import com.feedzai.commons.sql.abstraction.engine.AbstractTranslator;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineRuntimeException;
import com.feedzai.commons.sql.abstraction.util.StringUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class DB2Translator
extends AbstractTranslator {
    @Override
    public String translate(AlterColumn ac) {
        DbColumn column = ac.getColumn();
        Expression table = ac.getTable();
        Name name = new Name(column.getName());
        this.inject(table, name);
        StringBuilder sb = new StringBuilder();
        if (!column.getColumnConstraints().isEmpty()) {
            sb.append("ALTER TABLE ").append(table.translate()).append(" ALTER COLUMN ").append(name.translate()).append(" SET ");
            List trans = Lists.transform(column.getColumnConstraints(), DbColumnConstraint::translate);
            sb.append(Joiner.on((String)" ").join((Iterable)trans)).append('\u001f');
        }
        sb.append("ALTER TABLE ").append(table.translate()).append(" ALTER COLUMN ").append(name.translate()).append(" SET DATA TYPE ").append(this.translate(column));
        return sb.toString();
    }

    @Override
    public String translate(DropPrimaryKey dpk) {
        Expression table = dpk.getTable();
        this.inject(table);
        return String.format("ALTER TABLE %s DROP PRIMARY KEY", table.translate());
    }

    @Override
    public String translate(Function f) {
        Expression exp = f.getExp();
        String function = f.getFunction();
        this.inject(exp);
        String expTranslated = "";
        if (exp != null) {
            expTranslated = exp.translate();
        }
        if ("STDDEV".equalsIgnoreCase(function)) {
            return "SQRT(VARIANCE(" + expTranslated + ")*COUNT(1)/(COUNT(1)-1))";
        }
        if ("AVG".equalsIgnoreCase(function)) {
            return "AVG(" + expTranslated + "+0.0)";
        }
        if (f.isUDF() && this.properties.isSchemaSet()) {
            return StringUtils.quotize(this.properties.getSchema(), this.translateEscape()) + "." + function + "(" + expTranslated + ")";
        }
        return function + "(" + expTranslated + ")";
    }

    @Override
    public String translate(Modulo m) {
        Expression dividend = m.getDividend();
        Expression divisor = m.getDivisor();
        this.inject(dividend, divisor);
        return String.format("MOD(%s, %s)", dividend.translate(), divisor.translate());
    }

    @Override
    public String translate(Rename r) {
        Expression oldName = r.getOldName();
        Expression newName = r.getNewName();
        this.inject(oldName, newName);
        return String.format("RENAME TABLE %s TO %s", oldName.translate(), newName.translate());
    }

    @Override
    public String translate(RepeatDelimiter rd) {
        String delimiter = rd.getDelimiter();
        List all = Lists.transform(rd.getExpressions(), input -> {
            this.inject((Expression)input);
            return input.translate();
        });
        if (" / ".equals(delimiter)) {
            if (rd.isEnclosed()) {
                return "(1.0*" + this.join(all, delimiter) + ")";
            }
            return "1.0*" + this.join(all, delimiter);
        }
        if (rd.isEnclosed()) {
            return "(" + this.join(all, delimiter) + ")";
        }
        return this.join(all, delimiter);
    }

    @Override
    public String translate(Truncate t) {
        Expression table = t.getTable();
        this.inject(table);
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("TRUNCATE TABLE");
        temp.add(table.translate());
        temp.add("IMMEDIATE");
        return this.join(temp, " ");
    }

    @Override
    public String translate(Query q) {
        List<Expression> fromColumns = q.getFromColumns();
        List<Expression> groupbyColumns = q.getGroupbyColumns();
        List<Expression> orderbyColumns = q.getOrderbyColumns();
        List<Expression> selectColumns = q.getSelectColumns();
        Expression having = q.getHaving();
        Expression where = q.getWhere();
        this.inject(fromColumns);
        this.inject(groupbyColumns);
        this.inject(orderbyColumns);
        this.inject(selectColumns);
        this.inject(having, where);
        ArrayList<String> query = new ArrayList<String>();
        query.add("SELECT" + (q.isDistinct() ? " DISTINCT" : ""));
        ArrayList<String> querySelectColumns = new ArrayList<String>();
        for (Expression dbe : selectColumns) {
            if (dbe instanceof Query) {
                querySelectColumns.add("(" + dbe.translate() + (!dbe.isAliased() ? ")" : ") AS " + StringUtils.quotize(dbe.getAlias())));
                continue;
            }
            querySelectColumns.add(dbe.translate() + (!dbe.isAliased() ? "" : " AS " + StringUtils.quotize(dbe.getAlias())));
        }
        query.add(this.join(querySelectColumns, ", "));
        query.add("FROM");
        if (!fromColumns.isEmpty()) {
            ArrayList<String> queryFromColumns = new ArrayList<String>();
            for (Expression dbe : fromColumns) {
                ArrayList<String> insideFrom = new ArrayList<String>();
                if (dbe instanceof Query) {
                    insideFrom.add("(" + dbe.translate() + (!dbe.isAliased() ? ")" : ") " + StringUtils.quotize(dbe.getAlias())));
                } else {
                    insideFrom.add(dbe.translate() + (!dbe.isAliased() ? "" : " " + StringUtils.quotize(dbe.getAlias())));
                }
                List<Join> joins = dbe.getJoins();
                if (!joins.isEmpty()) {
                    for (Join j : joins) {
                        this.inject(j);
                        insideFrom.add(j.translate());
                    }
                }
                queryFromColumns.add(this.join(insideFrom, " "));
            }
            query.add(this.join(queryFromColumns, ", "));
        } else {
            query.add("sysibm.sysdummy1");
        }
        if (where != null) {
            query.add("WHERE");
            query.add(where.translate());
        }
        if (!groupbyColumns.isEmpty()) {
            query.add("GROUP BY");
            ArrayList<String> queryGroupByColumns = new ArrayList<String>();
            for (Expression column : groupbyColumns) {
                queryGroupByColumns.add(column.translate());
            }
            query.add(this.join(queryGroupByColumns, ", "));
        }
        if (having != null) {
            query.add("HAVING");
            query.add(having.translate());
        }
        if (!orderbyColumns.isEmpty()) {
            query.add("ORDER BY");
            ArrayList<String> queryOrderByColumns = new ArrayList<String>();
            for (Expression column : orderbyColumns) {
                queryOrderByColumns.add(column.translate());
            }
            query.add(this.join(queryOrderByColumns, ", "));
        }
        String finalQuery = this.join(query, " ");
        if (q.getLimit() > 0) {
            finalQuery = q.getOffset() > 0 ? String.format("SELECT * FROM (SELECT ROW_NUMBER() OVER() rnum ,offlim.* FROM (%s) offlim) WHERE rnum <= %d AND rnum > %d", finalQuery, q.getLimit() + q.getOffset(), q.getOffset()) : String.format("SELECT * FROM (%s) FETCH FIRST %d ROWS ONLY", finalQuery, q.getLimit());
        }
        return q.isEnclosed() ? "(" + finalQuery + ")" : finalQuery;
    }

    @Override
    public String translate(View v) {
        Expression as = v.getAs();
        String name = v.getName();
        this.inject(as);
        ArrayList<String> res = new ArrayList<String>();
        res.add("CREATE");
        if (v.isReplace()) {
            res.add("OR REPLACE");
        }
        res.add("VIEW");
        res.add(StringUtils.quotize(name));
        res.add("AS " + as.translate());
        return this.join(res, " ");
    }

    @Override
    public String translate(DbColumn c) {
        switch (c.getDbColumnType()) {
            case BOOLEAN: {
                return String.format("char check (%s in ('0', '1'))", StringUtils.quotize(c.getName()));
            }
            case DOUBLE: {
                return "DOUBLE PRECISION";
            }
            case INT: {
                return "INT";
            }
            case LONG: {
                return "NUMERIC(19,0)";
            }
            case STRING: {
                return String.format("VARCHAR(%s)", c.isSizeSet() ? c.getSize().toString() : this.properties.getProperty("pdb.varchar_size"));
            }
            case JSON: 
            case CLOB: 
            case BLOB: {
                if (this.properties.isMaxBlobSizeSet()) {
                    return String.format("BLOB(%s)", c.isSizeSet() ? c.getSize().toString() : this.properties.getProperty("pdb.max_blob_size"));
                }
                return String.format("BLOB(%s)", "2G");
            }
        }
        throw new DatabaseEngineRuntimeException(String.format("Mapping not found for '%s'. Please report this error.", new Object[]{c.getDbColumnType()}));
    }

    @Override
    public String translateEscape() {
        return "\"";
    }

    @Override
    public String translateTrue() {
        return "'1'";
    }

    @Override
    public String translateFalse() {
        return "'0'";
    }
}

