/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml;

import com.feedzai.commons.sql.abstraction.dml.Join;
import com.feedzai.commons.sql.abstraction.dml.Query;
import com.feedzai.commons.sql.abstraction.engine.AbstractTranslator;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class Expression
implements Serializable {
    @Inject
    protected AbstractTranslator translator;
    @Inject
    protected PdbProperties properties;
    protected String alias = null;
    protected boolean enclosed = false;
    protected boolean quotes = true;
    protected String ordering = null;
    protected final List<Join> joins = new ArrayList<Join>();
    protected boolean withNoLock = false;

    public abstract String translate();

    public Expression alias(String alias) {
        this.alias = alias;
        return this;
    }

    public Expression unquote() {
        this.quotes = false;
        return this;
    }

    public Expression enclose() {
        this.enclosed = true;
        return this;
    }

    public Expression asc() {
        this.ordering = "ASC";
        return this;
    }

    public Expression desc() {
        this.ordering = "DESC";
        return this;
    }

    public boolean isEnclosed() {
        return this.enclosed;
    }

    public boolean isQuote() {
        return this.quotes;
    }

    public boolean isAliased() {
        return this.alias != null;
    }

    public Expression innerJoin(Expression table, Expression expr) {
        if (table instanceof Query) {
            table.enclose();
        }
        this.joins.add(new Join("INNER JOIN", table, expr));
        return this;
    }

    public Expression leftOuterJoin(Expression table, Expression expr) {
        if (table instanceof Query) {
            table.enclose();
        }
        this.joins.add(new Join("LEFT OUTER JOIN", table, expr));
        return this;
    }

    public Expression rightOuterJoin(Expression table, Expression expr) {
        if (table instanceof Query) {
            table.enclose();
        }
        this.joins.add(new Join("RIGHT OUTER JOIN", table, expr));
        return this;
    }

    public Expression fullOuterJoin(Expression table, Expression expr) {
        if (table instanceof Query) {
            table.enclose();
        }
        this.joins.add(new Join("FULL OUTER JOIN", table, expr));
        return this;
    }

    public Expression withNoLock() {
        this.withNoLock = true;
        return this;
    }

    public boolean isWithNoLock() {
        return this.withNoLock;
    }

    public List<Join> getJoins() {
        return ImmutableList.copyOf(this.joins);
    }

    public String getOrdering() {
        return this.ordering;
    }

    public boolean isQuotes() {
        return this.quotes;
    }

    public String getAlias() {
        return this.alias;
    }
}

