/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.impl;

import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DbEntity;
import com.feedzai.commons.sql.abstraction.ddl.DbFk;
import com.feedzai.commons.sql.abstraction.ddl.DbIndex;
import com.feedzai.commons.sql.abstraction.dml.dialect.Dialect;
import com.feedzai.commons.sql.abstraction.dml.result.H2ResultIterator;
import com.feedzai.commons.sql.abstraction.dml.result.ResultIterator;
import com.feedzai.commons.sql.abstraction.engine.AbstractDatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.AbstractTranslator;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineDriver;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.engine.MappedEntity;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.engine.handler.OperationFault;
import com.feedzai.commons.sql.abstraction.engine.impl.H2Translator;
import com.feedzai.commons.sql.abstraction.entry.EntityEntry;
import com.feedzai.commons.sql.abstraction.util.StringUtils;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class H2Engine
extends AbstractDatabaseEngine {
    protected static final String H2_DRIVER = DatabaseEngineDriver.H2.driver();
    public static final String NAME_ALREADY_EXISTS = "42S01";
    public static final String INDEX_ALREADY_EXISTS = "42S11";
    public static final String TABLE_CAN_ONLY_HAVE_ONE_PRIMARY_KEY = "90017";
    public static final String TABLE_OR_VIEW_DOES_NOT_EXIST = "42S02";
    public static final String CONSTRAINT_NAME_ALREADY_EXISTS = "90045";

    public H2Engine(PdbProperties properties) throws DatabaseEngineException {
        super(H2_DRIVER, properties, Dialect.H2);
    }

    @Override
    protected String getFinalJdbcConnection(String jdbc) {
        if (!jdbc.contains("AUTO_SERVER")) {
            jdbc = jdbc.concat(";AUTO_SERVER=TRUE");
        }
        if (!jdbc.contains("DB_CLOSE_ON_EXIT")) {
            jdbc = jdbc.concat(";DB_CLOSE_ON_EXIT=FALSE");
        }
        return jdbc;
    }

    @Override
    public Class<? extends AbstractTranslator> getTranslatorClass() {
        return H2Translator.class;
    }

    @Override
    protected int entityToPreparedStatement(DbEntity entity, PreparedStatement ps, EntityEntry entry, boolean useAutoInc) throws DatabaseEngineException {
        int i = 1;
        for (DbColumn column : entity.getColumns()) {
            if (column.isAutoInc() && useAutoInc) continue;
            try {
                Object val = column.isDefaultValueSet() && !entry.containsKey(column.getName()) ? column.getDefaultValue().getConstant() : entry.get(column.getName());
                switch (column.getDbColumnType()) {
                    case BLOB: {
                        ps.setBytes(i, this.objectToArray(val));
                        break;
                    }
                    case JSON: 
                    case CLOB: {
                        if (val == null) {
                            ps.setNull(i, 2005);
                            break;
                        }
                        if (val instanceof String) {
                            StringReader sr = new StringReader((String)val);
                            ps.setCharacterStream(i, sr);
                            break;
                        }
                        throw new DatabaseEngineException("Cannot convert " + val.getClass().getSimpleName() + " to String. CLOB columns only accept Strings.");
                    }
                    default: {
                        ps.setObject(i, val);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                throw new DatabaseEngineException("Error while mapping variables to database", ex);
            }
            ++i;
        }
        return i - 1;
    }

    private DbEntity injectNotNullIfMissing(DbEntity entity) {
        DbEntity.Builder builder = new DbEntity.Builder().name(entity.getName()).addFks(entity.getFks()).pkFields(entity.getPkFields()).addIndexes(entity.getIndexes());
        List<String> pkFields = entity.getPkFields();
        ArrayList<DbColumn> columns = new ArrayList<DbColumn>();
        for (DbColumn c : entity.getColumns()) {
            if (pkFields.contains(c.getName()) && !c.getColumnConstraints().contains((Object)DbColumnConstraint.NOT_NULL)) {
                columns.add(new DbColumn.Builder().name(c.getName()).type(c.getDbColumnType()).size(c.getSize()).addConstraints(c.getColumnConstraints()).addConstraint(DbColumnConstraint.NOT_NULL).autoInc(c.isAutoInc()).defaultValue(c.getDefaultValue()).build());
                continue;
            }
            columns.add(c);
        }
        return builder.addColumn(columns).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createTable(DbEntity entity) throws DatabaseEngineException {
        block17: {
            entity = this.injectNotNullIfMissing(entity);
            ArrayList<String> createTable = new ArrayList<String>();
            createTable.add("CREATE TABLE");
            createTable.add(StringUtils.quotize(entity.getName()));
            ArrayList<String> columns = new ArrayList<String>();
            List<String> pkFields = entity.getPkFields();
            for (DbColumn c : entity.getColumns()) {
                ArrayList<String> column = new ArrayList<String>();
                column.add(StringUtils.quotize(c.getName()));
                column.add(this.translateType(c));
                if (pkFields.contains(c.getName()) && !c.getColumnConstraints().contains((Object)DbColumnConstraint.NOT_NULL)) {
                    c.getColumnConstraints().add(DbColumnConstraint.NOT_NULL);
                }
                for (DbColumnConstraint cc : c.getColumnConstraints()) {
                    column.add(cc.translate());
                }
                if (c.isDefaultValueSet()) {
                    column.add("DEFAULT");
                    column.add(this.translate(c.getDefaultValue()));
                }
                columns.add(org.apache.commons.lang.StringUtils.join(column, (String)" "));
            }
            createTable.add("(" + org.apache.commons.lang.StringUtils.join(columns, (String)", ") + ")");
            String createTableStatement = org.apache.commons.lang.StringUtils.join(createTable, (String)" ");
            this.logger.trace(createTableStatement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(createTableStatement);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().startsWith(NAME_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.TABLE_ALREADY_EXISTS), ex);
                    break block17;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addPrimaryKey(DbEntity entity) throws DatabaseEngineException {
        block15: {
            if (entity.getPkFields().size() == 0) {
                return;
            }
            ArrayList<String> pks = new ArrayList<String>();
            for (String pk : entity.getPkFields()) {
                pks.add(StringUtils.quotize(pk));
            }
            String pkName = StringUtils.md5(String.format("PK_%s", entity.getName()), this.properties.getMaxIdentifierSize());
            ArrayList<String> statement = new ArrayList<String>();
            statement.add("ALTER TABLE");
            statement.add(StringUtils.quotize(entity.getName()));
            statement.add("ADD CONSTRAINT");
            statement.add(StringUtils.quotize(pkName));
            statement.add("PRIMARY KEY");
            statement.add("(" + org.apache.commons.lang.StringUtils.join(pks, (String)", ") + ")");
            String addPrimaryKey = org.apache.commons.lang.StringUtils.join(statement, (String)" ");
            this.logger.trace(addPrimaryKey);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(addPrimaryKey);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().startsWith(TABLE_CAN_ONLY_HAVE_ONE_PRIMARY_KEY) || ex.getSQLState().startsWith(CONSTRAINT_NAME_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "'{}' already has a primary key", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.PRIMARY_KEY_ALREADY_EXISTS), ex);
                    break block15;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addIndexes(DbEntity entity) throws DatabaseEngineException {
        List<DbIndex> indexes = entity.getIndexes();
        for (DbIndex index : indexes) {
            ArrayList<String> createIndex = new ArrayList<String>();
            createIndex.add("CREATE");
            if (index.isUnique()) {
                createIndex.add("UNIQUE");
            }
            createIndex.add("INDEX");
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<String> columnsForName = new ArrayList<String>();
            for (String column : index.getColumns()) {
                columns.add(StringUtils.quotize(column));
                columnsForName.add(column);
            }
            String idxName = StringUtils.md5(String.format("%s_%s_IDX", entity.getName(), org.apache.commons.lang.StringUtils.join(columnsForName, (String)"_")), this.properties.getMaxIdentifierSize());
            createIndex.add(StringUtils.quotize(idxName));
            createIndex.add("ON");
            createIndex.add(StringUtils.quotize(entity.getName()));
            createIndex.add("(" + org.apache.commons.lang.StringUtils.join(columns, (String)", ") + ")");
            String statement = org.apache.commons.lang.StringUtils.join(createIndex, (String)" ");
            this.logger.trace(statement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(statement);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().startsWith(INDEX_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)idxName);
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.INDEX_ALREADY_EXISTS), ex);
                    continue;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s == null) continue;
                    s.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void addSequences(DbEntity entity) throws DatabaseEngineException {
    }

    @Override
    protected MappedEntity createPreparedStatementForInserts(DbEntity entity) throws DatabaseEngineException {
        ArrayList<String> insertInto = new ArrayList<String>();
        insertInto.add("INSERT INTO");
        insertInto.add(StringUtils.quotize(entity.getName()));
        ArrayList<String> insertIntoWithAutoInc = new ArrayList<String>();
        insertIntoWithAutoInc.add("INSERT INTO");
        insertIntoWithAutoInc.add(StringUtils.quotize(entity.getName()));
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> columnsWithAutoInc = new ArrayList<String>();
        ArrayList<String> valuesWithAutoInc = new ArrayList<String>();
        for (DbColumn column : entity.getColumns()) {
            columnsWithAutoInc.add(StringUtils.quotize(column.getName()));
            valuesWithAutoInc.add("?");
            if (column.isAutoInc()) continue;
            columns.add(StringUtils.quotize(column.getName()));
            values.add("?");
        }
        insertInto.add("(" + org.apache.commons.lang.StringUtils.join(columns, (String)", ") + ")");
        insertInto.add("VALUES (" + org.apache.commons.lang.StringUtils.join(values, (String)", ") + ")");
        insertIntoWithAutoInc.add("(" + org.apache.commons.lang.StringUtils.join(columnsWithAutoInc, (String)", ") + ")");
        insertIntoWithAutoInc.add("VALUES (" + org.apache.commons.lang.StringUtils.join(valuesWithAutoInc, (String)", ") + ")");
        String statement = org.apache.commons.lang.StringUtils.join(insertInto, (String)" ");
        String statementWithAutoInt = org.apache.commons.lang.StringUtils.join(insertIntoWithAutoInc, (String)" ");
        this.logger.trace(statement);
        try {
            PreparedStatement ps = this.conn.prepareStatement(statement, 1);
            PreparedStatement psWithAutoInc = this.conn.prepareStatement(statementWithAutoInt);
            return new MappedEntity().setInsert(ps).setInsertWithAutoInc(psWithAutoInc);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
    }

    @Override
    protected void dropSequences(DbEntity entity) throws DatabaseEngineException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropTable(DbEntity entity) throws DatabaseEngineException {
        block13: {
            Statement drop = null;
            try {
                drop = this.conn.createStatement();
                String query = String.format("DROP TABLE %s CASCADE", StringUtils.quotize(entity.getName()));
                this.logger.trace(query);
                drop.executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().startsWith(TABLE_OR_VIEW_DOES_NOT_EXIST)) {
                    this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.TABLE_DOES_NOT_EXIST), ex);
                    break block13;
                }
                throw new DatabaseEngineException("Error dropping table", ex);
            }
            finally {
                try {
                    if (drop != null) {
                        drop.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropColumn(DbEntity entity, String ... columns) throws DatabaseEngineException {
        block14: {
            Statement drop = null;
            try {
                drop = this.conn.createStatement();
                for (String column : columns) {
                    String query = String.format("ALTER TABLE %s DROP COLUMN %s", StringUtils.quotize(entity.getName()), StringUtils.quotize(column));
                    this.logger.trace(query);
                    drop.executeUpdate(query);
                }
            }
            catch (SQLException ex) {
                if (ex.getSQLState().startsWith(TABLE_OR_VIEW_DOES_NOT_EXIST)) {
                    this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.COLUMN_DOES_NOT_EXIST), ex);
                    break block14;
                }
                throw new DatabaseEngineException("Error dropping column", ex);
            }
            finally {
                try {
                    if (drop != null) {
                        drop.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void addColumn(DbEntity entity, DbColumn ... columns) throws DatabaseEngineException {
        Statement s = null;
        try {
            s = this.conn.createStatement();
            for (DbColumn c : columns) {
                ArrayList<String> column = new ArrayList<String>();
                column.add(StringUtils.quotize(c.getName()));
                column.add(this.translateType(c));
                for (DbColumnConstraint cc : c.getColumnConstraints()) {
                    column.add(cc.translate());
                }
                if (c.isDefaultValueSet()) {
                    column.add("DEFAULT");
                    column.add(this.translate(c.getDefaultValue()));
                }
                String query = String.format("ALTER TABLE %s ADD COLUMN %s", StringUtils.quotize(entity.getName()), org.apache.commons.lang.StringUtils.join(column, (String)" "));
                this.logger.trace(query);
                s.executeUpdate(query);
            }
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    @Override
    protected String translateType(DbColumn c) throws DatabaseEngineException {
        return this.translator.translate(c);
    }

    @Override
    public synchronized Long persist(String name, EntityEntry entry) throws DatabaseEngineException {
        return this.persist(name, entry, true);
    }

    @Override
    public synchronized Long persist(String name, EntityEntry entry, boolean useAutoInc) throws DatabaseEngineException {
        ResultSet generatedKeys = null;
        try {
            this.getConnection();
            MappedEntity me = (MappedEntity)this.entities.get(name);
            if (me == null) {
                throw new DatabaseEngineException(String.format("Unknown entity '%s'", name));
            }
            PreparedStatement ps = null;
            ps = useAutoInc ? ((MappedEntity)this.entities.get(name)).getInsert() : ((MappedEntity)this.entities.get(name)).getInsertWithAutoInc();
            this.entityToPreparedStatement(me.getEntity(), ps, entry, useAutoInc);
            ps.execute();
            long ret = 0L;
            if (useAutoInc) {
                generatedKeys = ps.getGeneratedKeys();
                if (generatedKeys.next()) {
                    ret = generatedKeys.getLong(1);
                }
                generatedKeys.close();
            }
            Long l = ret == 0L ? null : Long.valueOf(ret);
            return l;
        }
        catch (Exception ex) {
            throw new DatabaseEngineException("Something went wrong persisting the entity", ex);
        }
        finally {
            try {
                if (generatedKeys != null) {
                    generatedKeys.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing result set.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addFks(DbEntity entity) throws DatabaseEngineException {
        for (DbFk fk : entity.getFks()) {
            ArrayList<String> quotizedLocalColumns = new ArrayList<String>();
            for (String string : fk.getLocalColumns()) {
                quotizedLocalColumns.add(StringUtils.quotize(string));
            }
            ArrayList<String> quotizedForeignColumns = new ArrayList<String>();
            for (String s3 : fk.getForeignColumns()) {
                quotizedForeignColumns.add(StringUtils.quotize(s3));
            }
            String string = StringUtils.quotize(entity.getName());
            String quotizedLocalColumnsSting = org.apache.commons.lang.StringUtils.join(quotizedLocalColumns, (String)", ");
            String quotizedForeignColumnsString = org.apache.commons.lang.StringUtils.join(quotizedForeignColumns, (String)", ");
            String alterTable = String.format("ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s (%s)", string, StringUtils.quotize(StringUtils.md5("FK_" + string + quotizedLocalColumnsSting + quotizedForeignColumnsString, this.properties.getMaxIdentifierSize())), quotizedLocalColumnsSting, StringUtils.quotize(fk.getForeignTable()), quotizedForeignColumnsString);
            Statement alterTableStmt = null;
            try {
                alterTableStmt = this.conn.createStatement();
                this.logger.trace(alterTable);
                alterTableStmt.executeUpdate(alterTable);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().equals(CONSTRAINT_NAME_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "Foreign key for table '{}' already exists. Error code: {}.", (Object)entity.getName(), (Object)ex.getSQLState());
                    continue;
                }
                throw new DatabaseEngineException(String.format("Could not add Foreign Key to entity %s. Error code: %s.", entity.getName(), ex.getSQLState()), ex);
            }
            finally {
                try {
                    if (alterTableStmt == null) continue;
                    alterTableStmt.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean checkConnection(Connection conn) {
        Statement s = null;
        try {
            s = conn.createStatement();
            s.executeQuery("select 1");
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.logger.debug("Connection is down.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    @Override
    protected ResultIterator createResultIterator(Statement statement, String sql) throws DatabaseEngineException {
        return new H2ResultIterator(statement, sql);
    }

    @Override
    protected ResultIterator createResultIterator(PreparedStatement ps) throws DatabaseEngineException {
        return new H2ResultIterator(ps);
    }
}

