/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml.result;

import com.feedzai.commons.sql.abstraction.dml.result.ResultColumn;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineRuntimeException;
import java.io.ObjectInputStream;
import java.sql.Blob;

public class DB2ResultColumn
extends ResultColumn {
    public DB2ResultColumn(String name, Object val) {
        super(name, val);
    }

    @Override
    protected Object processObject(Object o) {
        if (o instanceof Blob) {
            try {
                return new ObjectInputStream(((Blob)o).getBinaryStream()).readObject();
            }
            catch (Exception e) {
                throw new DatabaseEngineRuntimeException("Error eagerly converting blob to object", e);
            }
        }
        return o;
    }

    @Override
    public Boolean toBoolean() {
        if (this.isNull()) {
            return null;
        }
        String val = this.val.toString();
        if (val.equals("1")) {
            return true;
        }
        if (val.equals("0")) {
            return false;
        }
        throw new DatabaseEngineRuntimeException(val + " is not a boolean type");
    }

    @Override
    public <T> T toBlob() throws DatabaseEngineRuntimeException {
        if (this.isNull()) {
            return null;
        }
        return (T)this.val;
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        if (this.val instanceof byte[]) {
            return new String((byte[])this.val);
        }
        return super.toString();
    }
}

