/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.impl;

import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnType;
import com.feedzai.commons.sql.abstraction.ddl.DbEntity;
import com.feedzai.commons.sql.abstraction.ddl.DbFk;
import com.feedzai.commons.sql.abstraction.ddl.DbIndex;
import com.feedzai.commons.sql.abstraction.dml.dialect.Dialect;
import com.feedzai.commons.sql.abstraction.dml.result.PostgreSqlResultIterator;
import com.feedzai.commons.sql.abstraction.dml.result.ResultColumn;
import com.feedzai.commons.sql.abstraction.dml.result.ResultIterator;
import com.feedzai.commons.sql.abstraction.engine.AbstractDatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.AbstractTranslator;
import com.feedzai.commons.sql.abstraction.engine.ConnectionResetException;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineDriver;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.engine.MappedEntity;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.engine.handler.OperationFault;
import com.feedzai.commons.sql.abstraction.engine.impl.PostgreSqlTranslator;
import com.feedzai.commons.sql.abstraction.entry.EntityEntry;
import com.feedzai.commons.sql.abstraction.util.StringUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.postgresql.util.PGobject;

public class PostgreSqlEngine
extends AbstractDatabaseEngine {
    protected static final String POSTGRESQL_DRIVER = DatabaseEngineDriver.POSTGRES.driver();
    public static final String NAME_ALREADY_EXISTS = "42P07";
    public static final String TABLE_CAN_ONLY_HAVE_ONE_PRIMARY_KEY = "42P16";
    public static final String TABLE_OR_VIEW_DOES_NOT_EXIST = "42P01";
    public static final String CONSTRAINT_NAME_ALREADY_EXISTS = "42710";

    public PostgreSqlEngine(PdbProperties properties) throws DatabaseEngineException {
        super(POSTGRESQL_DRIVER, properties, Dialect.POSTGRESQL);
    }

    @Override
    protected int entityToPreparedStatement(DbEntity entity, PreparedStatement ps, EntityEntry entry, boolean useAutoInc) throws DatabaseEngineException {
        int i = 1;
        for (DbColumn column : entity.getColumns()) {
            if (column.isAutoInc() && useAutoInc) continue;
            try {
                Object val = column.isDefaultValueSet() && !entry.containsKey(column.getName()) ? column.getDefaultValue().getConstant() : entry.get(column.getName());
                switch (column.getDbColumnType()) {
                    case BLOB: {
                        ps.setBytes(i, this.objectToArray(val));
                        break;
                    }
                    case CLOB: {
                        if (val == null) {
                            ps.setNull(i, 2005);
                            break;
                        }
                        if (val instanceof String) {
                            ps.setString(i, (String)val);
                            break;
                        }
                        throw new DatabaseEngineException("Cannot convert " + val.getClass().getSimpleName() + " to String. CLOB columns only accept Strings.");
                    }
                    case JSON: {
                        ps.setObject(i, this.getJSONValue((String)val));
                        break;
                    }
                    default: {
                        ps.setObject(i, val);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                throw new DatabaseEngineException("Error while mapping variables to database", ex);
            }
            ++i;
        }
        return i - 1;
    }

    @Override
    public synchronized void setParameter(String name, int index, Object param, DbColumnType paramType) throws DatabaseEngineException, ConnectionResetException {
        if (paramType == DbColumnType.JSON) {
            param = this.getJSONValue((String)param);
        }
        super.setParameter(name, index, param);
    }

    private Object getJSONValue(String val) throws DatabaseEngineException {
        try {
            PGobject dataObject = new PGobject();
            dataObject.setType("jsonb");
            dataObject.setValue(val);
            return dataObject;
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Error while mapping variables to database, value = " + val, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createTable(DbEntity entity) throws DatabaseEngineException {
        block16: {
            ArrayList<String> createTable = new ArrayList<String>();
            createTable.add("CREATE TABLE");
            createTable.add(StringUtils.quotize(entity.getName()));
            ArrayList<String> columns = new ArrayList<String>();
            for (DbColumn c : entity.getColumns()) {
                ArrayList<String> column = new ArrayList<String>();
                column.add(StringUtils.quotize(c.getName()));
                column.add(this.translateType(c));
                for (DbColumnConstraint cc : c.getColumnConstraints()) {
                    column.add(cc.translate());
                }
                if (c.isDefaultValueSet()) {
                    column.add("DEFAULT");
                    column.add(this.translate(c.getDefaultValue()));
                }
                columns.add(org.apache.commons.lang3.StringUtils.join(column, (String)" "));
            }
            createTable.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
            String createTableStatement = org.apache.commons.lang3.StringUtils.join(createTable, (String)" ");
            this.logger.trace(createTableStatement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(createTableStatement);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().startsWith(NAME_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.TABLE_ALREADY_EXISTS), ex);
                    break block16;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addPrimaryKey(DbEntity entity) throws DatabaseEngineException {
        block15: {
            if (entity.getPkFields().size() == 0) {
                return;
            }
            ArrayList<String> pks = new ArrayList<String>();
            for (String pk : entity.getPkFields()) {
                pks.add(StringUtils.quotize(pk));
            }
            String pkName = StringUtils.md5(String.format("PK_%s", entity.getName()), this.properties.getMaxIdentifierSize());
            ArrayList<String> statement = new ArrayList<String>();
            statement.add("ALTER TABLE");
            statement.add(StringUtils.quotize(entity.getName()));
            statement.add("ADD CONSTRAINT");
            statement.add(StringUtils.quotize(pkName));
            statement.add("PRIMARY KEY");
            statement.add("(" + org.apache.commons.lang3.StringUtils.join(pks, (String)", ") + ")");
            String addPrimaryKey = org.apache.commons.lang3.StringUtils.join(statement, (String)" ");
            this.logger.trace(addPrimaryKey);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(addPrimaryKey);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().startsWith(TABLE_CAN_ONLY_HAVE_ONE_PRIMARY_KEY)) {
                    this.logger.debug(dev, "'{}' already has a primary key", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.PRIMARY_KEY_ALREADY_EXISTS), ex);
                    break block15;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addIndexes(DbEntity entity) throws DatabaseEngineException {
        List<DbIndex> indexes = entity.getIndexes();
        for (DbIndex index : indexes) {
            ArrayList<String> createIndex = new ArrayList<String>();
            createIndex.add("CREATE");
            if (index.isUnique()) {
                createIndex.add("UNIQUE");
            }
            createIndex.add("INDEX");
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<String> columnsForName = new ArrayList<String>();
            for (String column : index.getColumns()) {
                columns.add(StringUtils.quotize(column));
                columnsForName.add(column);
            }
            String idxName = StringUtils.md5(String.format("%s_%s_IDX", entity.getName(), org.apache.commons.lang3.StringUtils.join(columnsForName, (String)"_")), this.properties.getMaxIdentifierSize());
            createIndex.add(StringUtils.quotize(idxName));
            createIndex.add("ON");
            createIndex.add(StringUtils.quotize(entity.getName()));
            createIndex.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
            String statement = org.apache.commons.lang3.StringUtils.join(createIndex, (String)" ");
            this.logger.trace(statement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(statement);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().startsWith(NAME_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)idxName);
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.INDEX_ALREADY_EXISTS), ex);
                    continue;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s == null) continue;
                    s.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void addSequences(DbEntity entity) throws DatabaseEngineException {
    }

    @Override
    protected MappedEntity createPreparedStatementForInserts(DbEntity entity) throws DatabaseEngineException {
        ArrayList<String> insertInto = new ArrayList<String>();
        insertInto.add("INSERT INTO");
        insertInto.add(StringUtils.quotize(entity.getName()));
        ArrayList<String> insertIntoWithAutoInc = new ArrayList<String>();
        insertIntoWithAutoInc.add("INSERT INTO");
        insertIntoWithAutoInc.add(StringUtils.quotize(entity.getName()));
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> columnsWithAutoInc = new ArrayList<String>();
        ArrayList<String> valuesWithAutoInc = new ArrayList<String>();
        String returning = null;
        for (DbColumn column : entity.getColumns()) {
            columnsWithAutoInc.add(StringUtils.quotize(column.getName()));
            valuesWithAutoInc.add("?");
            if (column.isAutoInc()) {
                returning = column.getName();
                continue;
            }
            columns.add(StringUtils.quotize(column.getName()));
            values.add("?");
        }
        insertInto.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
        insertInto.add("VALUES (" + org.apache.commons.lang3.StringUtils.join(values, (String)", ") + ")");
        insertIntoWithAutoInc.add("(" + org.apache.commons.lang3.StringUtils.join(columnsWithAutoInc, (String)", ") + ")");
        insertIntoWithAutoInc.add("VALUES (" + org.apache.commons.lang3.StringUtils.join(valuesWithAutoInc, (String)", ") + ")");
        ArrayList<String> insertIntoReturn = new ArrayList<String>(insertInto);
        insertIntoReturn.add(String.format("RETURNING %s", returning == null ? "0" : StringUtils.quotize(returning)));
        insertIntoWithAutoInc.add(String.format("RETURNING %s", returning == null ? "0" : StringUtils.quotize(returning)));
        String insertStatement = org.apache.commons.lang3.StringUtils.join(insertInto, (String)" ");
        String insertReturnStatement = org.apache.commons.lang3.StringUtils.join(insertIntoReturn, (String)" ");
        String statementWithAutoInt = org.apache.commons.lang3.StringUtils.join(insertIntoWithAutoInc, (String)" ");
        this.logger.trace(insertStatement);
        this.logger.trace(insertReturnStatement);
        try {
            PreparedStatement ps = this.conn.prepareStatement(insertStatement);
            PreparedStatement psReturn = this.conn.prepareStatement(insertReturnStatement);
            PreparedStatement psWithAutoInc = this.conn.prepareStatement(statementWithAutoInt);
            return new MappedEntity().setInsert(ps).setInsertReturning(psReturn).setInsertWithAutoInc(psWithAutoInc).setAutoIncColumn(returning);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
    }

    @Override
    protected void dropSequences(DbEntity entity) throws DatabaseEngineException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropTable(DbEntity entity) throws DatabaseEngineException {
        block13: {
            Statement drop = null;
            try {
                drop = this.conn.createStatement();
                String query = String.format("DROP TABLE %s CASCADE", StringUtils.quotize(entity.getName()));
                this.logger.trace(query);
                drop.executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().startsWith(TABLE_OR_VIEW_DOES_NOT_EXIST)) {
                    this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.TABLE_DOES_NOT_EXIST), ex);
                    break block13;
                }
                throw new DatabaseEngineException("Error dropping table", ex);
            }
            finally {
                try {
                    if (drop != null) {
                        drop.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropColumn(DbEntity entity, String ... columns) throws DatabaseEngineException {
        block14: {
            Statement drop = null;
            ArrayList<String> removeColumns = new ArrayList<String>();
            removeColumns.add("ALTER TABLE");
            removeColumns.add(StringUtils.quotize(entity.getName()));
            ArrayList<String> cols = new ArrayList<String>();
            for (String col : columns) {
                cols.add("DROP COLUMN " + StringUtils.quotize(col));
            }
            removeColumns.add(org.apache.commons.lang3.StringUtils.join(cols, (String)","));
            try {
                drop = this.conn.createStatement();
                String query = org.apache.commons.lang3.StringUtils.join(removeColumns, (String)" ");
                this.logger.trace(query);
                drop.executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith(TABLE_OR_VIEW_DOES_NOT_EXIST)) {
                    this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                    break block14;
                }
                throw new DatabaseEngineException("Error dropping column", ex);
            }
            finally {
                try {
                    if (drop != null) {
                        drop.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void addColumn(DbEntity entity, DbColumn ... columns) throws DatabaseEngineException {
        ArrayList<String> addColumns = new ArrayList<String>();
        addColumns.add("ALTER TABLE");
        addColumns.add(StringUtils.quotize(entity.getName()));
        ArrayList<String> cols = new ArrayList<String>();
        for (DbColumn c : columns) {
            ArrayList<String> column = new ArrayList<String>();
            column.add("ADD COLUMN");
            column.add(StringUtils.quotize(c.getName()));
            column.add(this.translateType(c));
            for (DbColumnConstraint cc : c.getColumnConstraints()) {
                column.add(cc.translate());
            }
            if (c.isDefaultValueSet()) {
                column.add("DEFAULT");
                column.add(this.translate(c.getDefaultValue()));
            }
            cols.add(org.apache.commons.lang3.StringUtils.join(column, (String)" "));
        }
        addColumns.add(org.apache.commons.lang3.StringUtils.join(cols, (String)","));
        String addColumnsStatement = org.apache.commons.lang3.StringUtils.join(addColumns, (String)" ");
        this.logger.trace(addColumnsStatement);
        Statement s = null;
        try {
            s = this.conn.createStatement();
            s.executeUpdate(addColumnsStatement);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    @Override
    protected String translateType(DbColumn c) throws DatabaseEngineException {
        return this.translator.translate(c);
    }

    @Override
    public Class<? extends AbstractTranslator> getTranslatorClass() {
        return PostgreSqlTranslator.class;
    }

    @Override
    public synchronized Long persist(String name, EntityEntry entry) throws DatabaseEngineException {
        return this.persist(name, entry, true);
    }

    @Override
    public synchronized Long persist(String name, EntityEntry entry, boolean useAutoInc) throws DatabaseEngineException {
        ResultSet generatedKeys = null;
        try {
            this.getConnection();
            MappedEntity me = (MappedEntity)this.entities.get(name);
            if (me == null) {
                throw new DatabaseEngineException(String.format("Unknown entity '%s'", name));
            }
            PreparedStatement ps = useAutoInc ? me.getInsertReturning() : me.getInsertWithAutoInc();
            this.entityToPreparedStatement(me.getEntity(), ps, entry, useAutoInc);
            generatedKeys = ps.executeQuery();
            long ret = 0L;
            if (useAutoInc) {
                if (generatedKeys.next()) {
                    ret = generatedKeys.getLong(1);
                }
            } else if (this.hasIdentityColumn(me.getEntity())) {
                List<Map<String, ResultColumn>> q = this.query("select max(\"" + me.getAutoIncColumn() + "\") from \"" + name + "\"");
                if (!q.isEmpty()) {
                    ret = q.get(0).values().iterator().next().toLong();
                }
                this.executeUpdateSilently("ALTER SEQUENCE \"" + name + "_" + me.getAutoIncColumn() + "_seq\" RESTART " + (ret + 1L));
                ret = 0L;
            }
            Long l = ret == 0L ? null : Long.valueOf(ret);
            return l;
        }
        catch (Exception ex) {
            throw new DatabaseEngineException("Something went wrong persisting the entity", ex);
        }
        finally {
            try {
                if (generatedKeys != null) {
                    generatedKeys.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing result set.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addFks(DbEntity entity) throws DatabaseEngineException {
        for (DbFk fk : entity.getFks()) {
            ArrayList<String> quotizedLocalColumns = new ArrayList<String>();
            for (String string : fk.getLocalColumns()) {
                quotizedLocalColumns.add(StringUtils.quotize(string));
            }
            ArrayList<String> quotizedForeignColumns = new ArrayList<String>();
            for (String s3 : fk.getForeignColumns()) {
                quotizedForeignColumns.add(StringUtils.quotize(s3));
            }
            String string = StringUtils.quotize(entity.getName());
            String quotizedLocalColumnsSting = org.apache.commons.lang3.StringUtils.join(quotizedLocalColumns, (String)", ");
            String quotizedForeignColumnsString = org.apache.commons.lang3.StringUtils.join(quotizedForeignColumns, (String)", ");
            String alterTable = String.format("ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s (%s)", string, StringUtils.quotize(StringUtils.md5("FK_" + string + quotizedLocalColumnsSting + quotizedForeignColumnsString, this.properties.getMaxIdentifierSize())), quotizedLocalColumnsSting, StringUtils.quotize(fk.getForeignTable()), quotizedForeignColumnsString);
            Statement alterTableStmt = null;
            try {
                alterTableStmt = this.conn.createStatement();
                this.logger.trace(alterTable);
                alterTableStmt.executeUpdate(alterTable);
            }
            catch (SQLException ex) {
                if (ex.getSQLState().equals(CONSTRAINT_NAME_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "Foreign key for table '{}' already exists. Error code: {}.", (Object)entity.getName(), (Object)ex.getSQLState());
                    continue;
                }
                throw new DatabaseEngineException(String.format("Could not add Foreign Key to entity %s. Error code: %s.", entity.getName(), ex.getSQLState()), ex);
            }
            finally {
                try {
                    if (alterTableStmt == null) continue;
                    alterTableStmt.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean checkConnection(Connection conn) {
        Statement s = null;
        try {
            s = conn.createStatement();
            s.executeQuery("select 1");
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.logger.debug("Connection is down.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized Map<String, DbColumnType> getMetadata(String name) throws DatabaseEngineException {
        LinkedHashMap<String, DbColumnType> metaMap = new LinkedHashMap<String, DbColumnType>();
        ResultSet rsColumns = null;
        try {
            this.getConnection();
            DatabaseMetaData meta = this.conn.getMetaData();
            rsColumns = meta.getColumns(null, this.getSchema(), name, null);
            while (rsColumns.next()) {
                metaMap.put(rsColumns.getString("COLUMN_NAME"), this.toPdbType(rsColumns.getInt("DATA_TYPE"), rsColumns.getString("TYPE_NAME")));
            }
            LinkedHashMap<String, DbColumnType> linkedHashMap = metaMap;
            return linkedHashMap;
        }
        catch (Exception e) {
            throw new DatabaseEngineException("Could not get metadata", e);
        }
        finally {
            try {
                if (rsColumns != null) {
                    rsColumns.close();
                }
            }
            catch (Exception a) {
                this.logger.trace("Error closing result set.", (Throwable)a);
            }
        }
    }

    @Override
    protected DbColumnType toPdbType(int type, String typeName) {
        DbColumnType pdbType = super.toPdbType(type, typeName);
        if (pdbType == DbColumnType.UNMAPPED && typeName.equals("jsonb")) {
            pdbType = DbColumnType.JSON;
        }
        return pdbType;
    }

    @Override
    protected ResultIterator createResultIterator(Statement statement, String sql) throws DatabaseEngineException {
        return new PostgreSqlResultIterator(statement, sql);
    }

    @Override
    protected ResultIterator createResultIterator(PreparedStatement ps) throws DatabaseEngineException {
        return new PostgreSqlResultIterator(ps);
    }
}

