/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.impl;

import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnType;
import com.feedzai.commons.sql.abstraction.ddl.DbEntity;
import com.feedzai.commons.sql.abstraction.ddl.DbFk;
import com.feedzai.commons.sql.abstraction.ddl.DbIndex;
import com.feedzai.commons.sql.abstraction.dml.dialect.Dialect;
import com.feedzai.commons.sql.abstraction.dml.result.OracleResultIterator;
import com.feedzai.commons.sql.abstraction.dml.result.ResultIterator;
import com.feedzai.commons.sql.abstraction.engine.AbstractDatabaseEngine;
import com.feedzai.commons.sql.abstraction.engine.AbstractTranslator;
import com.feedzai.commons.sql.abstraction.engine.ConnectionResetException;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineDriver;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineException;
import com.feedzai.commons.sql.abstraction.engine.MappedEntity;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.engine.handler.OperationFault;
import com.feedzai.commons.sql.abstraction.engine.impl.OracleTranslator;
import com.feedzai.commons.sql.abstraction.entry.EntityEntry;
import com.feedzai.commons.sql.abstraction.util.StringUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import oracle.jdbc.OraclePreparedStatement;

public class OracleEngine
extends AbstractDatabaseEngine {
    protected static final String ORACLE_DRIVER = DatabaseEngineDriver.ORACLE.driver();
    public static final String NAME_ALREADY_EXISTS = "ORA-00955";
    public static final String TABLE_CAN_ONLY_HAVE_ONE_PRIMARY_KEY = "ORA-02260";
    public static final String SEQUENCE_DOES_NOT_EXIST = "ORA-02289";
    public static final String TABLE_OR_VIEW_DOES_NOT_EXIST = "ORA-00942";
    public static final String FOREIGN_ALREADY_EXISTS = "ORA-02275";
    private static final Double ZERO = 0.0;

    public OracleEngine(PdbProperties properties) throws DatabaseEngineException {
        super(ORACLE_DRIVER, properties, Dialect.ORACLE);
    }

    @Override
    public synchronized void setParameters(String name, Object ... params) throws DatabaseEngineException, ConnectionResetException {
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.ensureNoUnderflow(params[i]);
        }
        super.setParameters(name, params);
    }

    @Override
    public synchronized void setParameter(String name, int index, Object param) throws DatabaseEngineException, ConnectionResetException {
        super.setParameter(name, index, this.ensureNoUnderflow(param));
    }

    @Override
    protected int entityToPreparedStatement(DbEntity entity, PreparedStatement ps, EntityEntry entry, boolean useAutoInc) throws DatabaseEngineException {
        int i = 1;
        for (DbColumn column : entity.getColumns()) {
            if (column.isAutoInc() && useAutoInc) continue;
            try {
                Object val = column.isDefaultValueSet() && !entry.containsKey(column.getName()) ? column.getDefaultValue().getConstant() : entry.get(column.getName());
                switch (column.getDbColumnType()) {
                    case BLOB: {
                        ps.setBytes(i, this.objectToArray(val));
                        break;
                    }
                    case JSON: 
                    case CLOB: {
                        if (val == null) {
                            ps.setNull(i, 2005);
                            break;
                        }
                        if (val instanceof String) {
                            ((OraclePreparedStatement)ps).setStringForClob(i, (String)val);
                            break;
                        }
                        throw new DatabaseEngineException("Cannot convert " + val.getClass().getSimpleName() + " to String. CLOB columns only accept Strings.");
                    }
                    case BOOLEAN: {
                        Boolean b = (Boolean)val;
                        if (b == null) {
                            ps.setObject(i, null);
                            break;
                        }
                        if (b.booleanValue()) {
                            ps.setObject(i, "1");
                            break;
                        }
                        ps.setObject(i, "0");
                        break;
                    }
                    case DOUBLE: {
                        this.setParameterValues(ps, i, val);
                        break;
                    }
                    default: {
                        ps.setObject(i, this.ensureNoUnderflow(val));
                        break;
                    }
                }
            }
            catch (Exception ex) {
                throw new DatabaseEngineException("Error while mapping variables to database", ex);
            }
            ++i;
        }
        return i - 1;
    }

    @Override
    protected void setParameterValues(PreparedStatement ps, int index, Object param) throws SQLException {
        if (param instanceof byte[]) {
            ps.setBytes(index, (byte[])param);
        } else if (!(param instanceof Double)) {
            ps.setObject(index, param);
        } else {
            OraclePreparedStatement orclPs = (OraclePreparedStatement)ps;
            orclPs.setBinaryDouble(index, ((Double)this.ensureNoUnderflow(param)).doubleValue());
        }
    }

    private Object ensureNoUnderflow(Object val) {
        Double dblVal;
        if (val instanceof Double && Math.abs(dblVal = (Double)val) <= 1.0E-131) {
            val = ZERO;
        }
        return val;
    }

    @Override
    public void connect() throws Exception {
        super.connect();
        if (this.properties.getSchema() != null && this.properties.getSchema().length() > 0 && !this.properties.getUsername().equals(this.properties.getSchema())) {
            Statement stmt = this.conn.createStatement();
            stmt.execute("ALTER SESSION SET CURRENT_SCHEMA=" + this.properties.getSchema());
            stmt.close();
        }
    }

    @Override
    protected void setTransactionIsolation() throws SQLException {
        int isolation = this.properties.getIsolationLevel();
        if (isolation == 1) {
            isolation = 2;
        }
        if (isolation == 4) {
            isolation = 8;
        }
        this.conn.setTransactionIsolation(isolation);
    }

    @Override
    public Class<? extends AbstractTranslator> getTranslatorClass() {
        return OracleTranslator.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createTable(DbEntity entity) throws DatabaseEngineException {
        block16: {
            ArrayList<String> createTable = new ArrayList<String>();
            createTable.add("CREATE TABLE");
            createTable.add(StringUtils.quotize(entity.getName()));
            ArrayList<String> columns = new ArrayList<String>();
            for (DbColumn c : entity.getColumns()) {
                ArrayList<String> column = new ArrayList<String>();
                column.add(StringUtils.quotize(c.getName()));
                column.add(this.translateType(c));
                if (c.isDefaultValueSet() && !c.getDbColumnType().equals((Object)DbColumnType.BOOLEAN)) {
                    column.add("DEFAULT");
                    column.add(this.translate(c.getDefaultValue()));
                }
                for (DbColumnConstraint cc : c.getColumnConstraints()) {
                    column.add(cc.translate());
                }
                columns.add(org.apache.commons.lang3.StringUtils.join(column, (String)" "));
            }
            createTable.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
            createTable.add("SEGMENT CREATION IMMEDIATE");
            String createTableStatement = org.apache.commons.lang3.StringUtils.join(createTable, (String)" ");
            this.logger.trace(createTableStatement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(createTableStatement);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith(NAME_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.TABLE_ALREADY_EXISTS), ex);
                    break block16;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addPrimaryKey(DbEntity entity) throws DatabaseEngineException {
        block15: {
            if (entity.getPkFields().size() == 0) {
                return;
            }
            ArrayList<String> pks = new ArrayList<String>();
            for (String pk : entity.getPkFields()) {
                pks.add(StringUtils.quotize(pk));
            }
            String pkName = StringUtils.md5(String.format("PK_%s", entity.getName()), this.properties.getMaxIdentifierSize());
            ArrayList<String> statement = new ArrayList<String>();
            statement.add("ALTER TABLE");
            statement.add(StringUtils.quotize(entity.getName()));
            statement.add("ADD CONSTRAINT");
            statement.add(StringUtils.quotize(pkName));
            statement.add("PRIMARY KEY");
            statement.add("(" + org.apache.commons.lang3.StringUtils.join(pks, (String)", ") + ")");
            String addPrimaryKey = org.apache.commons.lang3.StringUtils.join(statement, (String)" ");
            this.logger.trace(addPrimaryKey);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(addPrimaryKey);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith(TABLE_CAN_ONLY_HAVE_ONE_PRIMARY_KEY)) {
                    this.logger.debug(dev, "'{}' already has a primary key", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.PRIMARY_KEY_ALREADY_EXISTS), ex);
                    break block15;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s != null) {
                        s.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addIndexes(DbEntity entity) throws DatabaseEngineException {
        List<DbIndex> indexes = entity.getIndexes();
        for (DbIndex index : indexes) {
            ArrayList<String> createIndex = new ArrayList<String>();
            createIndex.add("CREATE");
            if (index.isUnique()) {
                createIndex.add("UNIQUE");
            }
            createIndex.add("INDEX");
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<String> columnsForName = new ArrayList<String>();
            for (String column : index.getColumns()) {
                columns.add(StringUtils.quotize(column));
                columnsForName.add(column);
            }
            String idxName = StringUtils.md5(String.format("%s_%s_IDX", entity.getName(), org.apache.commons.lang3.StringUtils.join(columnsForName, (String)"_")), this.properties.getMaxIdentifierSize());
            createIndex.add(StringUtils.quotize(idxName));
            createIndex.add("ON");
            createIndex.add(StringUtils.quotize(entity.getName()));
            createIndex.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
            String statement = org.apache.commons.lang3.StringUtils.join(createIndex, (String)" ");
            this.logger.trace(statement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(statement);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith(NAME_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)idxName);
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.INDEX_ALREADY_EXISTS), ex);
                    continue;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s == null) continue;
                    s.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addSequences(DbEntity entity) throws DatabaseEngineException {
        for (DbColumn column : entity.getColumns()) {
            if (!column.isAutoInc()) continue;
            String sequenceName = StringUtils.md5(String.format("%s_%s_SEQ", entity.getName(), column.getName()), this.properties.getMaxIdentifierSize());
            ArrayList<String> createSequence = new ArrayList<String>();
            createSequence.add("CREATE SEQUENCE ");
            createSequence.add(StringUtils.quotize(sequenceName));
            createSequence.add("MINVALUE 0");
            createSequence.add("MAXVALUE");
            switch (column.getDbColumnType()) {
                case INT: {
                    createSequence.add(String.format("%d", Integer.MAX_VALUE));
                    break;
                }
                case LONG: {
                    createSequence.add(String.format("%d", Long.MAX_VALUE));
                    break;
                }
                default: {
                    throw new DatabaseEngineException("Auto incrementation is only supported on INT and LONG");
                }
            }
            createSequence.add("START WITH 1");
            createSequence.add("INCREMENT BY 1");
            String statement = org.apache.commons.lang3.StringUtils.join(createSequence, (String)" ");
            this.logger.trace(statement);
            Statement s = null;
            try {
                s = this.conn.createStatement();
                s.executeUpdate(statement);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith(NAME_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "'{}' is already defined", (Object)sequenceName);
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.SEQUENCE_ALREADY_EXISTS), ex);
                    continue;
                }
                throw new DatabaseEngineException("Something went wrong handling statement", ex);
            }
            finally {
                try {
                    if (s == null) continue;
                    s.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected MappedEntity createPreparedStatementForInserts(DbEntity entity) throws DatabaseEngineException {
        ArrayList<String> insertInto = new ArrayList<String>();
        insertInto.add("INSERT INTO");
        insertInto.add(StringUtils.quotize(entity.getName()));
        ArrayList<String> insertIntoWithAutoInc = new ArrayList<String>();
        insertIntoWithAutoInc.add("INSERT INTO");
        insertIntoWithAutoInc.add(StringUtils.quotize(entity.getName()));
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> columnsWithAutoInc = new ArrayList<String>();
        ArrayList<String> valuesWithAutoInc = new ArrayList<String>();
        String returning = null;
        for (DbColumn column : entity.getColumns()) {
            columnsWithAutoInc.add(StringUtils.quotize(column.getName()));
            valuesWithAutoInc.add("?");
            columns.add(StringUtils.quotize(column.getName()));
            if (column.isAutoInc()) {
                String sequenceName = StringUtils.md5(String.format("%s_%s_SEQ", entity.getName(), column.getName()), this.properties.getMaxIdentifierSize());
                values.add(String.format("%s.nextval", StringUtils.quotize(sequenceName)));
                returning = column.getName();
                continue;
            }
            values.add("?");
        }
        insertInto.add("(" + org.apache.commons.lang3.StringUtils.join(columns, (String)", ") + ")");
        insertInto.add("VALUES (" + org.apache.commons.lang3.StringUtils.join(values, (String)", ") + ")");
        insertIntoWithAutoInc.add("(" + org.apache.commons.lang3.StringUtils.join(columnsWithAutoInc, (String)", ") + ")");
        insertIntoWithAutoInc.add("VALUES (" + org.apache.commons.lang3.StringUtils.join(valuesWithAutoInc, (String)", ") + ")");
        ArrayList<String> insertIntoReturn = new ArrayList<String>(insertInto);
        if (returning != null) {
            insertIntoReturn.add(String.format("RETURNING %s INTO ?", StringUtils.quotize(returning)));
        } else {
            insertIntoReturn.add("RETURNING 0 INTO ?");
        }
        String insertStatement = org.apache.commons.lang3.StringUtils.join(insertInto, (String)" ");
        String insertReturnStatement = org.apache.commons.lang3.StringUtils.join(insertIntoReturn, (String)" ");
        String insertWithAutoInc = org.apache.commons.lang3.StringUtils.join(insertIntoWithAutoInc, (String)" ");
        this.logger.trace(insertStatement);
        this.logger.trace(insertReturnStatement);
        try {
            PreparedStatement ps = this.conn.prepareStatement(insertStatement);
            PreparedStatement psReturn = this.conn.prepareStatement(insertReturnStatement);
            PreparedStatement psWithAutoInc = this.conn.prepareStatement(insertWithAutoInc);
            return new MappedEntity().setInsert(ps).setInsertReturning(psReturn).setInsertWithAutoInc(psWithAutoInc).setAutoIncColumn(returning);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropSequences(DbEntity entity) throws DatabaseEngineException {
        for (DbColumn column : entity.getColumns()) {
            if (!column.isAutoInc()) continue;
            String sequenceName = StringUtils.md5(String.format("%s_%s_SEQ", entity.getName(), column.getName()), this.properties.getMaxIdentifierSize());
            String stmt = String.format("DROP SEQUENCE %s", StringUtils.quotize(sequenceName));
            Statement drop = null;
            try {
                drop = this.conn.createStatement();
                this.logger.trace(stmt);
                drop.executeUpdate(stmt);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith(SEQUENCE_DOES_NOT_EXIST)) {
                    this.logger.debug(dev, "Sequence '{}' does not exist", (Object)sequenceName);
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.SEQUENCE_DOES_NOT_EXIST), ex);
                    continue;
                }
                throw new DatabaseEngineException("Error dropping sequence", ex);
            }
            finally {
                try {
                    if (drop == null) continue;
                    drop.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropTable(DbEntity entity) throws DatabaseEngineException {
        block13: {
            Statement drop = null;
            try {
                drop = this.conn.createStatement();
                String query = String.format("DROP TABLE %s CASCADE CONSTRAINTS", StringUtils.quotize(entity.getName()));
                this.logger.trace(query);
                drop.executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith(TABLE_OR_VIEW_DOES_NOT_EXIST)) {
                    this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.TABLE_DOES_NOT_EXIST), ex);
                    break block13;
                }
                throw new DatabaseEngineException("Error dropping table", ex);
            }
            finally {
                try {
                    if (drop != null) {
                        drop.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropColumn(DbEntity entity, String ... columns) throws DatabaseEngineException {
        block14: {
            Statement drop = null;
            ArrayList<String> removeColumns = new ArrayList<String>();
            removeColumns.add("ALTER TABLE");
            removeColumns.add(StringUtils.quotize(entity.getName()));
            removeColumns.add("DROP");
            ArrayList<String> cols = new ArrayList<String>();
            for (String col : columns) {
                cols.add(StringUtils.quotize(col));
            }
            removeColumns.add("( " + org.apache.commons.lang3.StringUtils.join(cols, (String)",") + " )");
            try {
                drop = this.conn.createStatement();
                String query = org.apache.commons.lang3.StringUtils.join(removeColumns, (String)" ");
                this.logger.trace(query);
                drop.executeUpdate(query);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith(TABLE_OR_VIEW_DOES_NOT_EXIST)) {
                    this.logger.debug(dev, "Table '{}' does not exist", (Object)entity.getName());
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.COLUMN_DOES_NOT_EXIST), ex);
                    break block14;
                }
                throw new DatabaseEngineException("Error dropping column", ex);
            }
            finally {
                try {
                    if (drop != null) {
                        drop.close();
                    }
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void addColumn(DbEntity entity, DbColumn ... columns) throws DatabaseEngineException {
        ArrayList<String> addColumns = new ArrayList<String>();
        addColumns.add("ALTER TABLE");
        addColumns.add(StringUtils.quotize(entity.getName()));
        addColumns.add("ADD");
        ArrayList<String> cols = new ArrayList<String>();
        for (DbColumn c : columns) {
            ArrayList<String> column = new ArrayList<String>();
            column.add(StringUtils.quotize(c.getName()));
            column.add(this.translateType(c));
            if (c.isDefaultValueSet() && !c.getDbColumnType().equals((Object)DbColumnType.BOOLEAN)) {
                column.add("DEFAULT");
                column.add(this.translate(c.getDefaultValue()));
            }
            for (DbColumnConstraint cc : c.getColumnConstraints()) {
                column.add(cc.translate());
            }
            cols.add(org.apache.commons.lang3.StringUtils.join(column, (String)" "));
        }
        addColumns.add("( " + org.apache.commons.lang3.StringUtils.join(cols, (String)",") + " )");
        String addColumnsStatement = org.apache.commons.lang3.StringUtils.join(addColumns, (String)" ");
        this.logger.trace(addColumnsStatement);
        Statement s = null;
        try {
            s = this.conn.createStatement();
            s.executeUpdate(addColumnsStatement);
        }
        catch (SQLException ex) {
            throw new DatabaseEngineException("Something went wrong handling statement", ex);
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    @Override
    protected String translateType(DbColumn c) throws DatabaseEngineException {
        return this.translator.translate(c);
    }

    @Override
    public synchronized Long persist(String name, EntityEntry entry) throws DatabaseEngineException {
        return this.persist(name, entry, true);
    }

    @Override
    public synchronized Long persist(String name, EntityEntry entry, boolean useAutoInc) throws DatabaseEngineException {
        ResultSet generatedKeys = null;
        try {
            PreparedStatement ps;
            this.getConnection();
            MappedEntity me = (MappedEntity)this.entities.get(name);
            if (me == null) {
                throw new DatabaseEngineException(String.format("Unknown entity '%s'", name));
            }
            if (useAutoInc) {
                ps = me.getInsertReturning();
                this.synchronizeSequence(name, me);
            } else {
                ps = me.getInsertWithAutoInc();
            }
            int i = this.entityToPreparedStatement(me.getEntity(), ps, entry, useAutoInc);
            if (useAutoInc) {
                ((OraclePreparedStatement)ps).registerReturnParameter(i + 1, 2);
            }
            ps.execute();
            long ret = 0L;
            if (useAutoInc) {
                generatedKeys = ((OraclePreparedStatement)ps).getReturnResultSet();
                if (generatedKeys.next()) {
                    ret = generatedKeys.getLong(1);
                }
                generatedKeys.close();
            } else {
                me.setSequenceDirty(true);
            }
            Long l = ret == 0L ? null : Long.valueOf(ret);
            return l;
        }
        catch (Exception ex) {
            throw new DatabaseEngineException("Something went wrong persisting the entity", ex);
        }
        finally {
            try {
                if (generatedKeys != null) {
                    generatedKeys.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing result set.", (Throwable)e);
            }
        }
    }

    private void synchronizeSequence(String name, MappedEntity me) {
        if (!me.isSequenceDirty()) {
            return;
        }
        String sequenceName = StringUtils.md5(String.format("%s_%s_SEQ", name, me.getAutoIncColumn()), this.properties.getMaxIdentifierSize());
        ImmutableList touch = ImmutableList.of((Object)String.format("SELECT %s.NEXTVAL FROM DUAL", StringUtils.quotize(sequenceName)), (Object)String.format("ALTER SEQUENCE %s INCREMENT BY -1", StringUtils.quotize(sequenceName)), (Object)String.format("SELECT %s.NEXTVAL FROM DUAL", StringUtils.quotize(sequenceName)), (Object)String.format("ALTER SEQUENCE %s INCREMENT BY 1", StringUtils.quotize(sequenceName)));
        this.silentlyExecuteStatements((List<String>)touch);
        String sqlDiff = String.format("SELECT (SELECT MAX(%s) FROM %s) - %s.CURRVAL FROM DUAL", StringUtils.quotize(me.getAutoIncColumn()), StringUtils.quotize(name), StringUtils.quotize(sequenceName));
        this.logger.trace(dev, "{}", (Object)sqlDiff);
        try (Statement statementDiffSeq = this.conn.createStatement();
             ResultSet diff = statementDiffSeq.executeQuery(sqlDiff);){
            if (diff.next()) {
                long diffLong;
                long l = diffLong = diff.getObject(1) != null ? diff.getLong(1) : -1L;
                if (diffLong > 0L) {
                    ImmutableList stmts = ImmutableList.of((Object)String.format("ALTER SEQUENCE %s INCREMENT BY %s", StringUtils.quotize(sequenceName), diffLong), (Object)String.format("SELECT %s.NEXTVAL FROM DUAL", StringUtils.quotize(sequenceName)), (Object)String.format("ALTER SEQUENCE %s INCREMENT BY 1", StringUtils.quotize(sequenceName)));
                    this.silentlyExecuteStatements((List<String>)stmts);
                }
            }
            me.setSequenceDirty(false);
        }
        catch (SQLException e) {
            this.logger.debug("Error querying.", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.debug("Error closing resources.", (Throwable)e);
        }
    }

    private void silentlyExecuteStatements(List<String> stmts) {
        for (String stmt : stmts) {
            try {
                Statement statementSyncSequence = this.conn.createStatement();
                Throwable throwable = null;
                try {
                    this.logger.trace(dev, "{}", (Object)stmt);
                    statementSyncSequence.execute(stmt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statementSyncSequence == null) continue;
                    if (throwable != null) {
                        try {
                            statementSyncSequence.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    statementSyncSequence.close();
                }
            }
            catch (SQLException e) {
                this.logger.debug("Error executing statement.", (Throwable)e);
            }
            catch (Exception e) {
                this.logger.debug("Error closing statement.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addFks(DbEntity entity) throws DatabaseEngineException {
        for (DbFk fk : entity.getFks()) {
            ArrayList<String> quotizedLocalColumns = new ArrayList<String>();
            for (String string : fk.getLocalColumns()) {
                quotizedLocalColumns.add(StringUtils.quotize(string));
            }
            ArrayList<String> quotizedForeignColumns = new ArrayList<String>();
            for (String s3 : fk.getForeignColumns()) {
                quotizedForeignColumns.add(StringUtils.quotize(s3));
            }
            String string = StringUtils.quotize(entity.getName());
            String quotizedLocalColumnsSting = org.apache.commons.lang3.StringUtils.join(quotizedLocalColumns, (String)", ");
            String quotizedForeignColumnsString = org.apache.commons.lang3.StringUtils.join(quotizedForeignColumns, (String)", ");
            String alterTable = String.format("ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s (%s)", string, StringUtils.quotize(StringUtils.md5("FK_" + string + quotizedLocalColumnsSting + quotizedForeignColumnsString, this.properties.getMaxIdentifierSize())), quotizedLocalColumnsSting, StringUtils.quotize(fk.getForeignTable()), quotizedForeignColumnsString);
            Statement alterTableStmt = null;
            try {
                alterTableStmt = this.conn.createStatement();
                this.logger.trace(alterTable);
                alterTableStmt.executeUpdate(alterTable);
            }
            catch (SQLException ex) {
                if (ex.getMessage().startsWith(FOREIGN_ALREADY_EXISTS)) {
                    this.logger.debug(dev, "Foreign key for table '{}' already exists. Error code: {}.", new Object[]{entity.getName(), ex.getMessage(), ex});
                    this.handleOperation(new OperationFault(entity.getName(), OperationFault.Type.FOREIGN_KEY_ALREADY_EXISTS), ex);
                    continue;
                }
                throw new DatabaseEngineException(String.format("Could not add Foreign Key to entity %s. Error code: %s.", entity.getName(), ex.getMessage()), ex);
            }
            finally {
                try {
                    if (alterTableStmt == null) continue;
                    alterTableStmt.close();
                }
                catch (Exception e) {
                    this.logger.trace("Error closing statement.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean checkConnection(Connection conn) {
        Statement s = null;
        try {
            s = conn.createStatement();
            s.executeQuery("select 1 from dual");
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.logger.debug("Connection is down.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception e) {
                this.logger.trace("Error closing statement.", (Throwable)e);
            }
        }
    }

    @Override
    protected String getSchema() {
        return Optional.ofNullable(super.getSchema()).orElse(this.properties.getUsername());
    }

    @Override
    public synchronized Map<String, DbColumnType> getMetadata(String name) throws DatabaseEngineException {
        Map<String, DbColumnType> metaMap = super.getMetadata(name);
        Statement s = null;
        ResultSet rsColumns = null;
        try {
            Object columnName;
            this.getConnection();
            s = this.conn.createStatement();
            rsColumns = s.executeQuery(String.format("SELECT COLUMN_NAME, DATA_TYPE, DATA_PRECISION FROM ALL_TAB_COLS WHERE TABLE_NAME = '%s' AND OWNER = UPPER('%s')", name, this.properties.getProperty("pdb.username")));
            while (rsColumns.next()) {
                String dataPrecision;
                DbColumnType value;
                columnName = rsColumns.getString("COLUMN_NAME");
                if (((String)columnName).toUpperCase().startsWith("SYS_") || (value = this.toPdbType((dataPrecision = rsColumns.getString("DATA_PRECISION")) == null ? rsColumns.getString("DATA_TYPE") : rsColumns.getString("DATA_TYPE") + dataPrecision)) == DbColumnType.UNMAPPED) continue;
                metaMap.put((String)columnName, value);
            }
            columnName = metaMap;
            return columnName;
        }
        catch (Exception e) {
            throw new DatabaseEngineException("Could not get metadata", e);
        }
        finally {
            try {
                if (rsColumns != null) {
                    rsColumns.close();
                }
            }
            catch (Exception a) {
                this.logger.trace("Error closing result set.", (Throwable)a);
            }
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception a) {
                this.logger.trace("Error closing statement.", (Throwable)a);
            }
        }
    }

    private DbColumnType toPdbType(String type) {
        Preconditions.checkNotNull((Object)type, (Object)"Type cannot be null.");
        switch (type) {
            case "NUMBER": {
                return DbColumnType.INT;
            }
            case "CHAR": {
                return DbColumnType.BOOLEAN;
            }
            case "FLOAT": 
            case "FLOAT126": 
            case "BINARY_DOUBLE": {
                return DbColumnType.DOUBLE;
            }
            case "LONG": 
            case "NUMBER19": {
                return DbColumnType.LONG;
            }
            case "VARCHAR2": 
            case "NVARCHAR2": {
                return DbColumnType.STRING;
            }
            case "CLOB": {
                return DbColumnType.CLOB;
            }
            case "BLOB": {
                return DbColumnType.BLOB;
            }
        }
        return DbColumnType.UNMAPPED;
    }

    @Override
    protected ResultIterator createResultIterator(Statement statement, String sql) throws DatabaseEngineException {
        return new OracleResultIterator(statement, sql);
    }

    @Override
    protected ResultIterator createResultIterator(PreparedStatement ps) throws DatabaseEngineException {
        return new OracleResultIterator(ps);
    }
}

