/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine;

import com.feedzai.commons.sql.abstraction.ddl.AlterColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DropPrimaryKey;
import com.feedzai.commons.sql.abstraction.ddl.Rename;
import com.feedzai.commons.sql.abstraction.dml.Between;
import com.feedzai.commons.sql.abstraction.dml.Coalesce;
import com.feedzai.commons.sql.abstraction.dml.Delete;
import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.dml.Function;
import com.feedzai.commons.sql.abstraction.dml.Join;
import com.feedzai.commons.sql.abstraction.dml.K;
import com.feedzai.commons.sql.abstraction.dml.Literal;
import com.feedzai.commons.sql.abstraction.dml.Modulo;
import com.feedzai.commons.sql.abstraction.dml.Name;
import com.feedzai.commons.sql.abstraction.dml.Query;
import com.feedzai.commons.sql.abstraction.dml.RepeatDelimiter;
import com.feedzai.commons.sql.abstraction.dml.Truncate;
import com.feedzai.commons.sql.abstraction.dml.Update;
import com.feedzai.commons.sql.abstraction.dml.View;
import com.feedzai.commons.sql.abstraction.engine.configuration.PdbProperties;
import com.feedzai.commons.sql.abstraction.util.StringUtils;
import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractTranslator {
    @Inject
    protected PdbProperties properties;
    @Inject
    protected Injector injector;

    protected void inject(Expression ... objs) {
        for (Expression o : objs) {
            if (o == null) continue;
            this.injector.injectMembers((Object)o);
        }
    }

    protected void inject(Collection<? extends Expression> objs) {
        for (Expression expression : objs) {
            if (expression == null) continue;
            this.injector.injectMembers((Object)expression);
        }
    }

    protected String join(Collection<?> list, String delimiter) {
        return Joiner.on((String)delimiter).join(list);
    }

    public String translate(Name n) {
        String name = n.getName();
        String environment = n.getEnvironment();
        ArrayList<String> res = new ArrayList<String>();
        if (environment != null) {
            res.add(StringUtils.quotize(environment, this.translateEscape()) + "." + (n.isQuote() ? StringUtils.quotize(name, this.translateEscape()) : name));
        } else {
            res.add(n.isQuote() ? StringUtils.quotize(name, this.translateEscape()) : name);
        }
        if (n.getOrdering() != null) {
            res.add(n.getOrdering());
        }
        if (n.isIsNull()) {
            res.add("IS NULL");
        }
        if (n.isIsNotNull()) {
            res.add("IS NOT NULL");
        }
        if (n.isEnclosed()) {
            return "(" + org.apache.commons.lang3.StringUtils.join(res, (String)" ") + ")";
        }
        return org.apache.commons.lang3.StringUtils.join(res, (String)" ");
    }

    public String translate(Between b) {
        Expression and = b.getAnd();
        Expression column = b.getColumn();
        this.inject(and, column);
        String modifier = "BETWEEN";
        if (b.isNot()) {
            modifier = "NOT " + modifier;
        }
        String result = String.format("%s %s %s", column.translate(), modifier, and.translate());
        if (b.isEnclosed()) {
            result = "(" + result + ")";
        }
        return result;
    }

    public String translate(Coalesce c) {
        Expression[] alternative = c.getAlternative();
        Expression exp = c.getExp();
        this.inject(exp);
        Object[] alts = new String[alternative.length];
        int i = 0;
        for (Expression e : alternative) {
            this.inject(e);
            alts[i] = e.translate();
            ++i;
        }
        return String.format("COALESCE(%s, " + Joiner.on((String)", ").join(alts) + ")", exp.translate());
    }

    public String translate(Delete d) {
        Expression table = d.getTable();
        Expression where = d.getWhere();
        this.inject(table, where);
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("DELETE FROM");
        temp.add(table.translate());
        if (where != null) {
            temp.add("WHERE");
            temp.add(where.translate());
        }
        return Joiner.on((String)" ").join(temp);
    }

    public String translate(Join j) {
        String join = j.getJoin();
        Expression joinExpr = j.getJoinExpr();
        Expression joinTable = j.getJoinTable();
        this.inject(joinExpr, joinTable);
        if (joinTable.isAliased()) {
            return String.format("%s %s %s ON (%s)", join, joinTable.translate(), StringUtils.quotize(joinTable.getAlias(), this.translateEscape()), joinExpr.translate());
        }
        return String.format("%s %s ON (%s)", join, joinTable.translate(), joinExpr.translate());
    }

    public String translate(K k) {
        Object o = k.getConstant();
        String result = o != null ? (!k.isQuote() ? o.toString() : (o instanceof String ? StringUtils.singleQuotize(StringUtils.escapeSql((String)o)) : (o instanceof Boolean ? ((Boolean)o != false ? this.translateTrue() : this.translateFalse()) : o.toString()))) : "NULL";
        return k.isEnclosed() ? "(" + result + ")" : result;
    }

    public String translate(Literal l) {
        return l.getLiteral().toString();
    }

    public String translate(Truncate t) {
        Expression table = t.getTable();
        this.inject(table);
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("TRUNCATE TABLE");
        temp.add(table.translate());
        return this.join(temp, " ");
    }

    public String translate(Update u) {
        List<Expression> columns = u.getColumns();
        Expression table = u.getTable();
        Expression where = u.getWhere();
        this.inject(table, where);
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("UPDATE");
        temp.add(table.translate());
        if (table.isAliased()) {
            temp.add(StringUtils.quotize(table.getAlias(), this.translateEscape()));
        }
        temp.add("SET");
        ArrayList<String> setTranslations = new ArrayList<String>();
        for (Expression e : columns) {
            this.inject(e);
            setTranslations.add(e.translate());
        }
        temp.add(this.join(setTranslations, ", "));
        if (where != null) {
            temp.add("WHERE");
            temp.add(where.translate());
        }
        return this.join(temp, " ");
    }

    public abstract String translateEscape();

    public abstract String translateTrue();

    public abstract String translateFalse();

    public abstract String translate(AlterColumn var1);

    public abstract String translate(DropPrimaryKey var1);

    public abstract String translate(Function var1);

    public abstract String translate(Modulo var1);

    public abstract String translate(Rename var1);

    public abstract String translate(RepeatDelimiter var1);

    public abstract String translate(Query var1);

    public abstract String translate(View var1);

    public abstract String translate(DbColumn var1);
}

