/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.ddl;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class DbFk
implements Serializable {
    private final List<String> localColumns;
    private final List<String> foreignColumns;
    private final String foreignTable;

    private DbFk(List<String> localColumns, List<String> foreignColumns, String foreignTable) {
        this.localColumns = localColumns;
        this.foreignColumns = foreignColumns;
        this.foreignTable = foreignTable;
    }

    public List<String> getLocalColumns() {
        return this.localColumns;
    }

    public List<String> getForeignColumns() {
        return this.foreignColumns;
    }

    public String getForeignTable() {
        return this.foreignTable;
    }

    public static class Builder
    implements com.feedzai.commons.sql.abstraction.util.Builder<DbFk>,
    Serializable {
        private final List<String> localColumns = new ArrayList<String>();
        private final List<String> foreignColumns = new ArrayList<String>();
        private String foreignTable = null;

        public Builder foreignTable(String foreignTable) {
            this.foreignTable = foreignTable;
            return this;
        }

        public Builder addColumn(String ... columns) {
            return this.addColumns(Arrays.asList(columns));
        }

        public Builder addColumns(Collection<String> columns) {
            this.localColumns.addAll(columns);
            return this;
        }

        public Builder addForeignColumn(String ... foreignColumns) {
            return this.addForeignColumns(Arrays.asList(foreignColumns));
        }

        public Builder addForeignColumns(Collection<String> columns) {
            this.foreignColumns.addAll(columns);
            return this;
        }

        @Override
        public DbFk build() {
            return new DbFk((List)ImmutableList.copyOf(this.localColumns), (List)ImmutableList.copyOf(this.foreignColumns), this.foreignTable);
        }
    }
}

