/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml.result;

import com.feedzai.commons.sql.abstraction.dml.result.ResultColumn;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineRuntimeException;
import java.io.ObjectInputStream;
import oracle.sql.BLOB;

public class OracleResultColumn
extends ResultColumn {
    public OracleResultColumn(String name, Object val) {
        super(name, val);
    }

    @Override
    public Boolean toBoolean() {
        if (this.isNull()) {
            return null;
        }
        String val = this.val.toString();
        if (val.equals("1")) {
            return true;
        }
        if (val.equals("0")) {
            return false;
        }
        throw new DatabaseEngineRuntimeException(val + " is not a boolean type");
    }

    @Override
    public <T> T toBlob() throws DatabaseEngineRuntimeException {
        if (this.isNull()) {
            return null;
        }
        if (!(this.val instanceof BLOB)) {
            throw new DatabaseEngineRuntimeException("Column is not a BLOB type");
        }
        try {
            ObjectInputStream ois = new ObjectInputStream(((BLOB)this.val).getBinaryStream());
            return (T)ois.readObject();
        }
        catch (Exception e) {
            throw new DatabaseEngineRuntimeException("Error converting blob to object", e);
        }
    }
}

