/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.engine.impl;

import com.feedzai.commons.sql.abstraction.ddl.AlterColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DropPrimaryKey;
import com.feedzai.commons.sql.abstraction.ddl.Rename;
import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.dml.Join;
import com.feedzai.commons.sql.abstraction.dml.Modulo;
import com.feedzai.commons.sql.abstraction.dml.Name;
import com.feedzai.commons.sql.abstraction.dml.Query;
import com.feedzai.commons.sql.abstraction.dml.RepeatDelimiter;
import com.feedzai.commons.sql.abstraction.dml.Update;
import com.feedzai.commons.sql.abstraction.dml.View;
import com.feedzai.commons.sql.abstraction.engine.AbstractTranslator;
import com.feedzai.commons.sql.abstraction.engine.DatabaseEngineRuntimeException;
import com.feedzai.commons.sql.abstraction.util.StringUtils;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class SqlServerTranslator
extends AbstractTranslator {
    @Override
    public String translate(AlterColumn ac) {
        DbColumn column = ac.getColumn();
        Expression table = ac.getTable();
        Name name = new Name(column.getName());
        this.inject(table, name);
        StringBuilder sb = new StringBuilder("ALTER TABLE ").append(table.translate()).append(" ALTER COLUMN ").append(name.translate()).append(" ").append(this.translate(column)).append(" ");
        List trans = Lists.transform(column.getColumnConstraints(), (Function)new Function<DbColumnConstraint, Object>(){

            public Object apply(DbColumnConstraint input) {
                return input.translate();
            }
        });
        sb.append(Joiner.on((String)" ").join((Iterable)trans));
        return sb.toString();
    }

    @Override
    public String translate(DropPrimaryKey dpk) {
        Expression table = dpk.getTable();
        this.inject(table);
        if (!(table instanceof Name)) {
            throw new DatabaseEngineRuntimeException("DropPrimaryKey must receive a Name object");
        }
        String tableName = ((Name)table).getName();
        String pkName = StringUtils.md5(String.format("PK_%s", tableName), this.properties.getMaxIdentifierSize());
        return String.format("ALTER TABLE %s DROP CONSTRAINT %s", table.translate(), StringUtils.quotize(pkName));
    }

    @Override
    public String translate(com.feedzai.commons.sql.abstraction.dml.Function f) {
        String function = f.getFunction();
        Expression exp = f.getExp();
        this.inject(exp);
        String expTranslated = "";
        if (exp != null) {
            expTranslated = exp.translate();
        }
        if ("STDDEV".equals(function)) {
            function = "STDEV";
        }
        if ("AVG".equals(function)) {
            expTranslated = String.format("CONVERT(DOUBLE PRECISION, %s)", expTranslated);
        }
        if (f.isUDF() && this.properties.isSchemaSet()) {
            return this.properties.getSchema() + "." + function + "(" + expTranslated + ")";
        }
        return function + "(" + expTranslated + ")";
    }

    @Override
    public String translate(Join j) {
        String join = j.getJoin();
        Expression joinExpr = j.getJoinExpr();
        Expression joinTable = j.getJoinTable();
        this.inject(joinExpr, joinTable);
        if (joinTable.isAliased()) {
            return String.format("%s %s %s %s ON (%s)", join, joinTable.translate(), StringUtils.quotize(joinTable.getAlias()), joinTable.isWithNoLock() ? " WITH(NOLOCK)" : "", joinExpr.translate());
        }
        return String.format("%s %s %s ON (%s)", join, joinTable.translate(), joinTable.isWithNoLock() ? " WITH(NOLOCK)" : "", joinExpr.translate());
    }

    @Override
    public String translate(Modulo m) {
        Expression dividend = m.getDividend();
        Expression divisor = m.getDivisor();
        this.inject(dividend, divisor);
        String result = String.format("%s %% %s", dividend.translate(), divisor.translate());
        return m.isEnclosed() ? "(" + result + ")" : result;
    }

    @Override
    public String translate(Rename r) {
        Expression oldName = r.getOldName();
        Expression newName = r.getNewName();
        this.inject(oldName, newName);
        return String.format("sp_rename %s, %s", oldName.translate(), newName.translate());
    }

    @Override
    public String translate(RepeatDelimiter rd) {
        String delimiter = rd.getDelimiter();
        List<Expression> exps = rd.getExpressions();
        ArrayList<String> all = new ArrayList<String>();
        Expression expression = exps.get(0);
        this.inject(expression);
        if (" / ".equals(delimiter)) {
            all.add(String.format("CONVERT(DOUBLE PRECISION, %s)", expression.translate()));
        } else {
            all.add(expression.translate());
        }
        for (int i = 1; i < exps.size(); ++i) {
            Expression nthExpression = exps.get(i);
            this.inject(nthExpression);
            all.add(nthExpression.translate());
        }
        if (rd.isEnclosed()) {
            return "(" + org.apache.commons.lang.StringUtils.join(all, (String)delimiter) + ")";
        }
        return org.apache.commons.lang.StringUtils.join(all, (String)delimiter);
    }

    @Override
    public String translate(Query q) {
        List<Expression> fromColumns = q.getFromColumns();
        List<Expression> groupbyColumns = q.getGroupbyColumns();
        List<Expression> orderbyColumns = q.getOrderbyColumns();
        List<Expression> selectColumns = q.getSelectColumns();
        Expression having = q.getHaving();
        Expression where = q.getWhere();
        this.inject(fromColumns);
        this.inject(groupbyColumns);
        this.inject(orderbyColumns);
        this.inject(selectColumns);
        this.inject(having, where);
        ArrayList<String> query = new ArrayList<String>();
        query.add("SELECT" + (q.isDistinct() ? " DISTINCT" : "") + (q.getLimit() <= 0 || q.getOffset() > 0 ? "" : " TOP " + q.getLimit()));
        ArrayList<String> querySelectColumns = new ArrayList<String>();
        for (Expression expression : selectColumns) {
            if (expression instanceof Query) {
                querySelectColumns.add("(" + expression.translate() + (!expression.isAliased() ? ")" : ") AS " + StringUtils.quotize(expression.getAlias())));
                continue;
            }
            querySelectColumns.add(expression.translate() + (!expression.isAliased() ? "" : " AS " + StringUtils.quotize(expression.getAlias())));
        }
        query.add(this.join(querySelectColumns, ", "));
        if (!fromColumns.isEmpty()) {
            query.add("FROM");
            ArrayList<String> queryFromColumns = new ArrayList<String>();
            for (Expression dbe : fromColumns) {
                ArrayList<String> insideFrom = new ArrayList<String>();
                if (dbe instanceof Query) {
                    insideFrom.add("(" + dbe.translate() + (!dbe.isAliased() ? ")" : ") " + StringUtils.quotize(dbe.getAlias())));
                } else {
                    insideFrom.add(dbe.translate() + (!dbe.isAliased() ? "" : " " + StringUtils.quotize(dbe.getAlias())) + (dbe.isWithNoLock() ? " WITH(NOLOCK)" : ""));
                }
                List<Join> joins = dbe.getJoins();
                if (!joins.isEmpty()) {
                    for (Join j : joins) {
                        this.inject(j);
                        insideFrom.add(j.translate());
                    }
                }
                queryFromColumns.add(this.join(insideFrom, " "));
            }
            query.add(this.join(queryFromColumns, ", "));
        }
        if (where != null) {
            query.add("WHERE");
            query.add(where.translate());
        }
        if (!groupbyColumns.isEmpty()) {
            query.add("GROUP BY");
            ArrayList<String> queryGroupByColumns = new ArrayList<String>();
            for (Expression column : groupbyColumns) {
                queryGroupByColumns.add(column.translate());
            }
            query.add(this.join(queryGroupByColumns, ", "));
        }
        if (having != null) {
            query.add("HAVING");
            query.add(having.translate());
        }
        if (q.getOffset() <= 0 && !orderbyColumns.isEmpty()) {
            query.add("ORDER BY");
            ArrayList<String> queryOrderByColumns = new ArrayList<String>();
            for (Expression column : orderbyColumns) {
                queryOrderByColumns.add(column.translate());
            }
            query.add(this.join(queryOrderByColumns, ", "));
        }
        String finalQuery = this.join(query, " ");
        if (q.getLimit() > 0 && q.getOffset() > 0) {
            if (!orderbyColumns.isEmpty()) {
                ArrayList<String> queryOrderByColumns = new ArrayList<String>();
                for (Expression column : orderbyColumns) {
                    queryOrderByColumns.add(column.translate());
                }
                String string = this.join(queryOrderByColumns, ", ");
                finalQuery = String.format("SELECT * FROM (SELECT ROW_NUMBER() OVER(ORDER BY %s) rnum ,offlim.* FROM (%s) offlim) offlim WHERE rnum <= %d and rnum > %d ORDER BY %s", string, finalQuery, q.getLimit() + q.getOffset(), q.getOffset(), string);
            } else {
                finalQuery = String.format("SELECT * FROM (SELECT ROW_NUMBER() OVER(ORDER BY (SELECT 1)) rnum ,offlim.* FROM (%s) offlim) offlim WHERE rnum <= %d and rnum > %d", finalQuery, q.getLimit() + q.getOffset(), q.getOffset());
            }
        }
        return q.isEnclosed() ? "(" + finalQuery + ")" : finalQuery;
    }

    @Override
    public String translate(View v) {
        Expression as = v.getAs();
        String name = v.getName();
        this.inject(as);
        ArrayList<String> res = new ArrayList<String>();
        res.add("CREATE VIEW");
        res.add(StringUtils.quotize(name));
        res.add("AS " + as.translate());
        return this.join(res, " ");
    }

    @Override
    public String translate(DbColumn c) {
        switch (c.getDbColumnType()) {
            case BOOLEAN: {
                return "BIT";
            }
            case DOUBLE: {
                return "DOUBLE PRECISION";
            }
            case INT: {
                return "INT";
            }
            case LONG: {
                return "BIGINT";
            }
            case STRING: {
                return String.format("NVARCHAR(%s)", c.isSizeSet() ? c.getSize().toString() : this.properties.getProperty("pdb.varchar_size"));
            }
            case CLOB: {
                return "NVARCHAR(MAX)";
            }
            case BLOB: {
                if (this.properties.isMaxBlobSizeSet()) {
                    return String.format("VARBINARY(%s)", this.properties.getProperty("pdb.max_blob_size"));
                }
                return String.format("VARBINARY(MAX)", new Object[0]);
            }
        }
        throw new DatabaseEngineRuntimeException(String.format("Mapping not found for '%s'. Please report this error.", new Object[]{c.getDbColumnType()}));
    }

    @Override
    public String translate(Update u) {
        List<Expression> columns = u.getColumns();
        Expression table = u.getTable();
        Expression where = u.getWhere();
        this.inject(table, where);
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("UPDATE");
        if (table.isAliased()) {
            temp.add(StringUtils.quotize(table.getAlias(), this.translateEscape()));
        } else {
            temp.add(table.translate());
        }
        temp.add("SET");
        ArrayList<String> setTranslations = new ArrayList<String>();
        for (Expression e : columns) {
            this.inject(e);
            setTranslations.add(e.translate());
        }
        temp.add(this.join(setTranslations, ", "));
        temp.add("FROM");
        temp.add(table.translate());
        if (table.isAliased()) {
            temp.add(StringUtils.quotize(table.getAlias()));
        }
        if (where != null) {
            temp.add("WHERE");
            temp.add(where.translate());
        }
        return this.join(temp, " ");
    }

    @Override
    public String translateEscape() {
        return "\"";
    }

    @Override
    public String translateTrue() {
        return "1";
    }

    @Override
    public String translateFalse() {
        return "0";
    }
}

