/*
 * Decompiled with CFR 0.152.
 */
package com.feedzai.commons.sql.abstraction.dml.dialect;

import com.feedzai.commons.sql.abstraction.ddl.AlterColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumn;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnConstraint;
import com.feedzai.commons.sql.abstraction.ddl.DbColumnType;
import com.feedzai.commons.sql.abstraction.ddl.DbEntity;
import com.feedzai.commons.sql.abstraction.ddl.DbFk;
import com.feedzai.commons.sql.abstraction.ddl.DbIndex;
import com.feedzai.commons.sql.abstraction.ddl.DropPrimaryKey;
import com.feedzai.commons.sql.abstraction.ddl.Rename;
import com.feedzai.commons.sql.abstraction.dml.All;
import com.feedzai.commons.sql.abstraction.dml.Between;
import com.feedzai.commons.sql.abstraction.dml.Coalesce;
import com.feedzai.commons.sql.abstraction.dml.Delete;
import com.feedzai.commons.sql.abstraction.dml.Expression;
import com.feedzai.commons.sql.abstraction.dml.Function;
import com.feedzai.commons.sql.abstraction.dml.K;
import com.feedzai.commons.sql.abstraction.dml.Literal;
import com.feedzai.commons.sql.abstraction.dml.Modulo;
import com.feedzai.commons.sql.abstraction.dml.Name;
import com.feedzai.commons.sql.abstraction.dml.Query;
import com.feedzai.commons.sql.abstraction.dml.RepeatDelimiter;
import com.feedzai.commons.sql.abstraction.dml.Truncate;
import com.feedzai.commons.sql.abstraction.dml.Update;
import com.feedzai.commons.sql.abstraction.dml.View;
import com.feedzai.commons.sql.abstraction.entry.EntityEntry;
import java.util.Collection;

public final class SqlBuilder {
    public static Query select(Expression ... select) {
        return new Query().select(select);
    }

    public static Query select(Collection<? extends Expression> select) {
        return new Query().select(select);
    }

    public static Expression all() {
        return new All().unquote();
    }

    public static Expression all(String tableName) {
        return new All(tableName).unquote();
    }

    public static Name column(String name) {
        return new Name(name);
    }

    public static Name column(String tableName, String name) {
        return new Name(tableName, name);
    }

    public static Name table(String name) {
        return new Name(name);
    }

    public static Expression eq(Expression ... e1) {
        return new RepeatDelimiter(" = ", e1);
    }

    public static Expression eq(Collection<? extends Expression> e1) {
        return new RepeatDelimiter(" = ", e1);
    }

    public static Expression k(Object o) {
        return new K(o);
    }

    public static Expression and(Expression ... exps) {
        return new RepeatDelimiter(" AND ", exps);
    }

    public static Expression and(Collection<? extends Expression> exps) {
        return new RepeatDelimiter(" AND ", exps);
    }

    public static Expression or(Expression ... exps) {
        return new RepeatDelimiter(" OR ", exps);
    }

    public static Expression or(Collection<? extends Expression> exps) {
        return new RepeatDelimiter(" OR ", exps);
    }

    public static Expression div(Expression ... exps) {
        return new RepeatDelimiter(" / ", exps);
    }

    public static Expression div(Collection<? extends Expression> exps) {
        return new RepeatDelimiter(" / ", exps);
    }

    public static Expression mod(Expression exp1, Expression exp2) {
        return new Modulo(exp1, exp2);
    }

    public static Expression gt(Expression ... exps) {
        return new RepeatDelimiter(" > ", exps);
    }

    public static Expression gt(Collection<? extends Expression> exps) {
        return new RepeatDelimiter(" > ", exps);
    }

    public static Expression gteq(Expression ... exps) {
        return new RepeatDelimiter(" >= ", exps);
    }

    public static Expression gteq(Collection<? extends Expression> exps) {
        return new RepeatDelimiter(" >= ", exps);
    }

    public static Expression like(Expression ... exps) {
        return new RepeatDelimiter(" LIKE ", exps);
    }

    public static Expression like(Collection<? extends Expression> exps) {
        return new RepeatDelimiter(" LIKE ", exps);
    }

    public static Expression lt(Expression ... exps) {
        return new RepeatDelimiter(" < ", exps);
    }

    public static Expression lt(Collection<? extends Expression> exps) {
        return new RepeatDelimiter(" < ", exps);
    }

    public static Expression lteq(Expression ... exps) {
        return new RepeatDelimiter(" <= ", exps);
    }

    public static Expression lteq(Collection<? extends Expression> exps) {
        return new RepeatDelimiter(" <= ", exps);
    }

    public static Expression minus(Expression ... exps) {
        return new RepeatDelimiter(" - ", exps);
    }

    public static Expression minus(Collection<? extends Expression> exps) {
        return new RepeatDelimiter(" - ", exps);
    }

    public static Expression mult(Expression ... exps) {
        return new RepeatDelimiter(" * ", exps);
    }

    public static Expression mult(Collection<? extends Expression> exps) {
        return new RepeatDelimiter(" * ", exps);
    }

    public static Expression plus(Expression ... exps) {
        return new RepeatDelimiter(" + ", exps);
    }

    public static Expression plus(Collection<? extends Expression> exps) {
        return new RepeatDelimiter(" + ", exps);
    }

    public static Expression max(Expression exp) {
        return new Function("MAX", exp);
    }

    public static Expression min(Expression exp) {
        return new Function("MIN", exp);
    }

    public static Expression stddev(Expression exp) {
        return new Function("STDDEV", exp);
    }

    public static Expression avg(Expression exp) {
        return new Function("AVG", exp);
    }

    public static Expression count(Expression exp) {
        return new Function("COUNT", exp);
    }

    public static Expression sum(Expression exp) {
        return new Function("SUM", exp);
    }

    public static Expression udf(String udf) {
        return new Function(udf);
    }

    public static Expression udf(String udf, Expression exp) {
        return new Function(udf, exp);
    }

    public static Expression join(Expression e1, Expression e2) {
        return new RepeatDelimiter(" = ", e1, e2);
    }

    public static View createView(String name) {
        return new View(name);
    }

    public static Expression neq(Expression ... exps) {
        return new RepeatDelimiter(" <> ", exps);
    }

    public static Expression neq(Collection<? extends Expression> exps) {
        return new RepeatDelimiter(" <> ", exps);
    }

    public static Expression L(Expression ... exps) {
        return new RepeatDelimiter(", ", exps).enclose();
    }

    public static Expression L(Collection<? extends Expression> exps) {
        return new RepeatDelimiter(", ", exps).enclose();
    }

    public static Expression in(Expression e1, Expression e2) {
        return new RepeatDelimiter(" IN ", e1.isEnclosed() ? e1 : e1.enclose(), e2.isEnclosed() ? e2 : e2.enclose());
    }

    public static Expression notIn(Expression e1, Expression e2) {
        return new RepeatDelimiter(" NOT IN ", e1.isEnclosed() ? e1 : e1.enclose(), e2.isEnclosed() ? e2 : e2.enclose());
    }

    public static Coalesce coalesce(Expression exp, Expression ... alternative) {
        return new Coalesce(exp, alternative);
    }

    public static Between between(Expression exp1, Expression exp2, Expression exp3) {
        return new Between(exp1, SqlBuilder.and(exp2, exp3));
    }

    public static Between notBetween(Expression exp1, Expression exp2, Expression exp3) {
        return new Between(exp1, SqlBuilder.and(exp2, exp3)).not();
    }

    public static Update update(Expression table) {
        return new Update(table);
    }

    public static Delete delete(Expression table) {
        return new Delete(table);
    }

    public static Literal lit(Object o) {
        return new Literal(o);
    }

    public static Truncate truncate(Expression table) {
        return new Truncate(table);
    }

    public static Rename rename(Expression oldName, Expression newName) {
        return new Rename(oldName, newName);
    }

    public static DropPrimaryKey dropPK(Expression table) {
        return new DropPrimaryKey(table);
    }

    public static AlterColumn alterColumn(Expression table, Name column, DbColumnType dbColumnType, DbColumnConstraint ... constraints) {
        return SqlBuilder.alterColumn(table, SqlBuilder.dbColumn().name(column.getName()).type(dbColumnType).addConstraints(constraints).build());
    }

    public static AlterColumn alterColumn(Expression table, DbColumn dbColumn) {
        return new AlterColumn(table, dbColumn);
    }

    public static DbFk.Builder dbFk() {
        return new DbFk.Builder();
    }

    public static DbEntity.Builder dbEntity() {
        return new DbEntity.Builder();
    }

    public static DbIndex.Builder dbIndex() {
        return new DbIndex.Builder();
    }

    public static DbColumn.Builder dbColumn() {
        return new DbColumn.Builder();
    }

    public static DbColumn.Builder dbColumn(String name, DbColumnType type, boolean autoInc) {
        return new DbColumn.Builder().name(name).type(type).autoInc(autoInc);
    }

    public static DbColumn.Builder dbColumn(String name, DbColumnType type) {
        return new DbColumn.Builder().name(name).type(type);
    }

    public static DbColumn.Builder dbColumn(String name, DbColumnType type, int size) {
        return new DbColumn.Builder().name(name).type(type).size(size);
    }

    public static EntityEntry.Builder entry() {
        return new EntityEntry.Builder();
    }
}

