/*
 * Decompiled with CFR 0.152.
 */
package com.fedapay.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fedapay.model.Event;
import com.fedapay.utile.EventModel;
import com.fedapay.utile.Serializer;
import com.fedapay.utile.StringUtils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class WebhookSignature {
    private String id;
    @JsonProperty(value="public_key")
    private String publicKey;
    @JsonProperty(value="private_key")
    private String privateKey;
    @JsonProperty(value="created_at")
    private String createdAt;
    @JsonProperty(value="updated_at")
    private String updatedAt;
    private static final long DEFAULT_TOLERANCE = 300L;
    public static final String ALGORITHM = "HmacSHA256";

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public static long getDefaultTolerance() {
        return 300L;
    }

    public static String getAlgorithm() {
        return ALGORITHM;
    }

    public static Event constructEvent(String payload, String sigHeader, String secret) throws Exception {
        return WebhookSignature.constructEvent(payload, sigHeader, secret, 300L);
    }

    public static Event constructEvent(String payload, String sigHeader, String secret, long tolerance) throws Exception {
        Event event = (Event)Serializer.allSerializer(new EventModel(), payload).getData();
        Signature.verifyHeader(payload, sigHeader, secret, tolerance);
        return event;
    }

    public static final class Util {
        public static String computeHmacSha256(String key, String message) throws NoSuchAlgorithmException, InvalidKeyException {
            Mac hasher = Mac.getInstance(WebhookSignature.ALGORITHM);
            hasher.init(new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), WebhookSignature.ALGORITHM));
            byte[] hash = hasher.doFinal(message.getBytes(StandardCharsets.UTF_8));
            String result = "";
            for (byte b : hash) {
                result = result + Integer.toString((b & 0xFF) + 256, 16).substring(1);
            }
            return result;
        }

        public static long getTimeNow() {
            long time = System.currentTimeMillis() / 1000L;
            return time;
        }
    }

    public static final class Signature {
        public static final String EXPECTED_SCHEME = "s";

        public static boolean verifyHeader(String payload, String sigHeader, String secret, long tolerance) throws Exception {
            String expectedSignature;
            long timestamp = Signature.getTimestamp(sigHeader);
            List<String> signatures = Signature.getSignatures(sigHeader, EXPECTED_SCHEME);
            if (timestamp <= 0L) {
                throw new Exception("Unable to extract timestamp and signatures from header" + sigHeader);
            }
            if (signatures.size() == 0) {
                throw new Exception("No signatures found with expected scheme" + sigHeader);
            }
            String signedPayload = "" + timestamp + "." + payload;
            try {
                expectedSignature = Signature.computeSignature(signedPayload, secret);
            }
            catch (Exception e) {
                throw new Exception("Unable to compute signature for payload" + sigHeader);
            }
            boolean signatureFound = false;
            for (String signature : signatures) {
                if (!StringUtils.secureCompare(expectedSignature, signature)) continue;
                signatureFound = true;
                break;
            }
            if (!signatureFound) {
                throw new Exception("No signatures found matching the expected signature for payload" + sigHeader);
            }
            if (tolerance > 0L && timestamp < Util.getTimeNow() - tolerance) {
                throw new Exception("Timestamp outside the tolerance zone" + sigHeader);
            }
            return true;
        }

        private static long getTimestamp(String sigHeader) {
            String[] items;
            for (String item : items = sigHeader.split(",", -1)) {
                String[] itemParts = item.split("=", 2);
                if (!itemParts[0].equals("t")) continue;
                return Long.parseLong(itemParts[1]);
            }
            return -1L;
        }

        private static List<String> getSignatures(String sigHeader, String scheme) {
            String[] items;
            ArrayList<String> signatures = new ArrayList<String>();
            for (String item : items = sigHeader.split(",", -1)) {
                String[] itemParts = item.split("=", 2);
                if (!itemParts[0].equals(scheme)) continue;
                signatures.add(itemParts[1]);
            }
            return signatures;
        }

        private static String computeSignature(String payload, String secret) throws Exception {
            return Util.computeHmacSha256(secret, payload);
        }
    }
}

