/*
 * Decompiled with CFR 0.152.
 */
package com.fedapay.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fedapay.collections.TransactionCollection;
import com.fedapay.model.Customer;
import com.fedapay.model.FedaPayObject;
import com.fedapay.model.PhoneNumber;
import com.fedapay.model.TransactionToken;
import com.fedapay.net.All;
import com.fedapay.net.Create;
import com.fedapay.net.Delete;
import com.fedapay.net.Requestor;
import com.fedapay.net.Retrieve;
import com.fedapay.net.Update;
import com.fedapay.utile.Serializer;
import com.fedapay.utile.TransactionModel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Transaction
extends FedaPayObject {
    private String id;
    @JsonProperty(value="reference")
    private String reference;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="callback_url")
    private String callbackUrl;
    @JsonProperty(value="amount")
    private String amount;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="customer_id")
    private String customerId;
    @JsonProperty(value="currency_id")
    private String currencyId;
    @JsonProperty(value="customer")
    private Customer customer;
    @JsonProperty(value="phone_number")
    private PhoneNumber phoneNumber;
    private Map<String, Object> metadata;
    @JsonProperty(value="created_at")
    private String createdAt;
    @JsonProperty(value="updated_at")
    private String updatedAt;
    public static String[] PAID_STATUS = new String[]{"approved", "transferred", "refunded", "approved_partially_refunded", "transferred_partially_refunded"};
    private static String[] AVAILABLE_MOBILE_MONEY = new String[]{"mtn", "moov", "mtn_ci", "moov_tg", "mtn_open"};

    public Transaction(String id, String reference, String description, String callbackUrl, String amount, String status, String customerId, String currencyId, Customer customer, PhoneNumber phoneNumber, Map<String, Object> metadata, String createdAt, String updatedAt) {
        this.id = id;
        this.reference = reference;
        this.description = description;
        this.callbackUrl = callbackUrl;
        this.amount = amount;
        this.status = status;
        this.customerId = customerId;
        this.currencyId = currencyId;
        this.customer = customer;
        this.phoneNumber = phoneNumber;
        this.metadata = metadata;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public Transaction() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callback_url) {
        this.callbackUrl = callback_url;
    }

    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    @JsonIgnore
    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public static TransactionCollection all() throws Exception {
        return All.all(new TransactionCollection(), "/transactions");
    }

    public static Transaction create(Map<String, Object> transactionDataMap) throws Exception {
        Transaction transaction = (Transaction)Create.create(new TransactionModel(), "/transactions", transactionDataMap).getData();
        transaction.setRawJsonResponse(Create.lastRequestResponse);
        return transaction;
    }

    public static Transaction retrieve(String transactionId) throws Exception {
        Transaction transaction = (Transaction)Retrieve.retrieve(new TransactionModel(), "/transactions", transactionId).getData();
        transaction.setRawJsonResponse(Retrieve.lastRequestResponse);
        return transaction;
    }

    public static Transaction update(String transactionId, Map<String, Object> transactionDataMap) throws Exception {
        Transaction transaction = (Transaction)Update.update(new TransactionModel(), "/transactions", transactionId, transactionDataMap).getData();
        transaction.setRawJsonResponse(Update.lastRequestResponse);
        return transaction;
    }

    public Transaction save() throws Exception {
        Transaction transaction = (Transaction)Update.update(new TransactionModel(), "transactions", this.id, this.toMap()).getData();
        transaction.setRawJsonResponse(Update.lastRequestResponse);
        return transaction;
    }

    public static String delete(String transactionId) throws Exception {
        Delete.delete("/transactions", transactionId);
        return "Transaction deleted";
    }

    protected Boolean mobileMoneyModeAvailable(String mode) {
        return Arrays.stream(AVAILABLE_MOBILE_MONEY).anyMatch(mode::equals);
    }

    public Boolean wasPaid() {
        return Arrays.stream(PAID_STATUS).anyMatch(this.status::equals);
    }

    public Boolean wasRefunded() {
        return this.status.equals("refunded");
    }

    public Boolean wasPartiallyRefunded() {
        return this.status.equals("partially_refunded");
    }

    public TransactionToken generateToken() throws Exception {
        if (this.id != null) {
            System.out.println(Requestor.postRequest("/transactions/" + this.id + "/token", null));
            return Serializer.allSerializer(new TransactionToken(), Requestor.postRequest("/transactions/" + this.id + "/token", null));
        }
        throw new Exception("id can't be null");
    }

    public String getReceipUrl() throws Exception {
        if (this.id != null) {
            return (String)Serializer.allSerializer(new HashMap(), Requestor.postRequest("/transactions/" + this.id + "/receipt_url", null)).get("url");
        }
        throw new Exception("id can't be null");
    }

    public void name() {
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.id != null) {
            map.put("id", this.id);
            map.put("reference", this.reference);
            map.put("description", this.description);
            map.put("callback_url", this.callbackUrl);
            map.put("amount", this.amount);
            map.put("customer_id", this.customerId);
            map.put("currency_id", this.currencyId);
            map.put("customer", this.customer);
            map.put("phone_number", this.phoneNumber);
            map.put("metadata", this.metadata);
        }
        return map;
    }
}

