/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.uuid.impl;

import com.fasterxml.uuid.EthernetAddress;
import com.fasterxml.uuid.NoArgGenerator;
import com.fasterxml.uuid.UUIDTimer;
import com.fasterxml.uuid.UUIDType;
import com.fasterxml.uuid.impl.UUIDUtil;
import java.util.UUID;

public class TimeBasedReorderedGenerator
extends NoArgGenerator {
    public static int BYTE_OFFSET_TIME_HIGH = 0;
    public static int BYTE_OFFSET_TIME_MID = 4;
    public static int BYTE_OFFSET_TIME_LOW = 7;
    protected final EthernetAddress _ethernetAddress;
    protected final UUIDTimer _timer;
    protected final long _uuidL2;

    public TimeBasedReorderedGenerator(EthernetAddress ethAddr, UUIDTimer timer) {
        byte[] uuidBytes = new byte[16];
        if (ethAddr == null) {
            ethAddr = EthernetAddress.constructMulticastAddress();
        }
        this._ethernetAddress = ethAddr;
        this._ethernetAddress.toByteArray(uuidBytes, 10);
        int clockSeq = timer.getClockSequence();
        uuidBytes[8] = (byte)(clockSeq >> 8);
        uuidBytes[9] = (byte)clockSeq;
        long l2 = UUIDUtil.gatherLong(uuidBytes, 8);
        this._uuidL2 = UUIDUtil.initUUIDSecondLong(l2);
        this._timer = timer;
    }

    @Override
    public UUIDType getType() {
        return UUIDType.TIME_BASED_REORDERED;
    }

    public EthernetAddress getEthernetAddress() {
        return this._ethernetAddress;
    }

    @Override
    public UUID generate() {
        long rawTimestamp = this._timer.getTimestamp();
        long timestampHigh = rawTimestamp >>> 28 << 32;
        int timestampLow = (int)rawTimestamp;
        int timeBottom = (timestampLow >> 12 & 0xFFFF) << 16 | 0x6000 | timestampLow & 0xFFF;
        long timeBottomL = timeBottom;
        timeBottomL = timeBottomL << 32 >>> 32;
        long l1 = timestampHigh | timeBottomL;
        return new UUID(l1, this._uuidL2);
    }
}

