/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.uuid.impl;

import com.fasterxml.uuid.NoArgGenerator;
import com.fasterxml.uuid.UUIDType;
import com.fasterxml.uuid.impl.LazyRandom;
import com.fasterxml.uuid.impl.UUIDUtil;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TimeBasedEpochGenerator
extends NoArgGenerator {
    private static final int ENTROPY_BYTE_LENGTH = 10;
    protected final Random _random;
    private long _lastTimestamp = -1L;
    private final byte[] _lastEntropy = new byte[10];
    private final Lock lock = new ReentrantLock();

    public TimeBasedEpochGenerator(Random rnd) {
        if (rnd == null) {
            rnd = LazyRandom.sharedSecureRandom();
        }
        this._random = rnd;
    }

    @Override
    public UUIDType getType() {
        return UUIDType.TIME_BASED_EPOCH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID generate() {
        this.lock.lock();
        try {
            long rawTimestamp = System.currentTimeMillis();
            if (rawTimestamp == this._lastTimestamp) {
                boolean c = true;
                for (int i = 9; i >= 0; --i) {
                    if (!c) continue;
                    byte temp = this._lastEntropy[i];
                    temp = (byte)(temp + 1);
                    c = this._lastEntropy[i] == -1 && c;
                    this._lastEntropy[i] = temp;
                }
                if (c) {
                    throw new IllegalStateException("overflow on same millisecond");
                }
            } else {
                this._lastTimestamp = rawTimestamp;
                this._random.nextBytes(this._lastEntropy);
            }
            UUID uUID = UUIDUtil.constructUUID(UUIDType.TIME_BASED_EPOCH, rawTimestamp << 16 | TimeBasedEpochGenerator._toShort(this._lastEntropy, 0), TimeBasedEpochGenerator._toLong(this._lastEntropy, 2));
            return uUID;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected static final long _toLong(byte[] buffer, int offset) {
        long l1 = TimeBasedEpochGenerator._toInt(buffer, offset);
        long l2 = TimeBasedEpochGenerator._toInt(buffer, offset + 4);
        long l = (l1 << 32) + (l2 << 32 >>> 32);
        return l;
    }

    private static final long _toInt(byte[] buffer, int offset) {
        return (buffer[offset] << 24) + ((buffer[++offset] & 0xFF) << 16) + ((buffer[++offset] & 0xFF) << 8) + (buffer[++offset] & 0xFF);
    }

    private static final long _toShort(byte[] buffer, int offset) {
        return ((buffer[offset] & 0xFF) << 8) + (buffer[++offset] & 0xFF);
    }
}

