/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.uuid;

import com.fasterxml.uuid.Logger;
import com.fasterxml.uuid.TimestampSynchronizer;
import java.io.IOException;
import java.util.Random;

public final class UUIDTimer {
    private static final long kClockOffset = 122192928000000000L;
    private static final int kClockMultiplier = 10000;
    private static final long kClockMultiplierL = 10000L;
    private static final long kMaxClockAdvance = 100L;
    protected final TimestampSynchronizer mSync;
    protected final Random mRnd;
    private final byte[] mClockSequence = new byte[3];
    private long mLastSystemTimestamp = 0L;
    private long mLastUsedTimestamp = 0L;
    private long mFirstUnsafeTimestamp = Long.MAX_VALUE;
    private int mClockCounter = 0;
    private static final int MAX_WAIT_COUNT = 50;

    public UUIDTimer(Random rnd, TimestampSynchronizer sync) throws IOException {
        long lastSaved;
        this.mRnd = rnd;
        this.mSync = sync;
        this.initCounters(rnd);
        this.mLastSystemTimestamp = 0L;
        this.mLastUsedTimestamp = 0L;
        if (sync != null && (lastSaved = sync.initialize()) > this.mLastUsedTimestamp) {
            this.mLastUsedTimestamp = lastSaved;
        }
        this.mFirstUnsafeTimestamp = 0L;
    }

    private void initCounters(Random rnd) {
        rnd.nextBytes(this.mClockSequence);
        this.mClockCounter = this.mClockSequence[2] & 0xFF;
    }

    public final long getTimestamp(byte[] uuidBytes) {
        uuidBytes[8] = this.mClockSequence[0];
        uuidBytes[9] = this.mClockSequence[1];
        long systime = System.currentTimeMillis();
        if (systime < this.mLastSystemTimestamp) {
            Logger.logWarning("System time going backwards! (got value " + systime + ", last " + this.mLastSystemTimestamp);
            this.mLastSystemTimestamp = systime;
        }
        if (systime <= this.mLastUsedTimestamp) {
            if (this.mClockCounter < 10000) {
                systime = this.mLastUsedTimestamp;
            } else {
                long actDiff = this.mLastUsedTimestamp - systime;
                long origTime = systime;
                systime = this.mLastUsedTimestamp + 1L;
                Logger.logWarning("Timestamp over-run: need to reinitialize random sequence");
                this.initCounters(this.mRnd);
                if (actDiff >= 100L) {
                    UUIDTimer.slowDown(origTime, actDiff);
                }
            }
        } else {
            this.mClockCounter &= 0xFF;
        }
        this.mLastUsedTimestamp = systime;
        if (this.mSync != null && systime >= this.mFirstUnsafeTimestamp) {
            try {
                this.mFirstUnsafeTimestamp = this.mSync.update(systime);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to synchronize timestamp: " + ioe);
            }
        }
        systime *= 10000L;
        systime += 122192928000000000L;
        ++this.mClockCounter;
        return systime += (long)this.mClockCounter;
    }

    public final void getAndSetTimestamp(byte[] uuidBytes) {
        long timestamp = this.getTimestamp(uuidBytes);
        int clockHi = (int)(timestamp >>> 32);
        int clockLo = (int)timestamp;
        uuidBytes[6] = (byte)(clockHi >>> 24);
        uuidBytes[7] = (byte)(clockHi >>> 16);
        uuidBytes[4] = (byte)(clockHi >>> 8);
        uuidBytes[5] = (byte)clockHi;
        uuidBytes[0] = (byte)(clockLo >>> 24);
        uuidBytes[1] = (byte)(clockLo >>> 16);
        uuidBytes[2] = (byte)(clockLo >>> 8);
        uuidBytes[3] = (byte)clockLo;
    }

    private static final void slowDown(long startTime, long actDiff) {
        long ratio = actDiff / 100L;
        long delay = ratio < 2L ? 1L : (ratio < 10L ? 2L : (ratio < 600L ? 3L : 5L));
        Logger.logWarning("Need to wait for " + delay + " milliseconds; virtual clock advanced too far in the future");
        long waitUntil = startTime + delay;
        int counter = 0;
        do {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            delay = 1L;
        } while (++counter <= 50 && System.currentTimeMillis() < waitUntil);
    }
}

