/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.scala.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.CollectionDeserializer;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ListBuffer;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public abstract class GenericFactoryDeserializerResolver<CC, CF>
extends Deserializers.Base {
    public abstract Class<?> CLASS_DOMAIN();

    public abstract Iterable<Tuple2<Class<?>, CF>> factories();

    public abstract <A> Builder<A, ? extends CC> builderFor(CF var1, JavaType var2);

    public <A> Builder<A, ? extends CC> builderFor(Class<?> cls, JavaType valueType) {
        return (Builder)this.factories().find((Function1 & Serializable)_$3 -> ((Class)_$3._1()).isAssignableFrom(cls)).map((Function1 & Serializable)_$4 -> _$4._2()).map((Function1 & Serializable)_$5 -> this.builderFor(_$5, valueType)).getOrElse(() -> GenericFactoryDeserializerResolver.builderFor$$anonfun$4(cls));
    }

    public JsonDeserializer<?> findCollectionLikeDeserializer(CollectionLikeType collectionType, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) {
        Object object;
        if (!this.CLASS_DOMAIN().isAssignableFrom(collectionType.getRawClass())) {
            object = (JsonDeserializer)None$.MODULE$.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        } else {
            JsonDeserializer<?> deser = elementDeserializer;
            Instantiator instantiator = new Instantiator(this, config, (JavaType)collectionType, collectionType.getContentType());
            object = new Deserializer(this, (JavaType)collectionType, deser, elementTypeDeserializer, (ValueInstantiator)instantiator);
        }
        return object;
    }

    public Seq<Tuple2<Class<?>, CF>> sortFactories(IndexedSeq<Tuple2<Class<?>, CF>> factories) {
        Object[] cs = (Tuple2[])factories.toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        ListBuffer output = new ListBuffer();
        Object object = Predef$.MODULE$.refArrayOps(cs);
        int[] remaining = (int[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$6 -> 1, ClassTag$.MODULE$.apply(Integer.TYPE));
        int[][] adjMatrix = new int[cs.length][cs.length];
        Object object2 = Predef$.MODULE$.refArrayOps(cs);
        ArrayOps$.MODULE$.indices$extension(object2).foreach((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> GenericFactoryDeserializerResolver.sortFactories$$anonfun$1((Tuple2[])cs, adjMatrix, arg_0)));
        while (output.length() < cs.length) {
            int startLength = output.length();
            Object object3 = Predef$.MODULE$.refArrayOps(cs);
            ArrayOps$.MODULE$.indices$extension(object3).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                if (remaining[i] == 1 && this.dotProduct(adjMatrix[i], remaining) == 0) {
                    output.$plus$eq(factories.apply(i));
                    remaining$1[i] = 0;
                }
            });
            if (output.length() != startLength) continue;
            throw new IllegalStateException("Companions contain a cycle.");
        }
        return output.toSeq();
    }

    private int dotProduct(int[] a, int[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException();
        }
        Object object = Predef$.MODULE$.intArrayOps(a);
        return BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.indices$extension(object).map((Function1)(JFunction1.mcII.sp & Serializable)i -> a[i] * b[i]).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private static final Builder builderFor$$anonfun$4(Class cls$2) {
        throw new IllegalStateException("Could not find deserializer for " + cls$2.getCanonicalName() + ". File issue on github:fasterxml/jackson-scala-module.");
    }

    private static final /* synthetic */ void sortFactories$$anonfun$1(Tuple2[] cs$1, int[][] adjMatrix$1, int i) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])cs$1);
        ArrayOps$.MODULE$.indices$extension(object).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            Tuple2 tuple2 = cs$1[i];
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Class ic = (Class)tuple2._1();
            Class ic2 = ic;
            Tuple2 tuple22 = cs$1[j];
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Class jc = (Class)tuple22._1();
            Class jc2 = jc;
            if (i != j && ic2.isAssignableFrom(jc2)) {
                adjMatrix$2[i$1][j] = 1;
            }
        });
    }

    private class BuilderWrapper<A>
    extends AbstractCollection<A> {
        private final Builder builder;
        private int size;

        public BuilderWrapper(Builder<A, ? extends CC> builder) {
            this.builder = builder;
            this.size = 0;
        }

        public Builder<A, ? extends CC> builder() {
            return this.builder;
        }

        @Override
        public int size() {
            return this.size;
        }

        public void size_$eq(int x$1) {
            this.size = x$1;
        }

        @Override
        public boolean add(A e) {
            this.builder().$plus$eq(e);
            this.size_$eq(this.size() + 1);
            return true;
        }

        @Override
        public Iterator<A> iterator() {
            return (Iterator)None$.MODULE$.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public void setInitialValue(CC init) {
            ((Iterable)init).foreach((Function1 & Serializable)e -> this.add((A)e));
        }
    }

    private class Deserializer<A>
    extends ContainerDeserializerBase<CC>
    implements ContextualDeserializer {
        private final JavaType collectionType;
        private final CollectionDeserializer containerDeserializer;
        private final GenericFactoryDeserializerResolver<CC, CF> $outer;

        public Deserializer(GenericFactoryDeserializerResolver $outer, JavaType collectionType, CollectionDeserializer containerDeserializer) {
            this.collectionType = collectionType;
            this.containerDeserializer = containerDeserializer;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(collectionType);
        }

        public Deserializer(GenericFactoryDeserializerResolver $outer, JavaType collectionType, JsonDeserializer<Object> valueDeser, TypeDeserializer valueTypeDeser, ValueInstantiator valueInstantiator) {
            this($outer, collectionType, new CollectionDeserializer(collectionType, valueDeser, valueTypeDeser, valueInstantiator));
        }

        public Deserializer<A> createContextual(DeserializationContext ctxt, BeanProperty property) {
            CollectionDeserializer newDelegate = this.containerDeserializer.createContextual(ctxt, property);
            return new Deserializer<A>(this.$outer, this.collectionType, newDelegate);
        }

        public JavaType getContentType() {
            return this.containerDeserializer.getContentType();
        }

        public JsonDeserializer<Object> getContentDeserializer() {
            return this.containerDeserializer.getContentDeserializer();
        }

        public CC deserialize(JsonParser jp, DeserializationContext ctxt) {
            Collection collection = this.containerDeserializer.deserialize(jp, ctxt);
            if (!(collection instanceof BuilderWrapper)) {
                throw new MatchError((Object)collection);
            }
            BuilderWrapper wrapper = (BuilderWrapper)collection;
            return wrapper.builder().result();
        }

        public CC deserialize(JsonParser jp, DeserializationContext ctxt, CC intoValue) {
            BuilderWrapper<Object> bw = this.newBuilderWrapper(ctxt);
            bw.setInitialValue(intoValue);
            Collection collection = this.containerDeserializer.deserialize(jp, ctxt, bw);
            if (!(collection instanceof BuilderWrapper)) {
                throw new MatchError((Object)collection);
            }
            BuilderWrapper wrapper = (BuilderWrapper)collection;
            return wrapper.builder().result();
        }

        public Object getEmptyValue(DeserializationContext ctxt) {
            BuilderWrapper<Object> bw = this.newBuilderWrapper(ctxt);
            return bw.builder().result();
        }

        private BuilderWrapper<Object> newBuilderWrapper(DeserializationContext ctxt) {
            return (BuilderWrapper)this.containerDeserializer.getValueInstantiator().createUsingDefault(ctxt);
        }

        public final GenericFactoryDeserializerResolver<CC, CF> com$fasterxml$jackson$module$scala$deser$GenericFactoryDeserializerResolver$Deserializer$$$outer() {
            return this.$outer;
        }
    }

    private class Instantiator
    extends StdValueInstantiator {
        private final JavaType collectionType;
        private final JavaType valueType;
        private final GenericFactoryDeserializerResolver<CC, CF> $outer;

        public Instantiator(GenericFactoryDeserializerResolver $outer, DeserializationConfig config, JavaType collectionType, JavaType valueType) {
            this.collectionType = collectionType;
            this.valueType = valueType;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(config, collectionType);
        }

        public boolean canCreateUsingDefault() {
            return true;
        }

        public Object createUsingDefault(DeserializationContext ctxt) {
            return new BuilderWrapper(this.$outer.builderFor(this.collectionType.getRawClass(), this.valueType));
        }

        public final GenericFactoryDeserializerResolver<CC, CF> com$fasterxml$jackson$module$scala$deser$GenericFactoryDeserializerResolver$Instantiator$$$outer() {
            return this.$outer;
        }
    }
}

