/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.noctordeser.util;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.LRUMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import sun.reflect.ReflectionFactory;

public class ReflectionUtil {
    private final LRUMap<Class<?>, Constructor<?>> constructorCache = new LRUMap(20, 100);

    public Object newConstructorAndCreateInstance(DeserializationContext ctxt, Class<?> classToInstantiate) throws JacksonException {
        if (classToInstantiate.isInterface() || Modifier.isAbstract(classToInstantiate.getModifiers())) {
            return null;
        }
        Constructor<?> constructor = (Constructor<?>)this.constructorCache.get(classToInstantiate);
        try {
            if (constructor == null) {
                constructor = ReflectionFactory.getReflectionFactory().newConstructorForSerialization(classToInstantiate, Object.class.getDeclaredConstructor(new Class[0]));
                constructor.setAccessible(true);
                this.constructorCache.put(classToInstantiate, constructor);
            }
        }
        catch (Exception e) {
            return ctxt.reportBadDefinition(classToInstantiate, "No-Constructor-Deserialization module failed to force generation of virtual constructor: " + e.getMessage());
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            return ctxt.reportBadDefinition(classToInstantiate, "No-Constructor-Deserialization module failed to forcibly instantiate " + ClassUtil.nameOf(classToInstantiate) + ": " + e.getMessage());
        }
    }
}

