/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.kotlin;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.ExtensionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.ClassMapping;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KotlinReflectionInternalError;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0005\b\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001c\u0003\u0006\u00031\tA\u0001\u0001\u0007\u00013\u0005A\n!)\u0004\n\u0007!\tQ\"\u0001M\u0002#\u000e\t\u0001BA\u0013\n\t-AQ!\u0004\u0002\r\u0002a-\u0011d\u0001\u0005\u0007\u001b\u0005Aj!J\u0005\u0005\u0006!9QB\u0001G\u00011\u0017I2\u0001c\u0004\u000e\u0003aAQ\u0005\u0003C\f\u0011#i\u0011\u0001G\u0005\u001a\u0007!1Q\"\u0001M\nS)!\u0011\t\u0003E\u0003\u001b\u0011I!!C\u0001\u0019\ba\u0019\u0011kA\u0001\u0006\u0001%RAa\u0011\u0005\t\u00035\t\u00014A)\u0004\t\u0015\u0001QB\u0001\u0003\u0005\u0011\u0013\u0001"}, strings={"Lcom/fasterxml/jackson/module/kotlin/KotlinNamesAnnotationIntrospector;", "Lcom/fasterxml/jackson/databind/introspect/NopAnnotationIntrospector;", "module", "Lcom/fasterxml/jackson/module/kotlin/KotlinModule;", "(Lcom/fasterxml/jackson/module/kotlin/KotlinModule;)V", "jsonCreator", "Ljava/lang/Class;", "Lcom/fasterxml/jackson/annotation/JsonCreator;", "getModule", "()Lcom/fasterxml/jackson/module/kotlin/KotlinModule;", "findImplicitPropertyName", "", "member", "Lcom/fasterxml/jackson/databind/introspect/AnnotatedMember;", "findKotlinParameterName", "param", "Lcom/fasterxml/jackson/databind/introspect/AnnotatedParameter;", "hasCreatorAnnotation", "", "Lcom/fasterxml/jackson/databind/introspect/Annotated;"}, moduleName="jackson-module-kotlin")
public final class KotlinNamesAnnotationIntrospector
extends NopAnnotationIntrospector {
    private final Class<JsonCreator> jsonCreator;
    @NotNull
    private final KotlinModule module;

    @Nullable
    public String findImplicitPropertyName(@NotNull AnnotatedMember member) {
        Intrinsics.checkParameterIsNotNull((Object)member, (String)"member");
        if (member instanceof AnnotatedParameter) {
            return this.findKotlinParameterName((AnnotatedParameter)member);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasCreatorAnnotation(@NotNull Annotated member) {
        Intrinsics.checkParameterIsNotNull((Object)member, (String)"member");
        if (member instanceof AnnotatedConstructor && ((AnnotatedConstructor)member).getParameterCount() > 0 && ((AnnotatedConstructor)member).getDeclaringClass().getAnnotation(KotlinClass.class) != null) {
            Class clazz = ((AnnotatedConstructor)member).getDeclaringClass();
            if (clazz == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<kotlin.Any>");
            }
            KClass kClass = ClassMapping.getKotlin((Class)clazz);
            Constructor constructor = ((AnnotatedConstructor)member).getAnnotated();
            if (constructor == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.Constructor<kotlin.Any>");
            }
            KFunction kConstructor = ReflectJvmMapping.getKotlinFunction((Constructor)constructor);
            if (kConstructor != null) {
                void $receiver;
                boolean bl;
                boolean anyConstructorHasJsonCreator;
                Object element2;
                boolean isPrimaryConstructor;
                block10: {
                    void $receiver2;
                    boolean bl2;
                    block9: {
                        void $receiver3;
                        isPrimaryConstructor = Intrinsics.areEqual((Object)KClasses.getPrimaryConstructor((KClass)kClass), (Object)kConstructor);
                        Iterable iterable = kClass.getConstructors();
                        for (Object element2 : $receiver3) {
                            boolean bl3;
                            block8: {
                                void $receiver4;
                                KFunction it = (KFunction)element2;
                                Iterable iterable2 = it.getAnnotations();
                                for (Object element3 : $receiver4) {
                                    Annotation it2 = (Annotation)element3;
                                    if (!Intrinsics.areEqual((Object)ExtensionsKt.annotationType((Annotation)it2), this.jsonCreator)) continue;
                                    bl3 = true;
                                    break block8;
                                }
                                bl3 = false;
                            }
                            if (!bl3) continue;
                            bl2 = true;
                            break block9;
                        }
                        bl2 = false;
                    }
                    anyConstructorHasJsonCreator = bl2;
                    Iterable iterable = ((AnnotatedConstructor)member).getContextClass().getStaticMethods();
                    for (Object element4 : $receiver2) {
                        AnnotatedMethod it = (AnnotatedMethod)element4;
                        if (!(it.getAnnotation(this.jsonCreator) != null)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
                boolean anyStaticHasJsonCreator = bl;
                element2 = kConstructor.getParameters();
                int n = kConstructor.getParameters().size();
                int count = 0;
                for (Object element5 : $receiver) {
                    KParameter it = (KParameter)element5;
                    if (!(it.getName() != null)) continue;
                    ++count;
                }
                int n2 = count;
                boolean areAllParametersValid = n == n2;
                boolean implyCreatorAnnotation = isPrimaryConstructor && !anyConstructorHasJsonCreator && !anyStaticHasJsonCreator && areAllParametersValid;
                return implyCreatorAnnotation;
            }
        }
        return false;
    }

    @Nullable
    protected final String findKotlinParameterName(@NotNull AnnotatedParameter param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        if (param.getDeclaringClass().getAnnotation(KotlinClass.class) != null) {
            String string;
            Member member = param.getOwner().getMember();
            if (member instanceof Constructor) {
                Object object;
                int ktorParmCount;
                Member member2 = member;
                if (member2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.Constructor<kotlin.Any>");
                }
                Constructor ctor = (Constructor)member2;
                int ctorParmCount = ((Object[])ctor.getParameterTypes()).length;
                Object object2 = ReflectJvmMapping.getKotlinFunction((Constructor)ctor);
                int n = object2 != null && (object2 = object2.getParameters()) != null ? object2.size() : (ktorParmCount = 0);
                string = ktorParmCount > 0 && ktorParmCount == ctorParmCount ? ((object = ReflectJvmMapping.getKotlinFunction((Constructor)ctor)) != null && (object = object.getParameters()) != null && (object = (KParameter)object.get(param.getIndex())) != null ? object.getName() : null) : (String)null;
            } else if (member instanceof Method) {
                String string2;
                try {
                    Object object;
                    int parmCount;
                    KFunction temp = ReflectJvmMapping.getKotlinFunction((Method)((Method)member));
                    Object object3 = temp;
                    KParameter.Kind firstParamKind = object3 != null && (object3 = object3.getParameters()) != null && (object3 = (KParameter)CollectionsKt.firstOrNull((List)object3)) != null ? object3.getKind() : null;
                    int idx = Intrinsics.areEqual(firstParamKind, (Object)KParameter.Kind.VALUE) ^ true ? param.getIndex() + 1 : param.getIndex();
                    Object object4 = temp;
                    int n = object4 != null && (object4 = object4.getParameters()) != null ? object4.size() : (parmCount = 0);
                    string2 = parmCount > idx ? ((object = temp) != null && (object = object.getParameters()) != null && (object = (KParameter)object.get(idx)) != null ? object.getName() : null) : (String)null;
                }
                catch (KotlinReflectionInternalError ex) {
                    string2 = null;
                }
                string = string2;
            } else {
                string = null;
            }
            String name = string;
            return name;
        }
        return null;
    }

    @NotNull
    public final KotlinModule getModule() {
        return this.module;
    }

    public KotlinNamesAnnotationIntrospector(@NotNull KotlinModule module) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)module), (String)"module");
        this.module = module;
        this.jsonCreator = JsonCreator.class;
    }
}

