/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.kotlin;

import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.module.kotlin.ConstructorValueCreator;
import com.fasterxml.jackson.module.kotlin.MethodValueCreator;
import com.fasterxml.jackson.module.kotlin.ValueCreator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\n2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u001dJ\"\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00192\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000b0\u001dJ+\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u00122\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u001d\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007J\u001c\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\rJ\u0014\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u0015J\u0014\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"2\u0006\u0010#\u001a\u00020$R&\u0010\u0005\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000e0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u0015\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0015\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/fasterxml/jackson/module/kotlin/ReflectionCache;", "", "reflectionCacheSize", "", "(I)V", "javaClassToKotlin", "Lcom/fasterxml/jackson/databind/util/LRUMap;", "Ljava/lang/Class;", "Lkotlin/reflect/KClass;", "javaConstructorIsCreatorAnnotated", "Lcom/fasterxml/jackson/databind/introspect/AnnotatedConstructor;", "", "javaConstructorToKotlin", "Ljava/lang/reflect/Constructor;", "Lkotlin/reflect/KFunction;", "javaConstructorToValueCreator", "Lcom/fasterxml/jackson/module/kotlin/ConstructorValueCreator;", "javaMemberIsRequired", "Lcom/fasterxml/jackson/databind/introspect/AnnotatedMember;", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState;", "javaMethodToKotlin", "Ljava/lang/reflect/Method;", "javaMethodToValueCreator", "Lcom/fasterxml/jackson/module/kotlin/MethodValueCreator;", "kotlinGeneratedMethod", "Lcom/fasterxml/jackson/databind/introspect/AnnotatedMethod;", "checkConstructorIsCreatorAnnotated", "key", "calc", "Lkotlin/Function1;", "isKotlinGeneratedMethod", "(Lcom/fasterxml/jackson/databind/introspect/AnnotatedMember;Lkotlin/jvm/functions/Function1;)Ljava/lang/Boolean;", "kotlinFromJava", "valueCreatorFromJava", "Lcom/fasterxml/jackson/module/kotlin/ValueCreator;", "_withArgsCreator", "Lcom/fasterxml/jackson/databind/introspect/AnnotatedWithParams;", "BooleanTriState", "jackson-module-kotlin"})
public final class ReflectionCache {
    @NotNull
    private final LRUMap<Class<Object>, KClass<Object>> javaClassToKotlin;
    @NotNull
    private final LRUMap<Constructor<Object>, KFunction<Object>> javaConstructorToKotlin;
    @NotNull
    private final LRUMap<Method, KFunction<?>> javaMethodToKotlin;
    @NotNull
    private final LRUMap<Constructor<Object>, ConstructorValueCreator<?>> javaConstructorToValueCreator;
    @NotNull
    private final LRUMap<Method, MethodValueCreator<?>> javaMethodToValueCreator;
    @NotNull
    private final LRUMap<AnnotatedConstructor, Boolean> javaConstructorIsCreatorAnnotated;
    @NotNull
    private final LRUMap<AnnotatedMember, BooleanTriState> javaMemberIsRequired;
    @NotNull
    private final LRUMap<AnnotatedMethod, Boolean> kotlinGeneratedMethod;

    public ReflectionCache(int reflectionCacheSize) {
        this.javaClassToKotlin = new LRUMap(reflectionCacheSize, reflectionCacheSize);
        this.javaConstructorToKotlin = new LRUMap(reflectionCacheSize, reflectionCacheSize);
        this.javaMethodToKotlin = new LRUMap(reflectionCacheSize, reflectionCacheSize);
        this.javaConstructorToValueCreator = new LRUMap(reflectionCacheSize, reflectionCacheSize);
        this.javaMethodToValueCreator = new LRUMap(reflectionCacheSize, reflectionCacheSize);
        this.javaConstructorIsCreatorAnnotated = new LRUMap(reflectionCacheSize, reflectionCacheSize);
        this.javaMemberIsRequired = new LRUMap(reflectionCacheSize, reflectionCacheSize);
        this.kotlinGeneratedMethod = new LRUMap(reflectionCacheSize, reflectionCacheSize);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KClass<Object> kotlinFromJava(@NotNull Class<Object> key) {
        KClass kClass;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        KClass kClass2 = (KClass)this.javaClassToKotlin.get(key);
        if (kClass2 == null) {
            KClass it = JvmClassMappingKt.getKotlinClass(key);
            boolean bl = false;
            kClass = (KClass)this.javaClassToKotlin.putIfAbsent(key, (Object)it);
            if (kClass == null) {
                void var3_3;
                kClass = var3_3;
            }
        } else {
            kClass = kClass2;
        }
        return kClass;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KFunction<Object> kotlinFromJava(@NotNull Constructor<Object> key) {
        KFunction kFunction;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        KFunction kFunction2 = (KFunction)this.javaConstructorToKotlin.get(key);
        if (kFunction2 == null) {
            KFunction kFunction3 = ReflectJvmMapping.getKotlinFunction(key);
            if (kFunction3 == null) {
                kFunction = null;
            } else {
                KFunction it = kFunction3;
                boolean bl = false;
                kFunction = (KFunction)this.javaConstructorToKotlin.putIfAbsent(key, (Object)it);
                if (kFunction == null) {
                    void var3_3;
                    kFunction = var3_3;
                }
            }
        } else {
            kFunction = kFunction2;
        }
        return kFunction;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KFunction<?> kotlinFromJava(@NotNull Method key) {
        KFunction kFunction;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        KFunction kFunction2 = (KFunction)this.javaMethodToKotlin.get((Object)key);
        if (kFunction2 == null) {
            KFunction kFunction3 = ReflectJvmMapping.getKotlinFunction((Method)key);
            if (kFunction3 == null) {
                kFunction = null;
            } else {
                KFunction it = kFunction3;
                boolean bl = false;
                kFunction = (KFunction)this.javaMethodToKotlin.putIfAbsent((Object)key, (Object)it);
                if (kFunction == null) {
                    void var3_3;
                    kFunction = var3_3;
                }
            }
        } else {
            kFunction = kFunction2;
        }
        return kFunction;
    }

    @Nullable
    public final ValueCreator<?> valueCreatorFromJava(@NotNull AnnotatedWithParams _withArgsCreator) {
        ValueCreator valueCreator;
        Intrinsics.checkNotNullParameter((Object)_withArgsCreator, (String)"_withArgsCreator");
        AnnotatedWithParams annotatedWithParams = _withArgsCreator;
        if (annotatedWithParams instanceof AnnotatedConstructor) {
            ConstructorValueCreator<Object> constructorValueCreator;
            Constructor constructor = ((AnnotatedConstructor)_withArgsCreator).getAnnotated();
            if (constructor == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.reflect.Constructor<kotlin.Any>");
            }
            Constructor constructor2 = constructor;
            ConstructorValueCreator<Object> constructorValueCreator2 = (ConstructorValueCreator<Object>)this.javaConstructorToValueCreator.get((Object)constructor2);
            if (constructorValueCreator2 == null) {
                KFunction<Object> kFunction = this.kotlinFromJava(constructor2);
                if (kFunction == null) {
                    constructorValueCreator = null;
                } else {
                    KFunction<Object> it = kFunction;
                    boolean bl = false;
                    ConstructorValueCreator<Object> value = new ConstructorValueCreator<Object>(it);
                    constructorValueCreator = (ConstructorValueCreator<Object>)this.javaConstructorToValueCreator.putIfAbsent((Object)constructor2, value);
                    if (constructorValueCreator == null) {
                        constructorValueCreator = value;
                    }
                }
            } else {
                constructorValueCreator = constructorValueCreator2;
            }
            valueCreator = constructorValueCreator;
        } else if (annotatedWithParams instanceof AnnotatedMethod) {
            MethodValueCreator<?> methodValueCreator;
            Method method = ((AnnotatedMethod)_withArgsCreator).getAnnotated();
            if (method == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.reflect.Method");
            }
            Method method2 = method;
            MethodValueCreator<?> methodValueCreator2 = (MethodValueCreator<?>)this.javaMethodToValueCreator.get((Object)method2);
            if (methodValueCreator2 == null) {
                KFunction<?> kFunction = this.kotlinFromJava(method2);
                if (kFunction == null) {
                    methodValueCreator = null;
                } else {
                    KFunction<?> it = kFunction;
                    boolean bl = false;
                    MethodValueCreator<?> value = MethodValueCreator.Companion.of(it);
                    methodValueCreator = (MethodValueCreator<?>)this.javaMethodToValueCreator.putIfAbsent((Object)method2, value);
                    if (methodValueCreator == null) {
                        methodValueCreator = value;
                    }
                }
            } else {
                methodValueCreator = methodValueCreator2;
            }
            valueCreator = methodValueCreator;
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Expected a constructor or method to create a Kotlin object, instead found ", (Object)_withArgsCreator.getAnnotated().getClass().getName()));
        }
        return valueCreator;
    }

    public final boolean checkConstructorIsCreatorAnnotated(@NotNull AnnotatedConstructor key, @NotNull Function1<? super AnnotatedConstructor, Boolean> calc) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(calc, (String)"calc");
        Boolean bl2 = (Boolean)this.javaConstructorIsCreatorAnnotated.get((Object)key);
        if (bl2 == null) {
            boolean it = (Boolean)calc.invoke((Object)key);
            boolean bl3 = false;
            Boolean bl4 = (Boolean)this.javaConstructorIsCreatorAnnotated.putIfAbsent((Object)key, (Object)it);
            bl = bl4 == null ? it : bl4;
        } else {
            bl = bl2;
        }
        return bl;
    }

    @Nullable
    public final Boolean javaMemberIsRequired(@NotNull AnnotatedMember key, @NotNull Function1<? super AnnotatedMember, Boolean> calc) {
        Boolean bl;
        Boolean bl2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(calc, (String)"calc");
        BooleanTriState booleanTriState = (BooleanTriState)this.javaMemberIsRequired.get((Object)key);
        Boolean bl3 = bl2 = booleanTriState == null ? null : booleanTriState.getValue();
        if (bl2 == null) {
            Boolean it = (Boolean)calc.invoke((Object)key);
            boolean bl4 = false;
            BooleanTriState booleanTriState2 = (BooleanTriState)this.javaMemberIsRequired.putIfAbsent((Object)key, (Object)BooleanTriState.Companion.fromBoolean(it));
            if (booleanTriState2 == null) {
                bl = it;
            } else {
                bl = booleanTriState2.getValue();
                if (bl == null) {
                    bl = it;
                }
            }
        } else {
            bl = bl2;
        }
        return bl;
    }

    public final boolean isKotlinGeneratedMethod(@NotNull AnnotatedMethod key, @NotNull Function1<? super AnnotatedMethod, Boolean> calc) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(calc, (String)"calc");
        Boolean bl2 = (Boolean)this.kotlinGeneratedMethod.get((Object)key);
        if (bl2 == null) {
            boolean it = (Boolean)calc.invoke((Object)key);
            boolean bl3 = false;
            Boolean bl4 = (Boolean)this.kotlinGeneratedMethod.putIfAbsent((Object)key, (Object)it);
            bl = bl4 == null ? it : bl4;
        } else {
            bl = bl2;
        }
        return bl;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \b2\u00020\u0001:\u0004\b\t\n\u000bB\u0011\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState;", "", "value", "", "(Ljava/lang/Boolean;)V", "getValue", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "Companion", "Empty", "False", "True", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$True;", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$False;", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$Empty;", "jackson-module-kotlin"})
    public static abstract class BooleanTriState {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Boolean value;
        @NotNull
        private static final True TRUE = new True();
        @NotNull
        private static final False FALSE = new False();
        @NotNull
        private static final Empty EMPTY = new Empty();

        private BooleanTriState(Boolean value) {
            this.value = value;
        }

        @Nullable
        public final Boolean getValue() {
            return this.value;
        }

        public /* synthetic */ BooleanTriState(Boolean value, DefaultConstructorMarker $constructor_marker) {
            this(value);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$True;", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState;", "()V", "jackson-module-kotlin"})
        public static final class True
        extends BooleanTriState {
            public True() {
                super(true, null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$False;", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState;", "()V", "jackson-module-kotlin"})
        public static final class False
        extends BooleanTriState {
            public False() {
                super(false, null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$Empty;", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState;", "()V", "jackson-module-kotlin"})
        public static final class Empty
        extends BooleanTriState {
            public Empty() {
                super(null, null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$Companion;", "", "()V", "EMPTY", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$Empty;", "FALSE", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$False;", "TRUE", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState$True;", "fromBoolean", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState;", "value", "", "(Ljava/lang/Boolean;)Lcom/fasterxml/jackson/module/kotlin/ReflectionCache$BooleanTriState;", "jackson-module-kotlin"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BooleanTriState fromBoolean(@Nullable Boolean value) {
                BooleanTriState booleanTriState;
                Boolean bl = value;
                if (bl == null) {
                    booleanTriState = EMPTY;
                } else if (Intrinsics.areEqual((Object)bl, (Object)true)) {
                    booleanTriState = TRUE;
                } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
                    booleanTriState = FALSE;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return booleanTriState;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

