/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.factories;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonAnyFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonBooleanFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNullFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.FormatVisitorFactory;
import com.fasterxml.jackson.module.jsonSchema.factories.JsonSchemaFactory;
import com.fasterxml.jackson.module.jsonSchema.types.AnySchema;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.types.BooleanSchema;
import com.fasterxml.jackson.module.jsonSchema.types.IntegerSchema;
import com.fasterxml.jackson.module.jsonSchema.types.NullSchema;
import com.fasterxml.jackson.module.jsonSchema.types.NumberSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;

public class SchemaFactoryWrapper
implements JsonFormatVisitorWrapper {
    protected FormatVisitorFactory visitorFactory;
    protected JsonSchemaFactory schemaProvider;
    protected SerializerProvider provider;
    protected JsonSchema schema;

    public SchemaFactoryWrapper() {
        this(null);
    }

    public SchemaFactoryWrapper(SerializerProvider serializerProvider) {
        this.provider = serializerProvider;
        this.schemaProvider = new JsonSchemaFactory();
        this.visitorFactory = new FormatVisitorFactory();
    }

    public SerializerProvider getProvider() {
        return this.provider;
    }

    public void setProvider(SerializerProvider serializerProvider) {
        this.provider = serializerProvider;
    }

    public JsonAnyFormatVisitor expectAnyFormat(JavaType javaType) {
        AnySchema anySchema = this.schemaProvider.anySchema();
        this.schema = anySchema;
        return this.visitorFactory.anyFormatVisitor(anySchema);
    }

    public JsonArrayFormatVisitor expectArrayFormat(JavaType javaType) {
        ArraySchema arraySchema = this.schemaProvider.arraySchema();
        this.schema = arraySchema;
        return this.visitorFactory.arrayFormatVisitor(this.provider, arraySchema);
    }

    public JsonBooleanFormatVisitor expectBooleanFormat(JavaType javaType) {
        BooleanSchema booleanSchema = this.schemaProvider.booleanSchema();
        this.schema = booleanSchema;
        return this.visitorFactory.booleanFormatVisitor(booleanSchema);
    }

    public JsonIntegerFormatVisitor expectIntegerFormat(JavaType javaType) {
        IntegerSchema integerSchema = this.schemaProvider.integerSchema();
        this.schema = integerSchema;
        return this.visitorFactory.integerFormatVisitor(integerSchema);
    }

    public JsonNullFormatVisitor expectNullFormat(JavaType javaType) {
        NullSchema nullSchema = this.schemaProvider.nullSchema();
        this.schema = nullSchema;
        return this.visitorFactory.nullFormatVisitor(nullSchema);
    }

    public JsonNumberFormatVisitor expectNumberFormat(JavaType javaType) {
        NumberSchema numberSchema = this.schemaProvider.numberSchema();
        this.schema = numberSchema;
        return this.visitorFactory.numberFormatVisitor(numberSchema);
    }

    public JsonObjectFormatVisitor expectObjectFormat(JavaType javaType) {
        ObjectSchema objectSchema = this.schemaProvider.objectSchema();
        this.schema = objectSchema;
        return this.visitorFactory.objectFormatVisitor(this.provider, objectSchema);
    }

    public JsonStringFormatVisitor expectStringFormat(JavaType javaType) {
        StringSchema stringSchema = this.schemaProvider.stringSchema();
        this.schema = stringSchema;
        return this.visitorFactory.stringFormatVisitor(stringSchema);
    }

    public JsonMapFormatVisitor expectMapFormat(JavaType javaType) throws JsonMappingException {
        ObjectSchema objectSchema = this.schemaProvider.objectSchema();
        this.schema = objectSchema;
        return this.visitorFactory.mapFormatVisitor(this.provider, objectSchema);
    }

    public JsonSchema finalSchema() {
        return this.schema;
    }
}

